/*
 * Decompiled with CFR 0.152.
 */
package gep.data;

import fig.basic.Option;
import fig.basic.Pair;
import fig.exec.Execution;
import gep.comparisons.TargetModel;
import gep.data.DataSource;
import gep.pmcmc.Generator;
import gep.timeseries.Measurements;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import nuts.util.CollUtils;
import nuts.util.Indexer;

public class GeneratedData
implements DataSource {
    @Option
    public Random dataRandom = new Random(1L);
    @Option
    public Random trueParamRandom = new Random(1L);
    @Option
    public double samplingDelta = 1.0;
    @Option
    public int nDataPtPerSeries = 10;
    @Option
    public int nStates = 10;
    @Option
    public int obsSize = 4;
    @Option
    public double transitionDensity = 0.2;
    @Option
    public double smallRate = 0.01;
    @Option
    public double largeSmallRateDiff = 0.5;
    private TargetModel _model = null;
    private Set<String> _possibleObs = null;

    private TargetModel model() {
        if (this._model != null) {
            return this._model;
        }
        this._model = TargetModel.randomTargetType1(this.trueParamRandom, this.nStates, this.obsSize, this.transitionDensity, this.smallRate, this.largeSmallRateDiff);
        this._model.save(new File(Execution.getFile("model")));
        return this._model;
    }

    @Override
    public Measurements next(Indexer<String> indexer) {
        Pair<List<Integer>, List<Integer>> generated = Generator.generate(this.dataRandom, this.model(), this.nDataPtPerSeries, this.samplingDelta);
        List<Integer> states = generated.getSecond();
        ArrayList<Double> times = CollUtils.list();
        double currentTime = 0.0;
        for (int currentSqIdx = 0; currentSqIdx < states.size(); ++currentSqIdx) {
            times.add(currentTime);
            currentTime += this.samplingDelta;
        }
        return new Measurements(times, states);
    }

    @Override
    public Set<String> possibleObservations() {
        if (this._possibleObs != null) {
            return this._possibleObs;
        }
        this._possibleObs = CollUtils.set();
        for (int i = 0; i < this.obsSize; ++i) {
            this._possibleObs.add("obs" + i);
        }
        return this._possibleObs;
    }
}

