/*
 * Decompiled with CFR 0.152.
 */
package gep.pmcmc;

import fig.basic.Pair;
import gep.model.Predictives;
import gep.model.SplitContext;
import gep.model.SufficientStatistics;
import gep.model.SufficientStatisticsImpl;
import gep.pmcmc.Generator;
import gep.pmcmc.PartialHiddenState;
import gep.timeseries.Event;
import gep.timeseries.Measurements;
import java.util.ArrayList;
import java.util.Random;
import nuts.util.CollUtils;
import pty.smc.ParticleKernel;

public final class SMCKernel<S>
implements ParticleKernel<PartialHiddenState<S>> {
    private final Predictives<S, S> predictiveDistributions;
    private final Measurements observations;
    private final S begSymbol;

    public SMCKernel(Predictives<S, S> predictiveDistributions, Measurements obs, S begSymbol) {
        this.predictiveDistributions = predictiveDistributions;
        this.observations = obs;
        this.begSymbol = begSymbol;
    }

    @Override
    public PartialHiddenState<S> getInitial() {
        return new PartialHiddenState(new SufficientStatisticsImpl(), new ArrayList(), 0);
    }

    @Override
    public int nIterationsLeft(PartialHiddenState<S> partialState) {
        return this.nObservations() - partialState.nObservationAskedToCover();
    }

    public double observationTimes(int i) {
        return this.observations.getTime(i);
    }

    public int observation(int i) {
        return this.observations.getValue(i);
    }

    public int nObservations() {
        return this.observations.size();
    }

    @Override
    public Pair<PartialHiddenState<S>, Double> next(Random rand, PartialHiddenState<S> current) {
        int obsIndexToCover = current.nObservationAskedToCover();
        double timeOfObservationToAdd = this.observationTimes(obsIndexToCover);
        ArrayList<Event<S>> eventsList = CollUtils.list(current.eventsList());
        double delta = timeOfObservationToAdd - current.eventsLength();
        if (delta < 0.0) {
            SufficientStatisticsImpl<S, S> newSS = new SufficientStatisticsImpl<S, S>(current.suffStats());
            return Pair.makePair(new PartialHiddenState<S>(newSS, eventsList, current.nObservationAskedToCover() + 1), 0.0);
        }
        SufficientStatistics<S, S> newSS = Generator.generate(current.suffStats(), this.predictiveDistributions, rand, eventsList, delta, Integer.MAX_VALUE, this.begSymbol);
        double logW = 0.0;
        if (eventsList.size() < 2) {
            throw new RuntimeException();
        }
        Event e1 = (Event)eventsList.get(eventsList.size() - 2);
        Event e2 = (Event)eventsList.get(eventsList.size() - 1);
        Object sc = Event.contents(e1, e2);
        double right = Event.right(e1, e2);
        for (int i = obsIndexToCover; i < this.nObservations(); ++i) {
            if (this.observationTimes(i) > right) {
                if (i != obsIndexToCover) break;
                throw new RuntimeException();
            }
            if (this.observation(i) == ((SplitContext)sc).getX()) continue;
            logW = Double.NEGATIVE_INFINITY;
            break;
        }
        return Pair.makePair(new PartialHiddenState<S>(newSS, eventsList, current.nObservationAskedToCover() + 1), logW);
    }

    public static Measurements randomObservations(Random rand, int nSymb, double delta, int nObs) {
        ArrayList<Double> times = CollUtils.list();
        ArrayList<Integer> values = CollUtils.list();
        double cTime = 0.0;
        for (int i = 0; i < nObs; ++i) {
            times.add(cTime);
            values.add(rand.nextInt(nSymb));
            cTime += delta;
        }
        return new Measurements(times, values);
    }
}

