/*
 * Decompiled with CFR 0.152.
 */
package gep.timeseries;

import nuts.util.MathUtils;

public class Event<S> {
    public final double _right;
    public final double _left;
    public final S _contents;

    public Event(double left, double right, S contents) {
        if (right < left || left < 0.0 || Double.isNaN(left) || Double.isNaN(right)) {
            throw new RuntimeException();
        }
        this._left = left;
        this._right = right;
        this._contents = contents;
    }

    public double right() {
        return this._right;
    }

    public double delta() {
        return this._right - this._left;
    }

    public String toString() {
        return "[" + this._left + "," + this._right + "," + this._contents + "]";
    }

    public static <S> double left(Event<S> e1, Event<S> e2) {
        MathUtils.checkClose(e1._right, e2._left);
        return e2._left;
    }

    public static <S> double right(Event<S> e1, Event<S> e2) {
        MathUtils.checkClose(e1._right, e2._left);
        return e2._right;
    }

    public static <S> S contents(Event<S> e1, Event<S> e2) {
        MathUtils.checkClose(e1._right, e2._left);
        return e1._contents;
    }

    public static <S> S tempcontents(Event<S> e1) {
        return e1._contents;
    }
}

