/*
 * Decompiled with CFR 0.152.
 */
package goblin;

import fig.basic.IOUtils;
import fig.basic.LogInfo;
import fig.basic.NumUtils;
import fig.basic.Option;
import fig.basic.Parallelizer;
import fig.exec.Execution;
import fig.prob.SampleUtils;
import goblin.CognateId;
import goblin.CognateSet;
import goblin.DataPrepUtils;
import goblin.DerivationTree;
import goblin.HLBaseMeasures;
import goblin.HLFeatureExtractor;
import goblin.HLIntegrator;
import goblin.ObservationsTracker;
import goblin.Taxon;
import goblin.TreeSamplers;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.SortedSet;
import ma.AffineGapAlignmentSampler;
import nuts.io.Extensions;
import nuts.io.IO;
import nuts.math.MeasureZeroException;
import nuts.maxent.FeatureExtractor;
import nuts.maxent.LabeledInstance;
import nuts.maxent.MaxentClassifier;
import nuts.util.All2OneMap;
import nuts.util.Arbre;
import nuts.util.Counter;
import nuts.util.CounterMap;
import nuts.util.MathUtils;
import nuts.util.Tree;
import pepper.Encodings;
import pepper.editmodel.Utils;
import sage.LikelihoodModel;

public final class HLParams
implements Serializable,
LikelihoodModel {
    private static final long serialVersionUID = 2L;
    public final Encodings enc;
    private final Map<Taxon, double[][]> rootParams;
    private final Map<Taxon, HLBranchParams> branchParams;
    public static final int MAXLINSERT = 1000;
    public static final int MAXLTOP = 10000;
    public static final int N_REJ_SAMPLING = 20;

    @Override
    public double partialLogLikelihood(Arbre<DerivationTree.LineagedNode> state, CognateId id) {
        double result = 0.0;
        Counter<LabeledInstance<HLContext, HLOutcome>> suffStats = new Counter<LabeledInstance<HLContext, HLOutcome>>();
        HLParams.addSuffStatsFromLineagedTree(suffStats, state, this.enc);
        for (LabeledInstance<HLContext, HLOutcome> op : suffStats.keySet()) {
            result += suffStats.getCount(op) * Math.log(this.pr(op));
        }
        return result;
    }

    @Override
    public double fullLogLikelihood(Arbre<DerivationTree.DerivationNode> state, CognateId id) {
        return this.partialLogLikelihood(DerivationTree.fullLineage(state), id);
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        for (Taxon lang : this.branchParams.keySet()) {
            result.append("Branch params for " + lang + ":\n");
            result.append(this.branchParams.get(lang).toString(lang) + "\n");
        }
        return result.toString();
    }

    public Map<Taxon, HLBranchParams> getBranchParams() {
        return Collections.unmodifiableMap(this.branchParams);
    }

    public double getRootLogPr(String word, Taxon lang) {
        double[][] prs = this.rootParams.get(lang);
        double result = 0.0;
        for (int pos = 0; pos < word.length() + 1; ++pos) {
            int prev = this.enc.idAt(word, pos - 1);
            int cur = this.enc.idAt(word, pos);
            result += Math.log(prs[prev][cur]);
        }
        return result;
    }

    public double rootPr(Taxon lang, int prevCode, int currentCode) {
        return this.rootParams.get(lang)[prevCode][currentCode];
    }

    public double getRootPr(char prefix, String segment, Taxon lang) {
        double[][] prs = this.rootParams.get(lang);
        double result = 1.0;
        for (int pos = 0; pos < segment.length(); ++pos) {
            int prev = pos == 0 ? this.enc.char2PhoneId(prefix) : this.enc.char2PhoneId(segment.charAt(pos - 1));
            int cur = this.enc.char2PhoneId(segment.charAt(pos));
            result *= prs[prev][cur];
        }
        return result;
    }

    public HLParams(Map<Taxon, HLBranchParams> branchParams, Map<Taxon, double[][]> rootParams, Encodings enc) {
        this.enc = enc;
        for (Taxon lang : rootParams.keySet()) {
            HLParams.check(rootParams.get(lang), enc);
        }
        this.rootParams = rootParams;
        this.branchParams = branchParams;
    }

    public double pr(LabeledInstance<HLContext, HLOutcome> instance) {
        return this.pr(instance.getInput(), instance.getLabel());
    }

    public double pr(HLContext context, HLOutcome outcome) {
        Taxon lang = context.botLang;
        if (context.type == ChoiceType.ROOT) {
            return this.rootParams.get(lang)[context.prev][outcome.outcome];
        }
        return this.branchParams.get(lang).pr(context, outcome);
    }

    public static int sampleMultinomial(Random random, float[] probs) {
        double v = random.nextDouble();
        double sum = 0.0;
        for (int i = 0; i < probs.length; ++i) {
            if (!(v < (sum += (double)probs[i]))) continue;
            return i;
        }
        throw new RuntimeException(sum + " < " + v);
    }

    public static <T> HLParams createHLParamsFromMaxent(final Encodings enc, final MaxentClassifier<HLContext, HLOutcome, T> maxentClassifier, final Set<Taxon> languages, int nThreads) {
        final HashMap<Taxon, HLBranchParams> branchParams = new HashMap<Taxon, HLBranchParams>();
        final HashMap<Taxon, double[][]> rootParams = new HashMap<Taxon, double[][]>();
        if (HLFeatureExtractor.collapseLanguage()) {
            throw new RuntimeException();
        }
        LogInfo.track("Caching mutation probabilities");
        Parallelizer<Taxon> par = new Parallelizer<Taxon>(nThreads);
        par.setPrimaryThread();
        par.process(new ArrayList<Taxon>(languages), new Parallelizer.Processor<Taxon>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void process(Taxon lang, int i, int n, boolean log) {
                if (log) {
                    LogInfo.logs("Language " + i + "/" + languages.size());
                }
                HLBranchParams hlBP = HLParams.createBranchParamsFromMaxent(enc, maxentClassifier, lang);
                double[][] hlRD = HLParams.createRootDistFromMaxent(enc, maxentClassifier, lang);
                Map map = branchParams;
                synchronized (map) {
                    branchParams.put(lang, hlBP);
                }
                map = rootParams;
                synchronized (map) {
                    rootParams.put(lang, hlRD);
                }
            }
        });
        LogInfo.end_track();
        return new HLParams(branchParams, rootParams, enc);
    }

    private static <T> double[][] createRootDistFromMaxent(Encodings enc, MaxentClassifier<HLContext, HLOutcome, T> maxentClassifier, Taxon lang) {
        int N = enc.getNumberOfPhonemes();
        double[][] result = new double[N][N];
        for (int prev = 0; prev < N; ++prev) {
            HLContext context = HLParams.createRootContext(lang, enc, prev);
            SortedSet<HLOutcome> outcomes = maxentClassifier.getLabels(context);
            double[] prs = maxentClassifier.logProb(context);
            int i = 0;
            for (HLOutcome outcome : outcomes) {
                result[prev][outcome.outcome] = Math.exp(prs[i]);
                ++i;
            }
        }
        return result;
    }

    private static <T> HLBranchParams createBranchParamsFromMaxent(Encodings enc, final MaxentClassifier<HLContext, HLOutcome, T> maxentClassifier, final Taxon lang) {
        return new HLParamsBranchPopulator(enc){

            @Override
            public void populateIns(int top, int prev, float[] result) {
                this.populate(top, prev, result, ChoiceType.INS);
            }

            @Override
            public void populateSub(int top, int prev, float[] result) {
                this.populate(top, prev, result, ChoiceType.SUBDEL);
            }

            private void populate(int top, int prev, float[] result, ChoiceType type) {
                HLContext context = new HLContext(lang, this.enc, type, prev, top);
                SortedSet outcomes = maxentClassifier.getLabels(context);
                double[] prs = maxentClassifier.logProb(context);
                int i = 0;
                for (HLOutcome outcome : outcomes) {
                    result[outcome.outcome] = (float)Math.exp(prs[i]);
                    ++i;
                }
            }
        }.createParams(false);
    }

    private static void check(double[][] topLm2, Encodings enc2) {
        int N = enc2.getNumberOfPhonemes();
        if (topLm2.length != N || topLm2.length != N) {
            throw new RuntimeException("HLParams.check 1 failed");
        }
        for (int x = 0; x < N; ++x) {
            if (MathUtils.isProb(topLm2[x])) continue;
            throw new RuntimeException("HLParams.check 2 failed");
        }
    }

    private static void check(float[][][] dist, Encodings enc, boolean isIns) {
        int N = enc.getNumberOfPhonemes();
        int B = enc.getBoundaryPhoneId();
        if (dist.length != N || dist[0].length != N || dist[0][0].length != N + 1) {
            throw new RuntimeException("HLParams.check 3 failed");
        }
        for (int x = 0; x < N; ++x) {
            for (int y = 0; y < N; ++y) {
                int z;
                if ((double)dist[x][y][B] != 0.0) {
                    throw new RuntimeException("HLParams.check 4 failed");
                }
                if (x == B) {
                    if (isIns) {
                        if (MathUtils.isProb(dist[x][y])) continue;
                        throw new RuntimeException("HLParams.check 5 failed");
                    }
                    for (z = 0; z < N + 1; ++z) {
                        if ((double)dist[x][y][z] == 0.0) continue;
                        throw new RuntimeException("HLParams.check 6 failed");
                    }
                    continue;
                }
                if (x != B && y == B && isIns) {
                    for (z = 0; z < N + 1; ++z) {
                        if ((double)dist[x][y][z] == 0.0) continue;
                        throw new RuntimeException("HLParams.check 7 failed");
                    }
                    continue;
                }
                if (MathUtils.isProb(dist[x][y])) continue;
                throw new RuntimeException("HLParams.check 8 failed. Norm is:");
            }
        }
    }

    public CognateSet generateCognateSet(Tree<String> languages, Random rand, int n) {
        CognateSet result = new CognateSet();
        ObservationsTracker obs = null;
        for (int i = 0; i < n; ++i) {
            Arbre<DerivationTree.DerivationNode> sample = this.generate(languages, rand);
            if (obs == null) {
                obs = ObservationsTracker.modernObservationsTracker(sample);
            }
            CognateId id = new CognateId("randomlyGenerated-" + i);
            DataPrepUtils.forgetUnobserved(sample, obs);
            result.addCognate(id, sample, obs);
        }
        return result;
    }

    public Arbre<DerivationTree.DerivationNode> generate(Tree<String> languages, Random rand) {
        return this.generate(languages, null, rand);
    }

    private Arbre<DerivationTree.DerivationNode> generate(Tree<String> languages, String parent, Random rand) {
        String word;
        Taxon lang = new Taxon(languages.getLabel());
        DerivationTree.Derivation d = null;
        if (parent == null) {
            word = this.generateRoot(lang, rand);
        } else {
            d = this.branchParams.get(lang).generateEvolution(parent, rand);
            word = d.getCurrentWord();
        }
        DerivationTree.DerivationNode derivNode = new DerivationTree.DerivationNode(lang, word, d);
        Arbre<DerivationTree.DerivationNode> result = new Arbre<DerivationTree.DerivationNode>(derivNode);
        for (Tree<String> childrenLang : languages.getChildren()) {
            result.addLeaves(this.generate(childrenLang, word, rand));
        }
        return result;
    }

    public String generateRoot(Taxon lang, Random rand) {
        int p;
        double[] dist;
        int draw;
        double[][] topLm = this.rootParams.get(lang);
        char B = this.enc.phoneId2Char(this.enc.getBoundaryPhoneId());
        StringBuilder result = new StringBuilder();
        result.append(B);
        for (int i = 0; i < 10000 && (draw = SampleUtils.sampleMultinomial(rand, dist = topLm[p = this.enc.char2PhoneId(HLParams.head(result))])) != this.enc.getBoundaryPhoneId(); ++i) {
            result.append(this.enc.phoneId2Char(draw));
        }
        return result.subSequence(1, result.length()).toString();
    }

    private static char head(StringBuilder result) {
        return result.charAt(result.length() - 1);
    }

    public static final <F> HLParams maxentSpecifiedParams(Encodings enc, FeatureExtractor<LabeledInstance<HLContext, HLOutcome>, F> extractor, Counter<F> featureWeights, Set<Taxon> languages, int threads) {
        MaxentClassifier<HLContext, HLOutcome, F> maxent = MaxentClassifier.createMaxentClassifierFromWeights(new HLBaseMeasures(enc), featureWeights, extractor);
        return HLParams.createHLParamsFromMaxent(enc, maxent, languages, threads);
    }

    public static final HLParams mixture(HLParams param1, HLParams param2, double p1Pr) {
        Map<Taxon, HLBranchParams> branchParams;
        HashMap<Taxon, double[][]> rootParams;
        if (p1Pr < 0.0 || p1Pr > 1.0) {
            throw new RuntimeException("Internal error 1 in HLParams.mixture");
        }
        if (p1Pr == 1.0) {
            return param1;
        }
        if (p1Pr == 0.0) {
            return param2;
        }
        if (!param1.branchParams.keySet().equals(param2.branchParams.keySet()) || !param1.branchParams.keySet().equals(param1.rootParams.keySet())) {
            throw new RuntimeException("Internal error 2 in HLParams.mixture");
        }
        if (HLFeatureExtractor.collapseLanguage()) {
            Taxon lang = Taxon.dummy;
            rootParams = new All2OneMap<Taxon, double[][]>(Taxon.dummy, HLParams.mixture(param1.rootParams.get(lang), param2.rootParams.get(lang), p1Pr));
            branchParams = new All2OneMap<Taxon, HLBranchParams>(Taxon.dummy, HLParams.mixture(param1.branchParams.get(lang), param2.branchParams.get(lang), p1Pr));
        } else {
            branchParams = new HashMap<Taxon, HLBranchParams>();
            rootParams = new HashMap();
            for (Taxon lang : param1.branchParams.keySet()) {
                rootParams.put(lang, HLParams.mixture(param1.rootParams.get(lang), param2.rootParams.get(lang), p1Pr));
                branchParams.put(lang, HLParams.mixture(param1.branchParams.get(lang), param2.branchParams.get(lang), p1Pr));
            }
        }
        return new HLParams(branchParams, rootParams, param1.enc);
    }

    private static double[][] mixture(double[][] lm1, double[][] lm2, double pr) {
        double[][] result = new double[lm1.length][lm1[0].length];
        for (int i = 0; i < lm1.length; ++i) {
            for (int j = 0; j < lm1[0].length; ++j) {
                result[i][j] = pr * lm1[i][j] + (1.0 - pr) * lm2[i][j];
            }
        }
        return result;
    }

    private static HLBranchParams mixture(final HLBranchParams branchParams1, final HLBranchParams branchParams2, final double p1Pr) {
        return new HLParamsBranchPopulator(branchParams1.getEncodings()){

            @Override
            public void populateIns(int top, int prev, float[] result) {
                for (int i = 0; i < result.length; ++i) {
                    result[i] = (float)(p1Pr * branchParams1.ins(top, prev, i) + (1.0 - p1Pr) * branchParams2.ins(top, prev, i));
                }
            }

            @Override
            public void populateSub(int top, int prev, float[] result) {
                for (int i = 0; i < result.length; ++i) {
                    result[i] = (float)(p1Pr * branchParams1.sub(top, prev, i) + (1.0 - p1Pr) * branchParams2.sub(top, prev, i));
                }
            }
        }.createParams(false);
    }

    public static final HLParams createHLParamsFromWeights(Encodings enc, Set<Taxon> langs, HLFeatureExtractor extractor, Counter<Object> weights, boolean check, int threads) {
        if (check) {
            Set<Object> allFeatures = extractor.allPossibleFeatures(enc, langs);
            for (Object f : weights.keySet()) {
                if (allFeatures.contains(f)) continue;
                throw new RuntimeException("Feature not found..dont forget to include its template:" + f + "\nList was:" + extractor.featureTemplates + "\n(Also: check you set the correct applicationType!)");
            }
        }
        MaxentClassifier<HLContext, HLOutcome, Object> maxent = MaxentClassifier.createMaxentClassifierFromWeights(new HLBaseMeasures(enc), weights, extractor);
        return HLParams.createHLParamsFromMaxent(enc, maxent, langs, threads);
    }

    public static final HLParams createHLParamsFromTemplateWeights(Encodings enc, Set<Taxon> langs, HLFeatureExtractor extractor, List<Double> weightSpecs, int threads) {
        if (weightSpecs.size() != extractor.featureTemplates.size()) {
            throw new RuntimeException("Malformed weight specs: should max n feature templates");
        }
        Counter<Object> weights = new Counter<Object>();
        for (int i = 0; i < extractor.featureTemplates.size(); ++i) {
            HLFeatureExtractor.HLFeatureTemplate template = extractor.featureTemplates.get(i);
            for (Object feature : extractor.allPossibleFeatures(enc, langs, template)) {
                weights.setCount(feature, weightSpecs.get(i));
            }
        }
        return HLParams.createHLParamsFromWeights(enc, langs, extractor, weights, true, threads);
    }

    public static final HLParams randomHLParams(Random rand, Encodings enc, Set<Taxon> langs, HLFeatureExtractor extractor, double stdDev) {
        Set<Object> allFeatures = extractor.allPossibleFeatures(enc, langs);
        Counter<Object> weights = new Counter<Object>();
        for (Object feature : allFeatures) {
            weights.setCount(feature, SampleUtils.sampleGaussian(rand) * stdDev);
        }
        MaxentClassifier<HLContext, HLOutcome, Object> maxent = MaxentClassifier.createMaxentClassifierFromWeights(new HLBaseMeasures(enc), weights, extractor);
        return HLParams.createHLParamsFromMaxent(enc, maxent, langs, 1);
    }

    public static final HLParams randomHLParams(Random rand, Encodings enc, Set<Taxon> languages, boolean denyIndel) {
        Map<Taxon, HLBranchParams> branchParams;
        HashMap<Taxon, double[][]> rootParams;
        if (HLFeatureExtractor.collapseLanguage()) {
            Taxon lang = Taxon.dummy;
            rootParams = new All2OneMap<Taxon, double[][]>(Taxon.dummy, HLParams.randomRootParams(rand, enc));
            branchParams = new All2OneMap<Taxon, HLBranchParams>(Taxon.dummy, HLParams.randomHLBranchParams(rand, enc, denyIndel));
        } else {
            branchParams = new HashMap<Taxon, HLBranchParams>();
            rootParams = new HashMap();
            for (Taxon lang : languages) {
                rootParams.put(lang, HLParams.randomRootParams(rand, enc));
                branchParams.put(lang, HLParams.randomHLBranchParams(rand, enc, denyIndel));
            }
        }
        return new HLParams(branchParams, rootParams, enc);
    }

    public static final double[][] randomRootParams(Random rand, Encodings enc) {
        int N = enc.getNumberOfPhonemes();
        double[][] result = new double[N][N];
        for (int i = 0; i < N; ++i) {
            for (int j = 0; j < N; ++j) {
                result[i][j] = rand.nextDouble();
            }
            NumUtils.normalize(result[i]);
        }
        return result;
    }

    public static final HLBranchParams randomHLBranchParams(final Random rand, Encodings enc, final boolean denyIndel) {
        return new HLParamsBranchPopulator(enc){

            @Override
            public void populateIns(int top, int prev, float[] result) {
                if (denyIndel) {
                    result[HLParams.specialOutcomeCode((Encodings)this.enc)] = 1.0f;
                } else {
                    for (int i = 0; i < result.length; ++i) {
                        if (i == this.B()) continue;
                        result[i] = rand.nextFloat();
                    }
                }
            }

            @Override
            public void populateSub(int top, int prev, float[] result) {
                for (int i = 0; i < result.length - 1; ++i) {
                    if (i == this.B()) continue;
                    result[i] = rand.nextFloat();
                }
                if (!denyIndel) {
                    result[HLParams.specialOutcomeCode((Encodings)this.enc)] = rand.nextFloat();
                }
            }
        }.createParams(true);
    }

    public static void addSuffStatsFromLineagedTree(Counter<LabeledInstance<HLContext, HLOutcome>> counter, Arbre<DerivationTree.LineagedNode> a, Encodings enc) {
        HLParams.addRootSuffStats(counter, a.getContents().getDerivationNode().getWord(), a.getContents().getDerivationNode().getLanguage(), enc, a.root().getContents().getWindow());
        for (Arbre<DerivationTree.LineagedNode> node : a.root().nodes()) {
            if (node.isRoot()) continue;
            HLParams.addBranchSuffStats(counter, node.getContents().getDerivationNode().getDerivation(), node.getContents().getDerivationNode().getLanguage(), enc, node.getParent().getContents().getWindow(), node.getContents().getWindow());
        }
    }

    public static void addSuffStats(Counter<LabeledInstance<HLContext, HLOutcome>> counter, Arbre<DerivationTree.DerivationNode> a, Encodings enc) {
        HLParams.addSuffStatsFromLineagedTree(counter, DerivationTree.fullLineage(a), enc);
    }

    private static void addRootSuffStats(Counter<LabeledInstance<HLContext, HLOutcome>> counter, String rootWord, Taxon lang, Encodings enc, DerivationTree.Window originalWindow) {
        String B = "" + enc.phoneId2Char(enc.getBoundaryPhoneId());
        rootWord = B + rootWord + B;
        originalWindow = originalWindow.enlarge(rootWord.length(), 2.0);
        for (int i = 1; i < rootWord.length(); ++i) {
            if (!originalWindow.contains(i)) continue;
            counter.incrementCount(HLParams.createRootSuffStat(lang, enc, enc.char2PhoneId(rootWord.charAt(i - 1)), enc.char2PhoneId(rootWord.charAt(i))), 1.0);
        }
    }

    public static void addBranchSuffStats(Counter<LabeledInstance<HLContext, HLOutcome>> counter, DerivationTree.Derivation d, Taxon botLang, Encodings enc, DerivationTree.Window topWindow, DerivationTree.Window botWindow) {
        new BranchSuffStatExtractor(counter, d, botLang, enc, topWindow, botWindow).extract();
    }

    public Arbre<DerivationTree.DerivationNode> resampleAlignments(Arbre<DerivationTree.DerivationNode> arbre, Random rand) throws MeasureZeroException {
        arbre = arbre.root().copy();
        for (Arbre<DerivationTree.DerivationNode> node : arbre.nodes()) {
            if (node.isRoot()) continue;
            DerivationTree.DerivationNode contents = node.getContents();
            HLBranchParams params = this.branchParams.get(contents.getLanguage());
            int botWordLength = node.getContents().getWord().length();
            int topWordLength = node.getParent().getContents().getWord().length();
            DerivationTree.Derivation sampledDerivation = AffineGapAlignmentSampler.createAffineGapAlignmentSampler(node.getParent().getContents().getWord(), node.getContents().getWord(), params).sample(rand);
            DerivationTree.DerivationNode newContents = new DerivationTree.DerivationNode(contents.getLanguage(), contents.getWord(), sampledDerivation);
            node.setContents(newContents);
        }
        return arbre;
    }

    public Arbre<DerivationTree.DerivationNode> resampleDerivation(Arbre<DerivationTree.DerivationNode> arbre, Random rand) throws MeasureZeroException {
        ObservationsTracker obs = ObservationsTracker.modernObservationsTracker(arbre);
        TreeSamplers.PhyloTreeMCMCKernel kernel = TreeSamplers.createDefaultMixture();
        kernel.init(TreeSamplers.devNullSampleProcessor, arbre, obs, this, null, false, 20, CognateId.dummy);
        Arbre<DerivationTree.DerivationNode> result = arbre;
        for (int j = 0; j < HLIntegrator.leavesLength(arbre); ++j) {
            result = kernel.next(rand, result, null);
        }
        return result;
    }

    public static Set<Taxon> languages(Tree<String> topo) {
        HashSet<Taxon> result = new HashSet<Taxon>();
        result.add(new Taxon(topo.getLabel()));
        for (Tree<String> child : topo.getChildren()) {
            result.addAll(HLParams.languages(child));
        }
        return result;
    }

    public static int specialOutcomeCode(Encodings enc) {
        return enc.getNumberOfPhonemes();
    }

    public static LabeledInstance<HLContext, HLOutcome> createInsertSuffStat(Taxon botLang, Encodings enc, int prev, int top, int outcome) {
        return HLParams.createSuffStat(botLang, enc, ChoiceType.INS, prev, top, outcome);
    }

    public static LabeledInstance<HLContext, HLOutcome> createSubDelSuffStat(Taxon botLang, Encodings enc, int prev, int top, int outcome) {
        return HLParams.createSuffStat(botLang, enc, ChoiceType.SUBDEL, prev, top, outcome);
    }

    public static LabeledInstance<HLContext, HLOutcome> createRootSuffStat(Taxon lang, Encodings enc, int prev, int outcome) {
        return HLParams.createSuffStat(lang, enc, ChoiceType.ROOT, prev, -1, outcome);
    }

    public static LabeledInstance<HLContext, HLOutcome> createSuffStat(Taxon lang, Encodings enc, ChoiceType type, int prev, int top, int outcome) {
        if (type == ChoiceType.SUBDEL) {
            if (top == enc.getBoundaryPhoneId() && outcome != enc.getBoundaryPhoneId()) {
                throw new RuntimeException("Internal error 1 in createSuffStat");
            }
            if (top != enc.getBoundaryPhoneId() && outcome == enc.getBoundaryPhoneId()) {
                throw new RuntimeException("Internal error 2 in createSuffStat");
            }
        }
        if (type == ChoiceType.INS && top != enc.getBoundaryPhoneId() && prev == enc.getBoundaryPhoneId()) {
            throw new RuntimeException("Internal error 3 in createSuffStat");
        }
        return new LabeledInstance<HLContext, HLOutcome>(new HLOutcome(enc, outcome), new HLContext(lang, enc, type, prev, top));
    }

    public String fullToString() {
        StringBuilder result = new StringBuilder();
        for (Taxon lang : this.branchParams.keySet()) {
            for (HLContext ctxt : HLParams.allHLContexts(this.enc, lang)) {
                for (HLOutcome out : ctxt.allOutcomes()) {
                    result.append("P(" + HLParams.format(ctxt, out) + "|ctxt) = " + this.pr(ctxt, out) + '\n');
                }
            }
        }
        return result.toString();
    }

    public static StringBuilder compare(HLParams param1, HLParams param2, double threshold, Taxon root) {
        StringBuilder result = new StringBuilder();
        if (!param1.branchParams.keySet().equals(param2.branchParams.keySet()) || !param1.branchParams.keySet().equals(param1.rootParams.keySet())) {
            throw new RuntimeException("Internal error in HLParams.compare()");
        }
        for (Taxon lang : param1.branchParams.keySet()) {
            for (HLContext ctxt : HLParams.allHLContexts(param1.enc, lang)) {
                if (ctxt.botLang.equals(root) && ctxt.type != ChoiceType.ROOT || !ctxt.botLang.equals(root) && ctxt.type == ChoiceType.ROOT) continue;
                for (HLOutcome out : ctxt.allOutcomes()) {
                    double v2;
                    double v1 = param1.pr(ctxt, out);
                    double delta = Math.abs(v1 - (v2 = param2.pr(ctxt, out)));
                    if (!(delta >= threshold)) continue;
                    result.append(HLParams.format(ctxt, out) + "\t" + v1 + "\t" + v2 + "\t" + Math.abs(v1 - v2) + "\n");
                }
            }
        }
        return result;
    }

    public String toString(HLFeatureExtractor extractor) {
        HashMap<String, Double> minPr = new HashMap<String, Double>();
        HashMap<String, Double> maxPr = new HashMap<String, Double>();
        for (Taxon lang : this.branchParams.keySet()) {
            for (HLContext ctxt : HLParams.allHLContexts(this.enc, lang)) {
                for (HLOutcome out : ctxt.allOutcomes()) {
                    String key = extractor.toString(new LabeledInstance<HLContext, HLOutcome>(out, ctxt));
                    double currentPr = this.pr(ctxt, out);
                    if (minPr.containsKey(key)) {
                        minPr.put(key, Math.min(currentPr, (Double)minPr.get(key)));
                        maxPr.put(key, Math.max(currentPr, (Double)maxPr.get(key)));
                        continue;
                    }
                    minPr.put(key, currentPr);
                    maxPr.put(key, currentPr);
                }
            }
        }
        StringBuilder result = new StringBuilder();
        for (String key : minPr.keySet()) {
            result.append(key + " => P in [" + minPr.get(key) + ", " + maxPr.get(key) + "]\n");
        }
        return result.toString();
    }

    public static String format(HLContext ctxt, HLOutcome out) {
        return ctxt.toString(out.toString());
    }

    public static String format(LabeledInstance<HLContext, HLOutcome> li) {
        return HLParams.format(li.getInput(), li.getLabel());
    }

    public static HLContext createRootContext(Taxon root, Encodings enc, int prevPhone) {
        return new HLContext(root, enc, prevPhone);
    }

    public static List<HLContext> allHLContexts(Encodings enc, final Taxon lang) {
        final ArrayList<HLContext> result = new ArrayList<HLContext>();
        new HLParamsBranchPopulator(enc){

            @Override
            public void populateIns(int top, int prev, float[] a) {
                result.add(new HLContext(lang, this.enc, ChoiceType.INS, prev, top));
            }

            @Override
            public void populateSub(int top, int prev, float[] a) {
                result.add(new HLContext(lang, this.enc, ChoiceType.SUBDEL, prev, top));
            }
        }.callPopulators();
        int N = enc.getNumberOfPhonemes();
        for (int x = 0; x < N; ++x) {
            result.add(new HLContext(lang, enc, x));
        }
        return result;
    }

    public static void main(String[] args) {
        HLFeatureExtractor fe = new HLFeatureExtractor();
        Execution.run(args, new HLParamsReader(fe), "fe", fe);
    }

    public static void saveHLParamsInExec(HLParams params, String prefix) {
        HLParams.saveHLParamsInExec(params, prefix, null);
    }

    public static void saveHLParamsInExec(HLParams params, String prefix, Integer iteration) {
        String fileName = prefix + (iteration == null ? "" : Extensions.extension2String(iteration)) + ".HLParams";
        try {
            HLParams.saveHLParams(params, Utils.safeGetExecFilePath(fileName));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void saveHLParams(HLParams params, String file) throws IOException {
        ObjectOutputStream oos = IOUtils.openBinOut(file);
        oos.writeObject(params);
        oos.close();
    }

    public static HLParams restoreHLParams(String filePath) throws IOException, ClassNotFoundException {
        ObjectInputStream ois = IOUtils.openBinIn(filePath);
        return (HLParams)ois.readObject();
    }

    public static class HLParamsReader
    implements Runnable {
        @Option(required=true)
        public String path;
        @Option
        public ReaderMode mode = ReaderMode.DEFAULT;
        private final HLFeatureExtractor extractor;

        public HLParamsReader(HLFeatureExtractor extractor) {
            this.extractor = extractor;
        }

        @Override
        public void run() {
            HLParams p;
            try {
                p = HLParams.restoreHLParams(this.path);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            if (this.mode == ReaderMode.FINDNN) {
                Set<Taxon> langs = p.getBranchParams().keySet();
                CounterMap<Character, Character> costs = new CounterMap<Character, Character>();
                for (Taxon lang : langs) {
                    for (HLContext hlc : HLParams.allHLContexts(p.enc, lang)) {
                        if (hlc.type != ChoiceType.SUBDEL) continue;
                        for (HLOutcome out : hlc.allOutcomes()) {
                            if (out.isSpecial() || out.outcome == hlc.top) continue;
                            char topC = p.enc.phoneId2Char(hlc.top);
                            char botC = p.enc.phoneId2Char(out.outcome);
                            costs.setCount(Character.valueOf(topC), Character.valueOf(botC), Math.max(costs.getCount(Character.valueOf(topC), Character.valueOf(botC)), p.pr(hlc, out)));
                        }
                    }
                }
                Iterator<Taxon> iterator = costs.keySet().iterator();
                while (iterator.hasNext()) {
                    char c = ((Character)((Object)iterator.next())).charValue();
                    IO.so("" + c + ":" + costs.getCounter(Character.valueOf(c)).argMax() + " (" + costs.getCounter(Character.valueOf(c)).max() + ")");
                }
            } else if (this.mode == ReaderMode.GROUPBYFEAT) {
                LogInfo.logs(p.toString(this.extractor));
            } else {
                LogInfo.logs(p.fullToString());
            }
        }
    }

    public static enum ReaderMode {
        DEFAULT,
        FINDNN,
        GROUPBYFEAT;

    }

    public static final class HLContext
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public final Encodings enc;
        public final Taxon botLang;
        public final ChoiceType type;
        public final int top;
        public final int prev;

        public List<HLOutcome> allOutcomes() {
            ArrayList<HLOutcome> result = new ArrayList<HLOutcome>();
            int N = this.enc.getNumberOfPhonemes();
            for (int i = 0; i < (this.type == ChoiceType.ROOT ? N : N + 1); ++i) {
                if (i == this.enc.getBoundaryPhoneId() && this.type != ChoiceType.ROOT) continue;
                result.add(new HLOutcome(this.enc, i));
            }
            return result;
        }

        public HLContext(Taxon botLang, Encodings enc, int prev) {
            this(botLang, enc, ChoiceType.ROOT, prev, -1);
        }

        public HLContext(Taxon botLang, Encodings enc, ChoiceType type, int prev, int top) {
            if (type == null || enc == null || botLang == null) {
                throw new RuntimeException("Illegal args in HLContext constr---1");
            }
            if (type == ChoiceType.ROOT && top != -1) {
                throw new RuntimeException("Illegal args in HLContext constr---2");
            }
            this.botLang = HLFeatureExtractor.collapseLanguage() ? Taxon.dummy : botLang;
            this.enc = enc;
            this.type = type;
            this.prev = prev;
            this.top = top;
        }

        public char prevChar() {
            return this.enc.phoneId2Char(this.prev);
        }

        public char topChar() {
            return this.enc.phoneId2Char(this.top);
        }

        public boolean isRoot() {
            return this.type == ChoiceType.ROOT;
        }

        public String toString() {
            return this.toString("<?>");
        }

        public String toString(String outcome) {
            char sep;
            char p = this.prevChar();
            if (this.type == ChoiceType.ROOT) {
                return "[" + outcome + " / " + p + " _ " + (HLFeatureExtractor.collapseLanguage() ? "" : "@" + this.botLang) + ']';
            }
            char t = this.topChar();
            if (this.type == ChoiceType.SUBDEL) {
                sep = '-';
            } else if (this.type == ChoiceType.INS) {
                sep = '=';
            } else {
                throw new RuntimeException("Internal error in HLContext.toString()");
            }
            return "[" + t + " " + sep + "> " + outcome + " / " + p + " _ " + (HLFeatureExtractor.collapseLanguage() ? "" : "@" + this.botLang) + ']';
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.botLang.hashCode();
            result = 31 * result + this.type.hashCode();
            result = 31 * result + this.prev;
            result = 31 * result + this.top;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            HLContext other = (HLContext)obj;
            if (!this.botLang.equals(other.botLang)) {
                return false;
            }
            if (this.type != other.type) {
                return false;
            }
            if (this.prev != other.prev) {
                return false;
            }
            return this.top == other.top;
        }
    }

    public static enum ChoiceType {
        ROOT,
        SUBDEL,
        INS;

    }

    public static final class HLOutcome
    implements Comparable<HLOutcome>,
    Serializable {
        private static final long serialVersionUID = 1L;
        public final Encodings enc;
        public final int outcome;

        public HLOutcome(Encodings enc, int outcome) {
            this.enc = enc;
            this.outcome = outcome;
        }

        public String toString() {
            return this.isSpecial() ? "<S>" : "" + this.enc.phoneId2Char(this.outcome);
        }

        public boolean isSpecial() {
            return this.outcome == HLParams.specialOutcomeCode(this.enc);
        }

        public int hashCode() {
            return this.outcome;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            HLOutcome other = (HLOutcome)obj;
            return this.outcome == other.outcome;
        }

        public char outcomeChar() {
            if (this.isSpecial()) {
                throw new RuntimeException();
            }
            return this.enc.phoneId2Char(this.outcome);
        }

        @Override
        public int compareTo(HLOutcome other) {
            if (this.outcome < other.outcome) {
                return -1;
            }
            if (this.outcome == other.outcome) {
                return 0;
            }
            return 1;
        }
    }

    public static final class BranchSuffStatExtractor
    extends StatExtractor {
        public final Encodings enc;
        protected final int boundaryId;
        private final Taxon botLang;
        private Counter<LabeledInstance<HLContext, HLOutcome>> counter;

        public BranchSuffStatExtractor(Counter<LabeledInstance<HLContext, HLOutcome>> counter, DerivationTree.Derivation d, Taxon botLang, Encodings enc, DerivationTree.Window originalTopWin, DerivationTree.Window originalBotWin) {
            super(d, originalTopWin, originalBotWin, 1.0);
            this.botLang = botLang;
            this.counter = counter;
            this.enc = enc;
            this.boundaryId = enc.getBoundaryPhoneId();
        }

        @Override
        protected void addDel(int tp, int pbp) {
            this.counter.incrementCount(this.delHLSuffStat(tp, pbp), 1.0);
        }

        public LabeledInstance<HLContext, HLOutcome> delHLSuffStat(int tp, int pbp) {
            int tc = this.tc(tp);
            int pbc = this.bc(pbp);
            return HLParams.createSubDelSuffStat(this.botLang, this.enc, pbc, tc, this.spec());
        }

        @Override
        protected void addIns(int tp, int bp) {
            this.counter.incrementCount(this.insHLSuffStat(tp, bp), 1.0);
        }

        public LabeledInstance<HLContext, HLOutcome> insHLSuffStat(int tp, int bp) {
            int pbp = bp - 1;
            int tc = this.tc(tp);
            int bc = this.bc(bp);
            int pbc = this.bc(pbp);
            return HLParams.createInsertSuffStat(this.botLang, this.enc, pbc, tc, bc);
        }

        @Override
        protected void addEoIns(int tp, int bp) {
            this.counter.incrementCount(this.eoInsHLSuffStat(tp, bp), 1.0);
        }

        public LabeledInstance<HLContext, HLOutcome> eoInsHLSuffStat(int tp, int bp) {
            int pbp = bp - 1;
            int tc = this.tc(tp);
            int pbc = this.bc(pbp);
            return HLParams.createInsertSuffStat(this.botLang, this.enc, pbc, tc, this.spec());
        }

        @Override
        protected void addSub(int tp, int bp) {
            this.counter.incrementCount(this.subHLSuffStat(tp, bp), 1.0);
        }

        public LabeledInstance<HLContext, HLOutcome> subHLSuffStat(int tp, int bp) {
            int pbp = bp - 1;
            int tc = this.tc(tp);
            int bc = this.bc(bp);
            int pbc = this.bc(pbp);
            return HLParams.createSubDelSuffStat(this.botLang, this.enc, pbc, tc, bc);
        }

        private int spec() {
            return HLParams.specialOutcomeCode(this.enc);
        }

        private int code(int pos, boolean top) {
            if (pos == -1) {
                return this.boundaryId;
            }
            return this.enc.char2PhoneId((top ? this.d.getAncestorWord() : this.d.getCurrentWord()).charAt(pos));
        }

        private int tc(int tp) {
            return this.code(tp, true);
        }

        private int bc(int bp) {
            return this.code(bp, false);
        }
    }

    public static abstract class StatExtractor {
        protected final DerivationTree.Derivation d;
        protected final DerivationTree.Derivation inverse;
        protected final DerivationTree.Window topW;
        protected final DerivationTree.Window botW;

        protected StatExtractor(DerivationTree.Derivation d, DerivationTree.Window enlargedTopW, DerivationTree.Window enlargedBotW) {
            this.d = d;
            this.inverse = d.invert();
            this.topW = enlargedTopW;
            this.botW = enlargedBotW;
        }

        protected StatExtractor(DerivationTree.Derivation d) {
            this.d = d;
            this.inverse = d.invert();
            this.topW = new DerivationTree.Window(0, d.getAncestorWord().length());
            this.botW = new DerivationTree.Window(0, d.getCurrentWord().length());
        }

        protected StatExtractor(DerivationTree.Derivation d, DerivationTree.Window originalTopW, DerivationTree.Window originalBotW, double delta) {
            this(d, originalTopW.enlarge(d.getAncestorWord().length(), delta), originalBotW.enlarge(d.getCurrentWord().length(), delta));
        }

        protected abstract void addDel(int var1, int var2);

        protected abstract void addIns(int var1, int var2);

        protected abstract void addSub(int var1, int var2);

        protected abstract void addEoIns(int var1, int var2);

        public void extract() {
            for (int tp = -1; tp < this.tl(); ++tp) {
                if (this.survives(tp)) {
                    if (tp != -1 && (this.topW.contains(tp) || this.botW.contains(this.desc(tp)))) {
                        this.addSub(tp, this.desc(tp));
                    }
                    int bp = this.desc(tp) + 1;
                    while (!this.hasAnc(bp)) {
                        if (this.topW.contains(tp) || this.botW.contains(bp) || tp == -1) {
                            this.addIns(tp, bp);
                        }
                        ++bp;
                    }
                    if (tp != -1 && !this.topW.contains(tp) && !this.botW.contains(bp)) continue;
                    this.addEoIns(tp, bp);
                    continue;
                }
                if (!this.topW.contains(tp) && !this.botW.contains(this.pbp(tp))) continue;
                this.addDel(tp, this.pbp(tp));
            }
        }

        private int pbp(int tp) {
            int tp2 = tp - 1;
            while (!this.survives(tp2)) {
                --tp2;
            }
            int bp = this.desc(tp2) + 1;
            while (!this.hasAnc(bp)) {
                ++bp;
            }
            int pbp = bp - 1;
            return pbp;
        }

        protected boolean hasAnc(int bp) {
            if (bp == -1 || bp == this.bl()) {
                return true;
            }
            return this.d.hasAncestor(bp);
        }

        protected int desc(int tp) {
            if (tp == -1) {
                return -1;
            }
            if (tp == this.tl()) {
                return this.bl();
            }
            return this.inverse.ancestor(tp);
        }

        protected boolean survives(int tp) {
            if (tp == -1 || tp == this.tl()) {
                return true;
            }
            return this.inverse.hasAncestor(tp);
        }

        protected int tl() {
            return this.d.getAncestorWord().length();
        }

        protected int bl() {
            return this.d.getCurrentWord().length();
        }
    }

    public static abstract class HLParamsBranchPopulator {
        private final float[][][] sub;
        private final float[][][] ins;
        public final Encodings enc;

        public int B() {
            return this.enc.getBoundaryPhoneId();
        }

        public HLParamsBranchPopulator(Encodings enc) {
            this.enc = enc;
            int N = enc.getNumberOfPhonemes();
            this.sub = new float[N][N][N + 1];
            this.ins = new float[N][N][N + 1];
        }

        public void callPopulators() {
            int N = this.enc.getNumberOfPhonemes();
            for (int top = 0; top < N; ++top) {
                for (int prev = 0; prev < N; ++prev) {
                    if (top == this.B() || prev != this.B()) {
                        this.populateIns(top, prev, this.ins[top][prev]);
                    }
                    if (top == this.enc.getBoundaryPhoneId()) continue;
                    this.populateSub(top, prev, this.sub[top][prev]);
                }
            }
        }

        public HLBranchParams createParams(boolean normalize) {
            this.callPopulators();
            if (normalize) {
                this.normalize();
            }
            return new HLBranchParams(this.sub, this.ins, this.enc);
        }

        public abstract void populateIns(int var1, int var2, float[] var3);

        public abstract void populateSub(int var1, int var2, float[] var3);

        private final void normalize() {
            this.normalize(this.sub);
            this.normalize(this.ins);
        }

        private void normalize(float[][][] dists) {
            float[][][] fArray = dists;
            int n = fArray.length;
            for (int i = 0; i < n; ++i) {
                float[][] sdist;
                for (float[] dist : sdist = fArray[i]) {
                    NumUtils.normalize(dist);
                }
            }
        }
    }

    public static final class HLBranchParams
    implements AffineGapAlignmentSampler.GapAlignmentParams,
    Serializable {
        private static final long serialVersionUID = 2L;
        private final Encodings enc;
        private final int N;
        private final float[][][] sub;
        private final float[][][] ins;

        public String toString() {
            return this.toString(Taxon.dummy);
        }

        public String toString(Taxon lang) {
            StringBuilder result = new StringBuilder();
            for (HLContext hlc : HLParams.allHLContexts(this.enc, lang)) {
                if (hlc.type != ChoiceType.INS && hlc.type != ChoiceType.SUBDEL) continue;
                for (HLOutcome out : hlc.allOutcomes()) {
                    result.append(HLParams.format(hlc, out) + "\t" + this.pr(hlc, out) + "\n");
                }
            }
            return result.toString();
        }

        public double pr(HLContext context, HLOutcome outcome) {
            if (context.type == ChoiceType.SUBDEL) {
                if (outcome.isSpecial()) {
                    return this.death(context.top, context.prev);
                }
                return this.sub(context.top, context.prev, outcome.outcome);
            }
            if (context.type == ChoiceType.INS) {
                if (outcome.isSpecial()) {
                    return this.stopIns(context.top, context.prev);
                }
                return this.ins(context.top, context.prev, outcome.outcome);
            }
            throw new RuntimeException("Undef type in HLParams");
        }

        public double sub(int top, int prev, int cur) {
            if (top == this.enc.getBoundaryPhoneId() && cur == this.enc.getBoundaryPhoneId()) {
                return 1.0;
            }
            return this.sub[top][prev][cur];
        }

        public double ins(int top, int prev, int cur) {
            return this.ins[top][prev][cur];
        }

        public double death(int top, int prev) {
            return this.sub[top][prev][this.N];
        }

        public double stopIns(int top, int prev) {
            return this.ins[top][prev][this.N];
        }

        public HLBranchParams(float[][][] sub, float[][][] ins, Encodings enc) {
            this.enc = enc;
            this.N = enc.getNumberOfPhonemes();
            HLParams.check(ins, enc, true);
            HLParams.check(sub, enc, false);
            this.sub = sub;
            this.ins = ins;
        }

        @Override
        public Encodings getEncodings() {
            return this.enc;
        }

        public DerivationTree.Derivation generateEvolution(String top, Random rand) {
            char B = this.enc.phoneId2Char(this.enc.getBoundaryPhoneId());
            ArrayList<Integer> ancestors = new ArrayList<Integer>();
            StringBuilder result = new StringBuilder();
            result.append(B);
            CharSequence insertions = this.generateIns(B, B, rand);
            for (int i = 0; i < insertions.length(); ++i) {
                ancestors.add(-1);
            }
            result.append(insertions);
            int topPos = 0;
            for (char topChar : top.toCharArray()) {
                Character sub = this.generateSub(topChar, HLParams.head(result), rand);
                if (sub != null) {
                    ancestors.add(topPos);
                    result.append(sub);
                    insertions = this.generateIns(topChar, HLParams.head(result), rand);
                    result.append(insertions);
                    for (int i = 0; i < insertions.length(); ++i) {
                        ancestors.add(-1);
                    }
                }
                ++topPos;
            }
            String generated = result.toString().substring(1, result.length());
            int[] convertedAncestors = new int[ancestors.size()];
            for (int i = 0; i < ancestors.size(); ++i) {
                convertedAncestors[i] = (Integer)ancestors.get(i);
            }
            return new DerivationTree.Derivation(convertedAncestors, top, generated);
        }

        private Character generateSub(char topChar, char previous, Random rand) {
            int p;
            int t = this.enc.char2PhoneId(topChar);
            float[] dist = this.sub[t][p = this.enc.char2PhoneId(previous)];
            int draw = HLParams.sampleMultinomial(rand, dist);
            if (draw == this.N) {
                return null;
            }
            return Character.valueOf(this.enc.phoneId2Char(draw));
        }

        private CharSequence generateIns(char topChar, char head, Random rand) {
            int p;
            int t;
            float[] dist;
            int draw;
            StringBuilder result = new StringBuilder();
            result.append(head);
            for (int i = 0; i < 1000 && (draw = HLParams.sampleMultinomial(rand, dist = this.ins[t = this.enc.char2PhoneId(topChar)][p = this.enc.char2PhoneId(HLParams.head(result))])) != this.N; ++i) {
                result.append(this.enc.phoneId2Char(draw));
            }
            return result.subSequence(1, result.length());
        }
    }
}

