/*
 * Decompiled with CFR 0.152.
 */
package goblin;

import goblin.DerivationTree;
import goblin.Taxon;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import nuts.util.Arbre;

public class ObservationsTracker
implements Serializable {
    private static final long serialVersionUID = 2221464575807602263L;
    private final Set<Taxon> observedLanguages = new HashSet<Taxon>();
    public static final String MODERN_KEYWORD = "!modern";
    public static final String ALL_KEYWORD = "!all";

    public ObservationsTracker(Collection<Taxon> observedLanguages) {
        this.observedLanguages.addAll(observedLanguages);
    }

    public ObservationsTracker() {
    }

    public boolean isObserved(Taxon language) {
        return this.observedLanguages.contains(language);
    }

    public Set<Taxon> observedLanguages() {
        return Collections.unmodifiableSet(this.observedLanguages);
    }

    public String toString() {
        return this.observedLanguages.toString();
    }

    public static ObservationsTracker parseObservationsTracker(String string, Arbre<DerivationTree.DerivationNode> arbre) {
        HashSet<Taxon> allLangs = new HashSet<Taxon>();
        HashSet<Taxon> allChilds = new HashSet<Taxon>();
        for (Arbre<DerivationTree.DerivationNode> node : arbre.nodes()) {
            Taxon cLang = node.getContents().getLanguage();
            allLangs.add(cLang);
            if (!node.isLeaf()) continue;
            allChilds.add(cLang);
        }
        if (string.equals(MODERN_KEYWORD)) {
            return new ObservationsTracker(allChilds);
        }
        if (string.equals(ALL_KEYWORD)) {
            return new ObservationsTracker(allLangs);
        }
        HashSet<Taxon> observedLangs = new HashSet<Taxon>();
        for (String inputLang : string.split("\\s+")) {
            Taxon currentL = new Taxon(inputLang);
            if (!allLangs.contains(currentL)) {
                throw new RuntimeException("Unknown observed language: " + inputLang);
            }
            observedLangs.add(currentL);
        }
        return new ObservationsTracker(observedLangs);
    }

    public static ObservationsTracker modernObservationsTracker(Arbre<DerivationTree.DerivationNode> arbre) {
        return ObservationsTracker.parseObservationsTracker(MODERN_KEYWORD, arbre);
    }

    public static ObservationsTracker allObservationsTracker(Arbre<DerivationTree.DerivationNode> arbre) {
        return ObservationsTracker.parseObservationsTracker(ALL_KEYWORD, arbre);
    }

    public static ObservationsTracker noObservationsTracker() {
        return new ObservationsTracker(Collections.EMPTY_SET);
    }
}

