/*
 * Decompiled with CFR 0.152.
 */
package ma;

import fig.basic.LogInfo;
import fig.basic.Parallelizer;
import goblin.CognateId;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ma.MSAPoset;
import nuts.io.IO;
import nuts.util.CollUtils;

public class LoadBench {
    public static final String BALI3_REF_PATTERN = "BB[0-9]*";

    public static final Map<CognateId, MSAPoset> load(File refFolder, final String pattern, final int maxN) {
        LogInfo.track("Loading alignments from " + refFolder);
        final HashMap<CognateId, MSAPoset> result = CollUtils.map();
        List<File> fs = IO.ls(refFolder);
        Parallelizer<File> parallelizer = new Parallelizer<File>(4);
        parallelizer.setPrimaryThread();
        parallelizer.process(fs, new Parallelizer.Processor<File>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void process(File f, int i, int n, boolean log) {
                if (i >= maxN) {
                    return;
                }
                if (!f.getName().matches(pattern)) {
                    return;
                }
                if (log) {
                    LogInfo.logs("Processing file " + f + " [approx " + ++i + "/" + Math.min(maxN, n) + "]");
                }
                MSAPoset msa = MSAPoset.parseFASTA(f);
                msa = MSAPoset.processBenchmarkReference(msa);
                CognateId id = new CognateId(f.getName());
                Map map = result;
                synchronized (map) {
                    result.put(id, msa);
                }
            }
        });
        LogInfo.end_track();
        return result;
    }

    public static final Map<CognateId, MSAPoset> loadBali3() {
        return LoadBench.loadBali3(Integer.MAX_VALUE);
    }

    public static final Map<CognateId, MSAPoset> loadBali3(int maxN) {
        List<File> possibilities = Arrays.asList(new File("/Users/bouchard/w/evolvere/data/bench1.0/bali3/ref"), new File("/home/eecs/bouchard/evolvere/data/bench1.0/bali3/ref"));
        for (File f : possibilities) {
            if (!f.exists()) continue;
            return LoadBench.load(f, BALI3_REF_PATTERN, maxN);
        }
        throw new RuntimeException();
    }

    public static void main(String[] args) {
        Map<CognateId, MSAPoset> data = LoadBench.loadBali3();
    }
}

