/*
 * Decompiled with CFR 0.152.
 */
package ma;

import fig.basic.Option;
import java.io.File;
import java.util.ArrayList;
import ma.MSAPoset;
import ma.MultiAlignment;
import nuts.io.IO;
import nuts.math.Evaluator;

public class MSAParser
implements Evaluator.Parser<MSAPoset> {
    @Override
    public MSAPoset parse(File f) {
        return MSAParser.parseMSA(f);
    }

    public static MSAPoset parseMSAIgnoreRef(File f) {
        Object e1 = null;
        Exception e2 = null;
        Exception e3 = null;
        if (!f.exists()) {
            throw new RuntimeException("File not found: " + f);
        }
        try {
            return MSAPoset.parseFASTA(f);
        }
        catch (Exception e) {
            e2 = e;
            try {
                return MSAPoset.parseAlnOrMsfFormats(f);
            }
            catch (Exception e4) {
                e3 = e4;
                e2.printStackTrace();
                e3.printStackTrace();
                throw new RuntimeException("MSA format not understood: " + f + "\nE1:\n" + e1 + "\nE2:\n" + e2 + "\nE3:\n" + e3);
            }
        }
    }

    public static MSAPoset parseMSA(File f) {
        Exception e1 = null;
        Exception e2 = null;
        Exception e3 = null;
        if (!f.exists()) {
            throw new RuntimeException("File not found: " + f);
        }
        try {
            return MSAPoset.coreBlocksFromMultiAlignmentObject(MultiAlignment.parseMSFToMultiAlignment(f.getAbsolutePath(), f.getAbsolutePath().replaceAll("[.]msf", "_ref1.ann")));
        }
        catch (Exception e) {
            e1 = e;
            try {
                return MSAPoset.processBenchmarkReference(MSAPoset.parseFASTA(f));
            }
            catch (Exception e4) {
                e2 = e4;
                try {
                    return MSAPoset.parseAlnOrMsfFormats(f);
                }
                catch (Exception e5) {
                    e3 = e5;
                    e1.printStackTrace();
                    e2.printStackTrace();
                    e3.printStackTrace();
                    throw new RuntimeException("MSA format not understood: " + f + "\nE1:\n" + e1 + "\nE2:\n" + e2 + "\nE3:\n" + e3);
                }
            }
        }
    }

    public static void main(String[] args) {
        IO.runLight(args, new MSAParserMain());
    }

    public static class MSAParserMain
    implements Runnable {
        @Option(required=true)
        public ArrayList<File> alignmentFiles;
        @Option
        public boolean ignoreReferenceAlignmentInfo = false;

        @Override
        public void run() {
            for (File f : this.alignmentFiles) {
                if (this.ignoreReferenceAlignmentInfo) {
                    System.out.println(MSAParser.parseMSAIgnoreRef(f) + "\n");
                    continue;
                }
                System.out.println(MSAParser.parseMSA(f) + "\n");
            }
        }
    }
}

