/*
 * Decompiled with CFR 0.152.
 */
package monaco;

import fig.basic.Pair;
import java.util.Random;
import monaco.Density;
import monaco.heat.ConstantHeatSchedule;
import monaco.heat.HeatingSchedule;
import monaco.prop.Proposal;
import monaco.prop.ProposalProvider;
import nuts.math.StatisticsMap;
import pty.smc.LazyParticleFilter;

public class StandardKernel<S>
implements LazyParticleFilter.LazyParticleKernel<S> {
    private final S init;
    private final ProposalProvider<S> proposalProvider;
    private final Density<S> density;
    private final int nIters;
    private final HeatingSchedule<S> heatingSchedule;
    private final boolean verbose = false;

    public Density<S> getDensity() {
        return this.density;
    }

    public HeatingSchedule<S> getHeatingSchedule() {
        return this.heatingSchedule;
    }

    public StandardKernel(S init, ProposalProvider<S> proposalProvider, Density<S> density, int nIters, HeatingSchedule<S> heatingSchedule) {
        this.init = init;
        this.density = density;
        this.nIters = nIters;
        this.heatingSchedule = heatingSchedule;
        this.proposalProvider = proposalProvider;
    }

    @Override
    public final Pair<S, Double> next(Random rand, S current) {
        return (Pair)this._next(rand, current, false, null);
    }

    public S nextWithoutWeight(Random rand, S current) {
        Proposal<S> proposal = this.proposalProvider.proposal(rand, current);
        Pair<S, Double> proposed = proposal.propose_logRatio(rand, current, false);
        return proposed.getFirst();
    }

    public final Pair<S, Double> next(Random rand, S current, StatisticsMap<String> mhRatios) {
        return (Pair)this._next(rand, current, false, mhRatios);
    }

    @Override
    public double peekNext(Random rand, S current) {
        return (Double)this._next(rand, current, true, null);
    }

    private void print(Object o) {
    }

    private final Object _next(Random rand, S current, boolean isPeek, StatisticsMap<String> mhRatios) {
        double heat = this.heatingSchedule == null ? 1.0 : this.heatingSchedule.exponent(current);
        this.print("Heat = " + heat);
        double oldDensity = this.density.logDensity(current) * heat;
        Proposal<S> proposal = this.proposalProvider.proposal(rand, current);
        Pair<S, Double> proposed = proposal.propose_logRatio(rand, current, isPeek);
        this.print("proposal = " + proposal.name());
        double newDensity = this.density.logDensity(proposed.getFirst()) * heat;
        this.print("newLog - oldLog = " + newDensity + " - " + oldDensity + " = " + (newDensity - oldDensity));
        this.print("propLogRatio = " + proposed.getSecond());
        double resultLogRatio = newDensity - oldDensity + proposed.getSecond();
        if (mhRatios != null) {
            String name = proposal.name();
            double value = Math.min(1.0, Math.exp(resultLogRatio));
            mhRatios.addValue(name, value);
            mhRatios.addValue("*", value);
        }
        if (isPeek) {
            return resultLogRatio;
        }
        return Pair.makePair(proposed.getFirst(), resultLogRatio);
    }

    @Override
    public int nIterationsLeft(S partialState) {
        if (partialState != this.init) {
            throw new RuntimeException();
        }
        return this.nIters;
    }

    @Override
    public S getInitial() {
        return this.init;
    }

    public StandardKernel<S> createTemperedVersion(double currentExponent) {
        return new StandardKernel<S>(this.init, this.proposalProvider, this.density, this.nIters, new ConstantHeatSchedule(currentExponent));
    }
}

