/*
 * Decompiled with CFR 0.152.
 */
package nuts.math;

import java.util.Iterator;

public class Interval
implements Iterable<Integer> {
    private final int leftIncl;
    private final int rightExcl;

    public Interval(int leftIncl, int rightExcl) {
        if (leftIncl > rightExcl) {
            throw new RuntimeException("left=" + leftIncl + ",right=" + rightExcl);
        }
        this.leftIncl = leftIncl;
        this.rightExcl = rightExcl;
    }

    public String toString() {
        return "[" + this.left() + "," + this.right() + ")";
    }

    public int left() {
        return this.leftIncl;
    }

    public int right() {
        return this.rightExcl;
    }

    public boolean contains(int point) {
        return point >= this.leftIncl && point < this.rightExcl;
    }

    @Override
    public Iterator<Integer> iterator() {
        return new Iterator<Integer>(){
            public int current;
            {
                this.current = Interval.this.leftIncl;
            }

            @Override
            public boolean hasNext() {
                return this.current < Interval.this.rightExcl;
            }

            @Override
            public Integer next() {
                if (!this.hasNext()) {
                    throw new RuntimeException();
                }
                return this.current++;
            }

            @Override
            public void remove() {
                throw new RuntimeException();
            }
        };
    }

    public static void main(String[] args) {
        Interval interval = new Interval(1, 5);
        for (int i : interval) {
            System.out.print(i + " ");
        }
    }
}

