/*
 * Decompiled with CFR 0.152.
 */
package nuts.math;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import nuts.io.IteratorWrapper;

public class Permutations {
    public static Iterable<int[]> permutations(final int N) {
        Iterator<int[]> iterator = new Iterator<int[]>(){
            private boolean hasNext = true;
            private int[] lehmer = new int[N];
            private boolean[] tmp = new boolean[N];
            private int[] converted = new int[N];

            @Override
            public boolean hasNext() {
                return this.hasNext;
            }

            @Override
            public int[] next() {
                if (!this.hasNext) {
                    throw new RuntimeException();
                }
                Permutations.inverseLehmer(this.lehmer, this.converted, this.tmp);
                this.hasNext = Permutations.incrementLehmer(this.lehmer);
                return this.converted;
            }

            @Override
            public void remove() {
                throw new RuntimeException();
            }
        };
        return IteratorWrapper.IW(iterator);
    }

    private static void lehmer(int[] pi, int[] dest) {
        if (pi.length != dest.length) {
            throw new RuntimeException();
        }
        for (int i = 0; i < pi.length; ++i) {
            int sum = 0;
            for (int j = i + 1; j < pi.length; ++j) {
                if (pi[j] >= pi[i]) continue;
                ++sum;
            }
            dest[i] = sum;
        }
    }

    private static void inverseLehmer(int[] lehmer, int[] dest, boolean[] nk) {
        int i;
        for (i = 0; i < nk.length; ++i) {
            nk[i] = true;
        }
        for (i = 0; i < dest.length; ++i) {
            int value;
            int index = lehmer[i];
            int current = 0;
            for (value = 0; value < nk.length; ++value) {
                if (!nk[value]) continue;
                if (current == index) break;
                ++current;
            }
            dest[i] = value;
            nk[value] = false;
        }
    }

    private static boolean incrementLehmer(int[] lehmer) {
        int currentBase = lehmer.length;
        for (int i = 0; i < lehmer.length; ++i) {
            if (lehmer[i] + 1 == currentBase) {
                lehmer[i] = 0;
                --currentBase;
                continue;
            }
            int n = i;
            lehmer[n] = lehmer[n] + 1;
            return true;
        }
        return false;
    }

    public static void main(String[] args) {
        int[] pi = new int[]{4, 6, 0, 2, 5, 3, 1, 8, 7};
        System.out.println("initial   = " + Arrays.toString(pi));
        int[] dest = new int[pi.length];
        boolean[] tmp = new boolean[pi.length];
        Permutations.lehmer(pi, dest);
        System.out.println("lehmer    = " + Arrays.toString(dest));
        int[] converted = new int[pi.length];
        Permutations.inverseLehmer(dest, converted, tmp);
        System.out.println("converted = " + Arrays.toString(converted));
        HashSet all = new HashSet();
        for (int[] perm : Permutations.permutations(3)) {
            System.out.println(Arrays.toString(perm));
            ArrayList<Integer> current = new ArrayList<Integer>(perm.length);
            for (Object x : (Object)perm) {
                current.add((int)x);
            }
            all.add(current);
        }
        System.out.println(all.size());
        for (int i = 0; i < 15; ++i) {
            long time = System.currentTimeMillis();
            for (int[] nArray : Permutations.permutations(i)) {
            }
            System.out.println("" + i + "\t" + (System.currentTimeMillis() - time));
        }
    }
}

