/*
 * Decompiled with CFR 0.152.
 */
package nuts.tools;

import fig.basic.Option;
import fig.exec.Execution;
import nuts.io.IO;

public class InstallEC2
implements Runnable {
    @Option(required=true)
    public String server;
    @Option
    public boolean verbose = false;
    @Option
    public boolean installBio = false;
    @Option
    public boolean installLing = false;
    @Option
    public boolean installSgi = true;

    @Override
    public void run() {
        this.createDirectory("/root/sage/state/execs");
        this.createDirectory("/root/sgi/state/execs");
        String jarDir = "/root/sage/jars/";
        this.createDirectory("/root/sage/jars/");
        this.scp("/home/eecs/bouchard/jars/pepper.jar", "/root/sage/jars/");
        this.scp("/home/eecs/bouchard/jars/nuts.jar", "/root/sage/jars/");
        this.scp("/home/eecs/bouchard/jars/fig.jar", "/root/sage/jars/");
        this.scp("/home/eecs/bouchard/jars/commons-math-1.2.jar", "/root/sage/jars/");
        this.scp("/home/eecs/bouchard/jars/mt.jar", "/root/sage/jars/");
        this.scp("/home/eecs/bouchard/jars/sgi.jar", "/root/sage/jars/");
        this.scp("/home/eecs/bouchard/jars/util.jar", "/root/sage/jars/");
        if (this.installBio) {
            this.scp("/home/eecs/bouchard/goblin/sage/data", "/root/sage/");
            this.scp("/home/eecs/bouchard/goblin/sage/init", "/root/sage/");
        }
        if (this.installLing) {
            this.scp("/home/eecs/bouchard/goblin/austro/cons", "/root/sage/");
            this.scp("/home/eecs/bouchard/goblin/austro/vow", "/root/sage/");
            this.scp("/home/eecs/bouchard/goblin/austro/data/", "/root/sage/data");
            this.scp("/home/eecs/bouchard/goblin/austro/feats-temp.weights", "/root/sage/");
        }
        if (this.installSgi) {
            this.scp("/home/eecs/bouchard/radsgi/data/i.align", "/root/sgi/data");
            this.scp("/home/eecs/bouchard/radsgi/data/i.en", "/root/sgi/data");
            this.scp("/home/eecs/bouchard/radsgi/data/i.zh", "/root/sgi/data");
        }
        this.ssh("apt-get install screen");
    }

    private void createDirectory(String string) {
        this.ssh("mkdir -p " + string);
    }

    private void ssh(String string) {
        IO.callSafely("/usr/bin/ssh -i /home/eecs/bouchard/.ec2/default-keypair root@" + this.server + " " + string);
    }

    private void scp(String src, String dest) {
        IO.callSafely("/usr/bin/scp -r -i /home/eecs/bouchard/.ec2/default-keypair " + src + " root@" + this.server + ":" + dest);
    }

    public static void main(String[] args) {
        Execution.run(args, new InstallEC2());
    }
}

