/*
 * Decompiled with CFR 0.152.
 */
package pedi;

import fenchel.algo.BlockingPriorities;
import fig.basic.IOUtils;
import fig.basic.LogInfo;
import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import nuts.io.IO;
import nuts.math.Graph;
import nuts.math.Graphs;
import nuts.util.CollUtils;
import pedi.BiAllelicDiploidGenotype;
import pedi.Genotypes;
import pedi.Individual;
import pedi.Pedigree;
import pedi.RegularPedigree;
import pedi.SimplePedigree;
import pedi.io.PedigreeFileReader;
import pedi.main.PediMain;

public class PedigreeUtils {
    public static void main(String[] args) {
        IO.run(args, new PedigreeUtilsTest());
    }

    public static void pedigree2File(File output, RegularPedigree p, Genotypes g, Map<Individual, Boolean> d, Map<Individual, Integer> genders) {
        PrintWriter out = IOUtils.openOutHard(output);
        for (Individual i : p.individuals()) {
            out.print(i.familyName + " " + i.firstName + " ");
            for (int pIdx = 0; pIdx < 2; ++pIdx) {
                Individual parent = p.parent(i, pIdx);
                out.print((parent == null ? "0" : parent.firstName) + " ");
            }
            out.print("" + genders.get(i).toString() + " ");
            Boolean aff = d.get(i);
            if (aff == null) {
                out.print("0 ");
            } else {
                out.print(aff != false ? "2" : "1");
            }
            out.print("  ");
            if (g.genotypedIndividuals().contains(i)) {
                BiAllelicDiploidGenotype cast = (BiAllelicDiploidGenotype)g.getGenotype(i);
                for (int idx = 0; idx < g.genomeSize(); ++idx) {
                    out.print("" + (1 + cast.getHeldoutHaplotype(idx, 0)) + " " + (1 + cast.getHeldoutHaplotype(idx, 1)) + "  ");
                }
            } else {
                for (int idx = 0; idx < g.genomeSize(); ++idx) {
                    out.print("0 0  ");
                }
            }
            out.println();
        }
        out.close();
    }

    public static RegularPedigree getSimExample() {
        PedigreeFileReader reader = new PedigreeFileReader();
        reader.read(IO.fileFromResource("pedi/simulator/sim.ped"));
        return RegularPedigree.getRegularPedigree(reader.getPedigree());
    }

    public static Set<Set<Individual>> connectedComponents(RegularPedigree p) {
        return Graphs.connectedComponents(PedigreeUtils.toGraph(p));
    }

    public static List<Pedigree> connectedSubpedigrees(RegularPedigree p) {
        Set<Set<Individual>> ccs = PedigreeUtils.connectedComponents(p);
        ArrayList<Pedigree> result = new ArrayList<Pedigree>();
        for (Set<Individual> cc : ccs) {
            result.add(PedigreeUtils.subPedigree(p, cc));
        }
        return result;
    }

    public static Pedigree subPedigree(final Pedigree p, final Set<Individual> subset) {
        if (!p.individuals().containsAll(subset)) {
            throw new RuntimeException();
        }
        return new SimplePedigree(new Pedigree(){

            @Override
            public Individual parent(Individual i, int index) {
                if (!subset.contains(i)) {
                    throw new RuntimeException();
                }
                Individual ori = p.parent(i, index);
                if (subset.contains(ori)) {
                    return ori;
                }
                return null;
            }

            @Override
            public Collection<Individual> individuals() {
                return subset;
            }
        });
    }

    public static Graph<Individual> toGraph(final RegularPedigree p) {
        return new Graph<Individual>(){
            private static final long serialVersionUID = 1L;

            @Override
            public Set<Individual> nbrs(Individual node) {
                HashSet<Individual> nbrs = new HashSet<Individual>();
                for (int pIdx = 0; pIdx < 2; ++pIdx) {
                    Individual parent = p.parent(node, pIdx);
                    if (parent == null) continue;
                    nbrs.add(parent);
                }
                for (Individual child : p.children(node)) {
                    nbrs.add(child);
                }
                return nbrs;
            }

            @Override
            public boolean hasEdge(Individual node1, Individual node2) {
                return this.nbrs(node1).contains(node2);
            }

            @Override
            public Set<Individual> vertexSet() {
                return new HashSet<Individual>(p.individuals());
            }
        };
    }

    public static Map<Individual, Integer> wfGenerations(RegularPedigree p) {
        HashMap<Individual, Integer> result = new HashMap<Individual, Integer>();
        for (Pedigree subp : PedigreeUtils.connectedSubpedigrees(p)) {
            Map<Individual, Integer> current = PedigreeUtils._connectedWFGenerations(RegularPedigree.getRegularPedigree(subp));
            if (current == null) {
                return null;
            }
            result.putAll(current);
        }
        return result;
    }

    private static Map<Individual, Integer> _connectedWFGenerations(RegularPedigree subp) {
        HashMap<Individual, Integer> result = new HashMap<Individual, Integer>();
        if (PedigreeUtils._WFGenerations(subp, CollUtils.pick(subp.individuals()), null, 0, result)) {
            return PedigreeUtils.shift(result);
        }
        return null;
    }

    private static Map<Individual, Integer> shift(Map<Individual, Integer> result) {
        int min = Collections.min(result.values());
        for (Individual i : new ArrayList<Individual>(result.keySet())) {
            result.put(i, result.get(i) - min);
        }
        return result;
    }

    private static boolean _WFGenerations(RegularPedigree p, Individual current, Individual caller, int currentGen, Map<Individual, Integer> result) {
        if (result.containsKey(current)) {
            return result.get(current) == currentGen;
        }
        result.put(current, currentGen);
        for (int pIdx = 0; pIdx < 2; ++pIdx) {
            Individual parent = p.parent(current, pIdx);
            if (parent == null || parent.equals(caller) || PedigreeUtils._WFGenerations(p, parent, current, currentGen + 1, result)) continue;
            return false;
        }
        for (Individual child : p.children(current)) {
            if (child.equals(caller) || PedigreeUtils._WFGenerations(p, child, current, currentGen - 1, result)) continue;
            return false;
        }
        return true;
    }

    public static Map<Individual, Set<Individual>> ancestorsMap(RegularPedigree p) {
        HashMap<Individual, Set<Individual>> ancestors = new HashMap<Individual, Set<Individual>>();
        BlockingPriorities<Individual> priorities = new BlockingPriorities<Individual>();
        for (Individual i : p.individuals()) {
            priorities.init(i, p.founders().contains(i) ? 0 : 2);
        }
        while (!priorities.isEmpty()) {
            Set<Individual> currentAncestors;
            Individual i = (Individual)priorities.popUnblocked();
            if (i == null) {
                throw new RuntimeException();
            }
            if (p.founders().contains(i)) {
                currentAncestors = Collections.singleton(i);
            } else {
                Set a0 = (Set)ancestors.get(p.parent(i, 0));
                Set a1 = (Set)ancestors.get(p.parent(i, 1));
                currentAncestors = new HashSet<Individual>(a0.size() + a1.size());
                currentAncestors.addAll(a0);
                currentAncestors.addAll(a1);
            }
            ancestors.put(i, currentAncestors);
            for (Individual child : p.children(i)) {
                priorities.removeBlock(child);
            }
        }
        return ancestors;
    }

    public static void render(File pedFile) {
        try {
            IO.call("pedtodot " + pedFile.getName(), null, pedFile.getParentFile());
        }
        catch (Exception e) {
            LogInfo.warning("Rendering does not work");
        }
    }

    public static class PedigreeUtilsTest
    extends PediMain {
        @Override
        public void run() {
            RegularPedigree p = this.getPedigree();
            Map<Individual, Integer> wfGens = PedigreeUtils.wfGenerations(p);
            System.out.println("Detected WF Gens: " + wfGens);
            Map<Integer, Set<Individual>> inverse = CollUtils.invert(wfGens);
            HashSet<Individual> subset = new HashSet<Individual>();
            subset.addAll((Collection)inverse.get(0));
            subset.addAll((Collection)inverse.get(1));
            subset.addAll((Collection)inverse.get(2));
            RegularPedigree subp = RegularPedigree.getRegularPedigree(PedigreeUtils.subPedigree(p, subset));
            Map<Individual, Integer> wfGens2 = PedigreeUtils.wfGenerations(subp);
            System.out.println(wfGens2);
            System.out.println("ccs=" + PedigreeUtils.connectedComponents(subp));
        }
    }
}

