/*
 * Decompiled with CFR 0.152.
 */
package pedi.baseline;

import fig.basic.LogInfo;
import fig.exec.Execution;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import nuts.io.IO;
import nuts.lang.ArrayUtils;

public class Merlin {
    public static final String runParametricMerlin(int nSites, File pedigreeFile, File recRatesFiles, File outScoresFile, double alleleFreq, double p0, double p1, double p2, String memlimitkb) {
        String cmd = "run_merlin_parametric.pl " + nSites + " " + pedigreeFile.getAbsolutePath() + " " + recRatesFiles.getAbsolutePath() + " " + outScoresFile.getAbsolutePath() + " " + alleleFreq + " " + p0 + " " + p1 + " " + p2 + " " + memlimitkb + " ";
        File scriptLocation = new File(IO.call("/usr/bin/which run_merlin_parametric.pl").replaceAll("\n", "")).getParentFile();
        LogInfo.logs("Command: " + cmd);
        String result = IO.call(cmd, null, scriptLocation);
        return result;
    }

    public static double[] parseDetailedParametricMerlinLODs(String output) {
        return Merlin.parseDetailedParametricMerlinLODs(ArrayUtils.stringArray2List(output.split("\n")));
    }

    public static double[] parseDetailedParametricMerlinLODs(List<String> lines) {
        int i = 0;
        for (String cur : lines) {
            if (cur.contains("===========================")) break;
            ++i;
        }
        ArrayList<Double> result = new ArrayList<Double>();
        for (int j = i + 2; j < lines.size(); ++j) {
            try {
                String[] broken = lines.get(j).split("\\s+");
                String token = broken[2].replaceAll("\\s+", "");
                double item = token.equals("-INFINITY") ? Double.NEGATIVE_INFINITY : Double.parseDouble(token);
                result.add(item);
                continue;
            }
            catch (Exception e) {
                break;
            }
        }
        return ArrayUtils.fromCollection(result);
    }

    public static void main(String[] args) {
        IO.run(args, new MerlinMain());
    }

    public static class MerlinMain
    implements Runnable {
        @Override
        public void run() {
            File cRate = new File("/Users/bouchard/experiments/pedi/state/execs/625.exec/rates-merlin");
            File dir = new File("/Users/bouchard/code/legacy-code/src-pedi/pedi/baseline/");
            File out = new File(Execution.getFile("out"));
            String detOut = Merlin.runParametricMerlin(4, new File(dir, "sim.out.ped"), cRate, out, 0.5, 0.0, 0.0, 1.0, "unlimited");
            System.out.println(Arrays.toString(Merlin.parseDetailedParametricMerlinLODs(detOut)));
        }
    }
}

