/*
 * Decompiled with CFR 0.152.
 */
package pedi.main;

import fenchel.factor.multisites.MSMFOptions;
import fenchel.factor.multisites.MSMeasureFacto;
import fenchel.factor.multisites.MSUnaryMap;
import fenchel.measurefacto.MFBeliefProp;
import fig.basic.LogInfo;
import fig.basic.Option;
import fig.basic.OptionSet;
import fig.exec.Execution;
import java.io.File;
import java.util.Arrays;
import nuts.io.IO;
import pedi.factor.PediMeasureFacto;
import pedi.factor.PediMeasureFactoOptions;
import pedi.factor.PedigreeNode;
import pedi.main.PediMain;

public class RunMFBP
extends PediMain {
    @OptionSet(name="pmf")
    public PediMeasureFactoOptions pediMFOptions = new PediMeasureFactoOptions();
    @OptionSet(name="fo")
    public MSMFOptions fenchelOptions = new MSMFOptions();
    @Option
    public boolean outputAllMessages = false;
    @Option
    public int nIters = 5;
    @Option
    public boolean useHaploConsistentDecode = true;

    public static void main(String[] args) {
        IO.run(args, new RunMFBP());
    }

    @Override
    public void run() {
        long start = System.nanoTime();
        MSMeasureFacto<PedigreeNode> msfmf = PediMeasureFacto.createMeasureFacto(this.getModel(), this.fenchelOptions, this.pediMFOptions);
        MFBeliefProp<MSUnaryMap<PedigreeNode>> mfbp = msfmf.getMFBP();
        LogInfo.track((Object)"Computing MFBP", true);
        if (this.outputAllMessages) {
            File out = new File(Execution.getFile("MFBP-output"));
            out.mkdir();
            mfbp.setOutputDir(out);
        }
        double time = (double)(System.nanoTime() - start) / 1.0E10;
        this.evaluate(mfbp.queryMoments().get(0), Arrays.asList("Method", "Iter", "ElapsedSeconds"), Arrays.asList("MFBP", "0", "" + time));
        for (int i = 1; i < this.nIters; ++i) {
            mfbp.iterate();
            MSUnaryMap<PedigreeNode> product = mfbp.queryProductMoments();
            time = (double)(System.nanoTime() - start) / 1.0E10;
            this.evaluate(product, Arrays.asList("Method", "Iter", "ElapsedSeconds"), Arrays.asList("MFBP", "" + i, "" + time));
        }
        LogInfo.end_track();
    }
}

