/*
 * Decompiled with CFR 0.152.
 */
package pedi.pheno;

import fenchel.factor.multihmm.MultiInputHMM;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import pedi.Individual;
import pedi.factor.PedigreeNode;
import pedi.pheno.DiseaseTypes;
import pedi.pheno.Phenotypes;

public class DiseasePhenotypes
implements Phenotypes {
    public final DiseaseTypes diseaseType;
    public final Map<Individual, Boolean> affections;

    public DiseasePhenotypes(DiseaseTypes diseaseType, Map<Individual, Boolean> affections) {
        this.diseaseType = diseaseType;
        this.affections = affections;
    }

    @Override
    public MultiInputHMM getPhenotype(Individual i) {
        if (!this.affections.keySet().contains(i)) {
            return null;
        }
        return this.diseaseType.getMSHMM(this.affections.get(i));
    }

    @Override
    public List<PedigreeNode> phenotypeInputs(Individual i) {
        if (!this.affections.keySet().contains(i)) {
            return null;
        }
        ArrayList<PedigreeNode> result = new ArrayList<PedigreeNode>();
        for (int chrFrom = 0; chrFrom < 2; ++chrFrom) {
            result.add(PedigreeNode.createAlleleNode(i, chrFrom));
        }
        for (int j = 0; j < this.diseaseType.nDiseaseNodes(); ++j) {
            result.add(PedigreeNode.createDiseaseNode(j));
        }
        return result;
    }

    @Override
    public Collection<Individual> phenotypedIndividuals() {
        return this.affections.keySet();
    }
}

