/*
 * Decompiled with CFR 0.152.
 */
package pepper.editmodel.features;

import java.util.HashSet;
import java.util.Set;
import nuts.maxent.FeatureExtractor;
import nuts.maxent.LabeledInstance;
import nuts.util.Counter;
import pepper.Effect;
import pepper.Environment;

public class CutoffFeaturesExtractor<F>
implements FeatureExtractor<LabeledInstance<Environment, Effect>, F> {
    private final Set<F> allowedFeatures;
    private final FeatureExtractor<LabeledInstance<Environment, Effect>, F> extractor;

    private CutoffFeaturesExtractor(Set<F> allowedFeatures, FeatureExtractor<LabeledInstance<Environment, Effect>, F> extractor) {
        this.allowedFeatures = allowedFeatures;
        this.extractor = extractor;
    }

    public static <F> FeatureExtractor<LabeledInstance<Environment, Effect>, F> createCutOffFeaturesExtractor(double cutoff, FeatureExtractor<LabeledInstance<Environment, Effect>, F> extractor, Counter<LabeledInstance<Environment, Effect>> training) {
        Counter<Object> allFeatures = new Counter<Object>();
        for (LabeledInstance<Environment, Effect> labeledInstance : training) {
            double curMultiplicity = training.getCount(labeledInstance);
            Counter<F> curFeatures = extractor.extractFeatures(labeledInstance);
            for (F feature : curFeatures) {
                allFeatures.incrementCount(feature, curFeatures.getCount(feature) * curMultiplicity);
            }
        }
        HashSet allowedFeatures = new HashSet();
        for (Object feature : allFeatures.keySet()) {
            if (!(allFeatures.getCount(feature) >= cutoff)) continue;
            allowedFeatures.add(feature);
        }
        return new CutoffFeaturesExtractor(allowedFeatures, extractor);
    }

    @Override
    public Counter<F> extractFeatures(LabeledInstance<Environment, Effect> labeledInstance) {
        Counter<F> features = this.extractor.extractFeatures(labeledInstance);
        Counter<F> result = new Counter<F>();
        for (F key : features.keySet()) {
            if (!this.allowedFeatures.contains(key)) continue;
            double count = features.getCount(key);
            result.setCount(key, count);
        }
        return result;
    }

    @Override
    public double regularizationFactor(F feature) {
        return this.extractor.regularizationFactor(feature);
    }
}

