/*
 * Decompiled with CFR 0.152.
 */
package poly;

import java.io.IOException;
import poly.Fmath;

public class Complex {
    private double real = 0.0;
    private double imag = 0.0;
    private static char jori = (char)106;
    private static boolean infOption = true;

    public Complex() {
        this.real = 0.0;
        this.imag = 0.0;
    }

    public Complex(double real, double imag) {
        this.real = real;
        this.imag = imag;
    }

    public Complex(double real) {
        this.real = real;
        this.imag = 0.0;
    }

    public Complex(Complex c) {
        this.real = c.real;
        this.imag = c.imag;
    }

    public void setReal(double real) {
        this.real = real;
    }

    public void setImag(double imag) {
        this.imag = imag;
    }

    public void reset(double real, double imag) {
        this.real = real;
        this.imag = imag;
    }

    public void polarRad(double mod, double arg) {
        this.real = mod * Math.cos(arg);
        this.imag = mod * Math.sin(arg);
    }

    public void polar(double mod, double arg) {
        this.real = mod * Math.cos(arg);
        this.imag = mod * Math.sin(arg);
    }

    public void polarDeg(double mod, double arg) {
        arg = Math.toRadians(arg);
        this.real = mod * Math.cos(arg);
        this.imag = mod * Math.sin(arg);
    }

    public double getReal() {
        return this.real;
    }

    public double getImag() {
        return this.imag;
    }

    public static final synchronized Complex readComplex(String prompt) {
        int ch = 32;
        String cstring = "";
        boolean done = false;
        System.out.print(prompt + " ");
        System.out.flush();
        while (!done) {
            try {
                ch = System.in.read();
                if (ch < 0 || (char)ch == '\n') {
                    done = true;
                    continue;
                }
                cstring = cstring + (char)ch;
            }
            catch (IOException e) {
                done = true;
            }
        }
        return Complex.parseComplex(cstring);
    }

    public static final synchronized Complex readComplex(String prompt, String dflt) {
        int ch = 32;
        String cstring = "";
        boolean done = false;
        System.out.print(prompt + " [default value = " + dflt + "]  ");
        System.out.flush();
        int i = 0;
        while (!done) {
            try {
                ch = System.in.read();
                if (ch < 0 || (char)ch == '\n' || (char)ch == '\r') {
                    if (i == 0) {
                        cstring = dflt;
                        if ((char)ch == '\r') {
                            ch = System.in.read();
                        }
                    }
                    done = true;
                    continue;
                }
                cstring = cstring + (char)ch;
                ++i;
            }
            catch (IOException e) {
                done = true;
            }
        }
        return Complex.parseComplex(cstring);
    }

    public static final synchronized Complex readComplex(String prompt, Complex dflt) {
        int ch = 32;
        String cstring = "";
        boolean done = false;
        System.out.print(prompt + " [default value = " + dflt + "]  ");
        System.out.flush();
        int i = 0;
        while (!done) {
            try {
                ch = System.in.read();
                if (ch < 0 || (char)ch == '\n' || (char)ch == '\r') {
                    if (i == 0) {
                        if ((char)ch == '\r') {
                            ch = System.in.read();
                        }
                        return dflt;
                    }
                    done = true;
                    continue;
                }
                cstring = cstring + (char)ch;
                ++i;
            }
            catch (IOException e) {
                done = true;
            }
        }
        return Complex.parseComplex(cstring);
    }

    public static final synchronized Complex readComplex() {
        int ch = 32;
        String cstring = "";
        boolean done = false;
        System.out.print(" ");
        System.out.flush();
        while (!done) {
            try {
                ch = System.in.read();
                if (ch < 0 || (char)ch == '\n') {
                    done = true;
                    continue;
                }
                cstring = cstring + (char)ch;
            }
            catch (IOException e) {
                done = true;
            }
        }
        return Complex.parseComplex(cstring);
    }

    public void println(String message) {
        System.out.println(message + " " + this.toString());
    }

    public void println() {
        System.out.println(" " + this.toString());
    }

    public void print(String message) {
        System.out.print(message + " " + this.toString());
    }

    public void print() {
        System.out.print(" " + this.toString());
    }

    public static void println(String message, Complex[] aa) {
        System.out.println(message);
        for (int i = 0; i < aa.length; ++i) {
            System.out.println(aa[i].toString() + "  ");
        }
    }

    public static void println(Complex[] aa) {
        for (int i = 0; i < aa.length; ++i) {
            System.out.println(aa[i].toString() + "  ");
        }
    }

    public static void print(String message, Complex[] aa) {
        System.out.print(message + " ");
        for (int i = 0; i < aa.length; ++i) {
            System.out.print(aa[i].toString() + "   ");
        }
        System.out.println();
    }

    public static void print(Complex[] aa) {
        for (int i = 0; i < aa.length; ++i) {
            System.out.print(aa[i].toString() + "  ");
        }
        System.out.println();
    }

    public static Complex truncate(Complex x, int prec) {
        if (prec < 0) {
            return x;
        }
        double xR = x.getReal();
        double xI = x.getImag();
        Complex y = new Complex();
        xR = Fmath.truncate(xR, prec);
        xI = Fmath.truncate(xI, prec);
        y.reset(xR, xI);
        return y;
    }

    public Complex truncate(int prec) {
        if (prec < 0) {
            return this;
        }
        double xR = this.getReal();
        double xI = this.getImag();
        Complex y = new Complex();
        xR = Fmath.truncate(xR, prec);
        xI = Fmath.truncate(xI, prec);
        y.reset(xR, xI);
        return y;
    }

    public String toString() {
        char ch = '+';
        if (this.imag < 0.0) {
            ch = '-';
        }
        return this.real + " " + ch + " " + jori + Math.abs(this.imag);
    }

    public static String toString(Complex aa) {
        char ch = '+';
        if (aa.imag < 0.0) {
            ch = '-';
        }
        return aa.real + " " + ch + jori + Math.abs(aa.imag);
    }

    public static void setj() {
        jori = (char)106;
    }

    public static void seti() {
        jori = (char)105;
    }

    public static char getjori() {
        return jori;
    }

    public static Complex parseComplex(String ss) {
        int i;
        Complex aa = new Complex();
        ss = ss.trim();
        double first = 1.0;
        if (ss.charAt(0) == '-') {
            first = -1.0;
            ss = ss.substring(1);
        }
        if ((i = ss.indexOf(106)) == -1) {
            i = ss.indexOf(105);
        }
        if (i == -1) {
            throw new NumberFormatException("no i or j found");
        }
        int imagSign = 1;
        int j = ss.indexOf(43);
        if (j == -1 && (j = ss.indexOf(45)) > -1) {
            imagSign = -1;
        }
        if (j == -1) {
            throw new NumberFormatException("no + or - found");
        }
        int r0 = 0;
        int r1 = j;
        int i0 = i + 1;
        int i1 = ss.length();
        String sreal = ss.substring(r0, r1);
        String simag = ss.substring(i0, i1);
        aa.real = first * Double.parseDouble(sreal);
        aa.imag = (double)imagSign * Double.parseDouble(simag);
        return aa;
    }

    public static Complex valueOf(String ss) {
        return Complex.parseComplex(ss);
    }

    public int hashCode() {
        long lreal = Double.doubleToLongBits(this.real);
        long limag = Double.doubleToLongBits(this.imag);
        int hreal = (int)(lreal ^ lreal >>> 32);
        int himag = (int)(limag ^ limag >>> 32);
        return 7 * (hreal / 10) + 3 * (himag / 10);
    }

    public static Complex[] oneDarray(int n) {
        Complex[] a = new Complex[n];
        for (int i = 0; i < n; ++i) {
            a[i] = Complex.zero();
        }
        return a;
    }

    public static Complex[] oneDarray(int n, double a, double b) {
        Complex[] c = new Complex[n];
        for (int i = 0; i < n; ++i) {
            c[i] = Complex.zero();
            c[i].reset(a, b);
        }
        return c;
    }

    public static Complex mean(Complex[] aa) {
        int n = aa.length;
        Complex sum = new Complex(0.0, 0.0);
        for (int i = 0; i < n; ++i) {
            sum = sum.plus(aa[i]);
        }
        return sum.over(n);
    }

    public static Complex[] oneDarray(int n, Complex constant) {
        Complex[] c = new Complex[n];
        for (int i = 0; i < n; ++i) {
            c[i] = Complex.copy(constant);
        }
        return c;
    }

    public static Complex[][] twoDarray(int n, int m) {
        Complex[][] a = new Complex[n][m];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < m; ++j) {
                a[i][j] = Complex.zero();
            }
        }
        return a;
    }

    public static Complex[][] twoDarray(int n, int m, double a, double b) {
        Complex[][] c = new Complex[n][m];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < m; ++j) {
                c[i][j] = Complex.zero();
                c[i][j].reset(a, b);
            }
        }
        return c;
    }

    public static Complex[][] twoDarray(int n, int m, Complex constant) {
        Complex[][] c = new Complex[n][m];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < m; ++j) {
                c[i][j] = Complex.copy(constant);
            }
        }
        return c;
    }

    public static Complex[][][] threeDarray(int n, int m, int l) {
        Complex[][][] a = new Complex[n][m][l];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < m; ++j) {
                for (int k = 0; k < l; ++k) {
                    a[i][j][k] = Complex.zero();
                }
            }
        }
        return a;
    }

    public static Complex[][][] threeDarray(int n, int m, int l, double a, double b) {
        Complex[][][] c = new Complex[n][m][l];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < m; ++j) {
                for (int k = 0; k < l; ++k) {
                    c[i][j][k] = Complex.zero();
                    c[i][j][k].reset(a, b);
                }
            }
        }
        return c;
    }

    public static Complex[][][] threeDarray(int n, int m, int l, Complex constant) {
        Complex[][][] c = new Complex[n][m][l];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < m; ++j) {
                for (int k = 0; k < l; ++k) {
                    c[i][j][k] = Complex.copy(constant);
                }
            }
        }
        return c;
    }

    public static Complex copy(Complex a) {
        if (a == null) {
            return null;
        }
        Complex b = new Complex();
        b.real = a.real;
        b.imag = a.imag;
        return b;
    }

    public Complex copy() {
        if (this == null) {
            return null;
        }
        Complex b = new Complex();
        b.real = this.real;
        b.imag = this.imag;
        return b;
    }

    public static Complex[] copy(Complex[] a) {
        if (a == null) {
            return null;
        }
        int n = a.length;
        Complex[] b = Complex.oneDarray(n);
        for (int i = 0; i < n; ++i) {
            b[i] = Complex.copy(a[i]);
        }
        return b;
    }

    public static Complex[][] copy(Complex[][] a) {
        if (a == null) {
            return null;
        }
        int n = a.length;
        int m = a[0].length;
        Complex[][] b = Complex.twoDarray(n, m);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < m; ++j) {
                b[i][j] = Complex.copy(a[i][j]);
            }
        }
        return b;
    }

    public static Complex[][][] copy(Complex[][][] a) {
        if (a == null) {
            return null;
        }
        int n = a.length;
        int m = a[0].length;
        int l = a[0][0].length;
        Complex[][][] b = Complex.threeDarray(n, m, l);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < m; ++j) {
                for (int k = 0; k < l; ++k) {
                    b[i][j][k] = Complex.copy(a[i][j][k]);
                }
            }
        }
        return b;
    }

    public Object clone() {
        Complex ret = null;
        if (this != null) {
            Complex b = new Complex();
            b.real = this.real;
            b.imag = this.imag;
            ret = b;
        }
        return ret;
    }

    public static Complex plus(Complex a, Complex b) {
        Complex c = new Complex();
        c.real = a.real + b.real;
        c.imag = a.imag + b.imag;
        return c;
    }

    public static Complex plus(Complex a, double b) {
        Complex c = new Complex();
        c.real = a.real + b;
        c.imag = a.imag;
        return c;
    }

    public static Complex plus(double a, Complex b) {
        Complex c = new Complex();
        c.real = a + b.real;
        c.imag = b.imag;
        return c;
    }

    public static Complex plus(double a, double b) {
        Complex c = new Complex();
        c.real = a + b;
        c.imag = 0.0;
        return c;
    }

    public Complex plus(Complex a) {
        Complex b = new Complex();
        b.real = this.real + a.real;
        b.imag = this.imag + a.imag;
        return b;
    }

    public Complex plus(double a) {
        Complex b = new Complex();
        b.real = this.real + a;
        b.imag = this.imag;
        return b;
    }

    public void plusEquals(Complex a) {
        this.real += a.real;
        this.imag += a.imag;
    }

    public void plusEquals(double a) {
        this.real += a;
        this.imag = this.imag;
    }

    public static Complex minus(Complex a, Complex b) {
        Complex c = new Complex();
        c.real = a.real - b.real;
        c.imag = a.imag - b.imag;
        return c;
    }

    public static Complex minus(Complex a, double b) {
        Complex c = new Complex();
        c.real = a.real - b;
        c.imag = a.imag;
        return c;
    }

    public static Complex minus(double a, Complex b) {
        Complex c = new Complex();
        c.real = a - b.real;
        c.imag = -b.imag;
        return c;
    }

    public static Complex minus(double a, double b) {
        Complex c = new Complex();
        c.real = a - b;
        c.imag = 0.0;
        return c;
    }

    public Complex minus(Complex a) {
        Complex b = new Complex();
        b.real = this.real - a.real;
        b.imag = this.imag - a.imag;
        return b;
    }

    public Complex minus(double a) {
        Complex b = new Complex();
        b.real = this.real - a;
        b.imag = this.imag;
        return b;
    }

    public Complex transposedMinus(double a) {
        Complex b = new Complex();
        b.real = a - this.real;
        b.imag = this.imag;
        return b;
    }

    public void minusEquals(Complex a) {
        this.real -= a.real;
        this.imag -= a.imag;
    }

    public void minusEquals(double a) {
        this.real -= a;
        this.imag = this.imag;
    }

    public static void setInfOption(boolean infOpt) {
        infOption = infOpt;
    }

    public static void setInfOption(int opt) {
        if (opt < 0 || opt > 1) {
            throw new IllegalArgumentException("opt must be 0 or 1");
        }
        infOption = true;
        if (opt == 1) {
            infOption = false;
        }
    }

    public static boolean getInfOption() {
        return infOption;
    }

    public static Complex times(Complex a, Complex b) {
        Complex c = new Complex(0.0, 0.0);
        if (infOption) {
            if (a.isInfinite() && !b.isZero()) {
                c.reset(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
                return c;
            }
            if (b.isInfinite() && !a.isZero()) {
                c.reset(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
                return c;
            }
        }
        c.real = a.real * b.real - a.imag * b.imag;
        c.imag = a.real * b.imag + a.imag * b.real;
        return c;
    }

    public static Complex times(Complex a, double b) {
        Complex c = new Complex();
        if (infOption) {
            if (a.isInfinite() && b != 0.0) {
                c.reset(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
                return c;
            }
            if (Fmath.isInfinity(b) && !a.isZero()) {
                c.reset(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
                return c;
            }
        }
        c.real = a.real * b;
        c.imag = a.imag * b;
        return c;
    }

    public static Complex times(double a, Complex b) {
        Complex c = new Complex();
        if (infOption) {
            if (b.isInfinite() && a != 0.0) {
                c.reset(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
                return c;
            }
            if (Fmath.isInfinity(a) && !b.isZero()) {
                c.reset(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
                return c;
            }
        }
        c.real = a * b.real;
        c.imag = a * b.imag;
        return c;
    }

    public static Complex times(double a, double b) {
        Complex c = new Complex();
        c.real = a * b;
        c.imag = 0.0;
        return c;
    }

    public Complex times(Complex a) {
        Complex b = new Complex();
        if (infOption) {
            if (this.isInfinite() && !a.isZero()) {
                b.reset(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
                return b;
            }
            if (a.isInfinite() && !this.isZero()) {
                b.reset(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
                return b;
            }
        }
        b.real = this.real * a.real - this.imag * a.imag;
        b.imag = this.real * a.imag + this.imag * a.real;
        return b;
    }

    public Complex times(double a) {
        Complex b = new Complex();
        if (infOption) {
            if (this.isInfinite() && a != 0.0) {
                b.reset(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
                return b;
            }
            if (Fmath.isInfinity(a) && !this.isZero()) {
                b.reset(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
                return b;
            }
        }
        b.real = this.real * a;
        b.imag = this.imag * a;
        return b;
    }

    public void timesEquals(Complex a) {
        Complex b = new Complex();
        boolean test = true;
        if (infOption && (this.isInfinite() && !a.isZero() || a.isInfinite() && !this.isZero())) {
            this.real = Double.POSITIVE_INFINITY;
            this.imag = Double.POSITIVE_INFINITY;
            test = false;
        }
        if (test) {
            b.real = a.real * this.real - a.imag * this.imag;
            b.imag = a.real * this.imag + a.imag * this.real;
            this.real = b.real;
            this.imag = b.imag;
        }
    }

    public void timesEquals(double a) {
        boolean test = true;
        if (infOption && (this.isInfinite() && a != 0.0 || Fmath.isInfinity(a) && !this.isZero())) {
            this.real = Double.POSITIVE_INFINITY;
            this.imag = Double.POSITIVE_INFINITY;
            test = false;
        }
        if (test) {
            this.real *= a;
            this.imag *= a;
        }
    }

    public static Complex over(Complex a, Complex b) {
        Complex c = new Complex(0.0, 0.0);
        if (infOption && !a.isInfinite() && b.isInfinite()) {
            return c;
        }
        double denom = 0.0;
        double ratio = 0.0;
        if (a.isZero()) {
            if (b.isZero()) {
                c.real = Double.NaN;
                c.imag = Double.NaN;
            } else {
                c.real = 0.0;
                c.imag = 0.0;
            }
        } else if (Math.abs(b.real) >= Math.abs(b.imag)) {
            ratio = b.imag / b.real;
            denom = b.real + b.imag * ratio;
            c.real = (a.real + a.imag * ratio) / denom;
            c.imag = (a.imag - a.real * ratio) / denom;
        } else {
            ratio = b.real / b.imag;
            denom = b.real * ratio + b.imag;
            c.real = (a.real * ratio + a.imag) / denom;
            c.imag = (a.imag * ratio - a.real) / denom;
        }
        return c;
    }

    public static Complex over(Complex a, double b) {
        Complex c = new Complex(0.0, 0.0);
        if (infOption && Fmath.isInfinity(b)) {
            return c;
        }
        c.real = a.real / b;
        c.imag = a.imag / b;
        return c;
    }

    public static Complex over(double a, Complex b) {
        Complex c = new Complex();
        if (infOption && !Fmath.isInfinity(a) && b.isInfinite()) {
            return c;
        }
        if (a == 0.0) {
            if (b.isZero()) {
                c.real = Double.NaN;
                c.imag = Double.NaN;
            } else {
                c.real = 0.0;
                c.imag = 0.0;
            }
        } else if (Math.abs(b.real) >= Math.abs(b.imag)) {
            double ratio = b.imag / b.real;
            double denom = b.real + b.imag * ratio;
            c.real = a / denom;
            c.imag = -a * ratio / denom;
        } else {
            double ratio = b.real / b.imag;
            double denom = b.real * ratio + b.imag;
            c.real = a * ratio / denom;
            c.imag = -a / denom;
        }
        return c;
    }

    public static Complex over(double a, double b) {
        Complex c = new Complex();
        c.real = a / b;
        c.imag = 0.0;
        return c;
    }

    public Complex over(Complex a) {
        Complex b = new Complex(0.0, 0.0);
        if (infOption && !this.isInfinite() && a.isInfinite()) {
            return b;
        }
        double denom = 0.0;
        double ratio = 0.0;
        if (Math.abs(a.real) >= Math.abs(a.imag)) {
            ratio = a.imag / a.real;
            denom = a.real + a.imag * ratio;
            b.real = (this.real + this.imag * ratio) / denom;
            b.imag = (this.imag - this.real * ratio) / denom;
        } else {
            ratio = a.real / a.imag;
            denom = a.real * ratio + a.imag;
            b.real = (this.real * ratio + this.imag) / denom;
            b.imag = (this.imag * ratio - this.real) / denom;
        }
        return b;
    }

    public Complex over(double a) {
        Complex b = new Complex(0.0, 0.0);
        b.real = this.real / a;
        b.imag = this.imag / a;
        return b;
    }

    public Complex transposedOver(double a) {
        Complex c = new Complex(0.0, 0.0);
        if (infOption && !Fmath.isInfinity(a) && this.isInfinite()) {
            return c;
        }
        double denom = 0.0;
        double ratio = 0.0;
        if (Math.abs(this.real) >= Math.abs(this.imag)) {
            ratio = this.imag / this.real;
            denom = this.real + this.imag * ratio;
            c.real = a / denom;
            c.imag = -a * ratio / denom;
        } else {
            ratio = this.real / this.imag;
            denom = this.real * ratio + this.imag;
            c.real = a * ratio / denom;
            c.imag = -a / denom;
        }
        return c;
    }

    public void overEquals(Complex b) {
        Complex c = new Complex(0.0, 0.0);
        boolean test = true;
        if (infOption && !this.isInfinite() && b.isInfinite()) {
            this.real = 0.0;
            this.imag = 0.0;
            test = false;
        }
        if (test) {
            double denom = 0.0;
            double ratio = 0.0;
            if (Math.abs(b.real) >= Math.abs(b.imag)) {
                ratio = b.imag / b.real;
                denom = b.real + b.imag * ratio;
                c.real = (this.real + this.imag * ratio) / denom;
                c.imag = (this.imag - this.real * ratio) / denom;
            } else {
                ratio = b.real / b.imag;
                denom = b.real * ratio + b.imag;
                c.real = (this.real * ratio + this.imag) / denom;
                c.imag = (this.imag * ratio - this.real) / denom;
            }
            this.real = c.real;
            this.imag = c.imag;
        }
    }

    public void overEquals(double a) {
        this.real /= a;
        this.imag /= a;
    }

    public static Complex inverse(Complex a) {
        Complex b = new Complex(0.0, 0.0);
        if (infOption && a.isInfinite()) {
            return b;
        }
        b = Complex.over(1.0, a);
        return b;
    }

    public Complex inverse() {
        Complex b = new Complex(0.0, 0.0);
        b = Complex.over(1.0, this);
        return b;
    }

    public static Complex negate(Complex a) {
        Complex c = new Complex();
        c.real = -a.real;
        c.imag = -a.imag;
        return c;
    }

    public Complex negate() {
        Complex c = new Complex();
        c.real = -this.real;
        c.imag = -this.imag;
        return c;
    }

    public static double abs(Complex a) {
        double rmod = Math.abs(a.real);
        double imod = Math.abs(a.imag);
        double ratio = 0.0;
        double res = 0.0;
        if (rmod == 0.0) {
            res = imod;
        } else {
            if (imod == 0.0) {
                res = rmod;
            }
            if (rmod >= imod) {
                ratio = a.imag / a.real;
                res = rmod * Math.sqrt(1.0 + ratio * ratio);
            } else {
                ratio = a.real / a.imag;
                res = imod * Math.sqrt(1.0 + ratio * ratio);
            }
        }
        return res;
    }

    public double abs() {
        double rmod = Math.abs(this.real);
        double imod = Math.abs(this.imag);
        double ratio = 0.0;
        double res = 0.0;
        if (rmod == 0.0) {
            res = imod;
        } else {
            if (imod == 0.0) {
                res = rmod;
            }
            if (rmod >= imod) {
                ratio = this.imag / this.real;
                res = rmod * Math.sqrt(1.0 + ratio * ratio);
            } else {
                ratio = this.real / this.imag;
                res = imod * Math.sqrt(1.0 + ratio * ratio);
            }
        }
        return res;
    }

    public static double squareAbs(Complex a) {
        return a.real * a.real + a.imag * a.imag;
    }

    public double squareAbs() {
        return this.real * this.real + this.imag * this.imag;
    }

    public static double arg(Complex a) {
        return Math.atan2(a.imag, a.real);
    }

    public double arg() {
        return Math.atan2(this.imag, this.real);
    }

    public static double argRad(Complex a) {
        return Math.atan2(a.imag, a.real);
    }

    public double argRad() {
        return Math.atan2(this.imag, this.real);
    }

    public static double argDeg(Complex a) {
        return Math.toDegrees(Math.atan2(a.imag, a.real));
    }

    public double argDeg() {
        return Math.toDegrees(Math.atan2(this.imag, this.real));
    }

    public static Complex conjugate(Complex a) {
        Complex c = new Complex();
        c.real = a.real;
        c.imag = -a.imag;
        return c;
    }

    public Complex conjugate() {
        Complex c = new Complex();
        c.real = this.real;
        c.imag = -this.imag;
        return c;
    }

    public static double hypot(Complex aa, Complex bb) {
        double amod = Complex.abs(aa);
        double bmod = Complex.abs(bb);
        double cc = 0.0;
        double ratio = 0.0;
        if (amod == 0.0) {
            cc = bmod;
        } else if (bmod == 0.0) {
            cc = amod;
        } else if (amod >= bmod) {
            ratio = bmod / amod;
            cc = amod * Math.sqrt(1.0 + ratio * ratio);
        } else {
            ratio = amod / bmod;
            cc = bmod * Math.sqrt(1.0 + ratio * ratio);
        }
        return cc;
    }

    public static Complex exp(Complex aa) {
        Complex z = new Complex();
        double a = aa.real;
        double b = aa.imag;
        if (b == 0.0) {
            z.real = Math.exp(a);
            z.imag = 0.0;
        } else if (a == 0.0) {
            z.real = Math.cos(b);
            z.imag = Math.sin(b);
        } else {
            double c = Math.exp(a);
            z.real = c * Math.cos(b);
            z.imag = c * Math.sin(b);
        }
        return z;
    }

    public static Complex exp(double aa) {
        Complex bb = new Complex(aa, 0.0);
        return Complex.exp(bb);
    }

    public static Complex expPlusJayArg(double arg) {
        Complex argc = new Complex(0.0, arg);
        return Complex.exp(argc);
    }

    public static Complex expMinusJayArg(double arg) {
        Complex argc = new Complex(0.0, -arg);
        return Complex.exp(argc);
    }

    public static Complex log(Complex aa) {
        double a = aa.real;
        double b = aa.imag;
        Complex c = new Complex();
        c.real = Math.log(Complex.abs(aa));
        c.imag = Math.atan2(b, a);
        return c;
    }

    public static Complex sqrt(Complex aa) {
        double a = aa.real;
        double b = aa.imag;
        Complex c = new Complex();
        if (b == 0.0) {
            if (a >= 0.0) {
                c.real = Math.sqrt(a);
                c.imag = 0.0;
            } else {
                c.real = 0.0;
                c.imag = Math.sqrt(-a);
            }
        } else {
            double w;
            double bmod;
            double amod = Math.abs(a);
            if (amod >= (bmod = Math.abs(b))) {
                double ratio = b / a;
                w = Math.sqrt(amod) * Math.sqrt(0.5 * (1.0 + Math.sqrt(1.0 + ratio * ratio)));
            } else {
                double ratio = a / b;
                w = Math.sqrt(bmod) * Math.sqrt(0.5 * (Math.abs(ratio) + Math.sqrt(1.0 + ratio * ratio)));
            }
            if (a >= 0.0) {
                c.real = w;
                c.imag = b / (2.0 * w);
            } else if (b >= 0.0) {
                c.imag = w;
                c.real = bmod / (2.0 * c.imag);
            } else {
                c.imag = -w;
                c.real = bmod / (2.0 * c.imag);
            }
        }
        return c;
    }

    public static Complex nthRoot(Complex aa, int n) {
        if (n == 0) {
            throw new ArithmeticException("Division by zero (n = 0 - infinite root) attempted in Complex.nthRoot");
        }
        double a = aa.real;
        double b = aa.imag;
        Complex c = new Complex();
        double d = n;
        double r = Math.pow(Complex.abs(aa), 1.0 / d);
        double theta = Math.atan2(b, a) / d;
        c.real = r * Math.cos(theta);
        c.imag = r * Math.sin(theta);
        return c;
    }

    public static Complex square(Complex aa) {
        Complex c = new Complex();
        c.real = aa.real * aa.real - aa.imag * aa.imag;
        c.imag = 2.0 * aa.real * aa.imag;
        return c;
    }

    public static Complex pow(Complex a, Complex b) {
        Complex c = new Complex();
        c = Complex.exp(Complex.times(b, Complex.log(a)));
        return c;
    }

    public static Complex pow(Complex a, double b) {
        return Complex.powDouble(a, b);
    }

    public static Complex pow(Complex a, int n) {
        double b = n;
        return Complex.powDouble(a, b);
    }

    public static Complex pow(double a, Complex b) {
        Complex c = new Complex();
        double z = Math.pow(a, b.real);
        c = Complex.exp(Complex.times(Complex.plusJay(), b.imag * Math.log(a)));
        c = Complex.times(z, c);
        return c;
    }

    public static Complex sin(Complex aa) {
        Complex c = new Complex();
        double a = aa.real;
        double b = aa.imag;
        c.real = Math.sin(a) * Fmath.cosh(b);
        c.imag = Math.cos(a) * Fmath.sinh(b);
        return c;
    }

    public static Complex cos(Complex aa) {
        Complex c = new Complex();
        double a = aa.real;
        double b = aa.imag;
        c.real = Math.cos(a) * Fmath.cosh(b);
        c.imag = -Math.sin(a) * Fmath.sinh(b);
        return c;
    }

    public static Complex sec(Complex aa) {
        Complex c = new Complex();
        double a = aa.real;
        double b = aa.imag;
        c.real = Math.cos(a) * Fmath.cosh(b);
        c.imag = -Math.sin(a) * Fmath.sinh(b);
        return c.inverse();
    }

    public static Complex csc(Complex aa) {
        Complex c = new Complex();
        double a = aa.real;
        double b = aa.imag;
        c.real = Math.sin(a) * Fmath.cosh(b);
        c.imag = Math.cos(a) * Fmath.sinh(b);
        return c.inverse();
    }

    public static Complex tan(Complex aa) {
        Complex c = new Complex();
        double denom = 0.0;
        double a = aa.real;
        double b = aa.imag;
        Complex x = new Complex(Math.sin(a) * Fmath.cosh(b), Math.cos(a) * Fmath.sinh(b));
        Complex y = new Complex(Math.cos(a) * Fmath.cosh(b), -Math.sin(a) * Fmath.sinh(b));
        c = Complex.over(x, y);
        return c;
    }

    public static Complex cot(Complex aa) {
        Complex c = new Complex();
        double denom = 0.0;
        double a = aa.real;
        double b = aa.imag;
        Complex x = new Complex(Math.sin(a) * Fmath.cosh(b), Math.cos(a) * Fmath.sinh(b));
        Complex y = new Complex(Math.cos(a) * Fmath.cosh(b), -Math.sin(a) * Fmath.sinh(b));
        c = Complex.over(y, x);
        return c;
    }

    public static Complex exsec(Complex aa) {
        return Complex.sec(aa).minus(1.0);
    }

    public static Complex vers(Complex aa) {
        return Complex.plusOne().minus(Complex.cos(aa));
    }

    public static Complex covers(Complex aa) {
        return Complex.plusOne().minus(Complex.sin(aa));
    }

    public static Complex hav(Complex aa) {
        return Complex.vers(aa).over(2.0);
    }

    public static Complex sinh(Complex a) {
        Complex c = new Complex();
        c = a.times(Complex.plusJay());
        c = Complex.minusJay().times(Complex.sin(c));
        return c;
    }

    public static Complex cosh(Complex a) {
        Complex c = new Complex();
        c = a.times(Complex.plusJay());
        c = Complex.cos(c);
        return c;
    }

    public static Complex tanh(Complex a) {
        Complex c = new Complex();
        c = Complex.sinh(a).over(Complex.cosh(a));
        return c;
    }

    public static Complex coth(Complex a) {
        Complex c = new Complex();
        c = Complex.cosh(a).over(Complex.sinh(a));
        return c;
    }

    public static Complex sech(Complex a) {
        Complex c = new Complex();
        c = Complex.cosh(a).inverse();
        return c;
    }

    public static Complex csch(Complex a) {
        Complex c = new Complex();
        c = Complex.sinh(a).inverse();
        return c;
    }

    public static Complex asin(Complex a) {
        Complex c = new Complex();
        c = Complex.sqrt(Complex.minus(1.0, Complex.square(a)));
        c = Complex.plusJay().times(a).plus(c);
        c = Complex.minusJay().times(Complex.log(c));
        return c;
    }

    public static Complex acos(Complex a) {
        Complex c = new Complex();
        c = Complex.sqrt(Complex.minus(Complex.square(a), 1.0));
        c = a.plus(c);
        c = Complex.minusJay().times(Complex.log(c));
        return c;
    }

    public static Complex atan(Complex a) {
        Complex c = new Complex();
        Complex d = new Complex();
        c = Complex.plusJay().plus(a);
        d = Complex.plusJay().minus(a);
        c = c.over(d);
        c = Complex.log(c);
        c = Complex.plusJay().times(c);
        c = c.over(2.0);
        return c;
    }

    public static Complex acot(Complex a) {
        return Complex.atan(a.inverse());
    }

    public static Complex asec(Complex a) {
        return Complex.acos(a.inverse());
    }

    public static Complex acsc(Complex a) {
        return Complex.asin(a.inverse());
    }

    public static Complex aexsec(Complex a) {
        Complex c = a.plus(1.0);
        return Complex.asin(c.inverse());
    }

    public static Complex avers(Complex a) {
        Complex c = Complex.plusOne().plus(a);
        return Complex.acos(c);
    }

    public static Complex acovers(Complex a) {
        Complex c = Complex.plusOne().plus(a);
        return Complex.asin(c);
    }

    public static Complex ahav(Complex a) {
        Complex c = Complex.plusOne().minus(a.times(2.0));
        return Complex.acos(c);
    }

    public static Complex asinh(Complex a) {
        Complex c = new Complex(0.0, 0.0);
        c = Complex.sqrt(Complex.square(a).plus(1.0));
        c = a.plus(c);
        c = Complex.log(c);
        return c;
    }

    public static Complex acosh(Complex a) {
        Complex c = new Complex();
        c = Complex.sqrt(Complex.square(a).minus(1.0));
        c = a.plus(c);
        c = Complex.log(c);
        return c;
    }

    public static Complex atanh(Complex a) {
        Complex c = new Complex();
        Complex d = new Complex();
        c = Complex.plusOne().plus(a);
        d = Complex.plusOne().minus(a);
        c = c.over(d);
        c = Complex.log(c);
        c = c.over(2.0);
        return c;
    }

    public static Complex acoth(Complex a) {
        Complex c = new Complex();
        Complex d = new Complex();
        c = Complex.plusOne().plus(a);
        d = a.plus(1.0);
        c = c.over(d);
        c = Complex.log(c);
        c = c.over(2.0);
        return c;
    }

    public static Complex asech(Complex a) {
        Complex c = a.inverse();
        Complex d = Complex.square(a).minus(1.0);
        return Complex.log(c.plus(Complex.sqrt(d)));
    }

    public static Complex acsch(Complex a) {
        Complex c = a.inverse();
        Complex d = Complex.square(a).plus(1.0);
        return Complex.log(c.plus(Complex.sqrt(d)));
    }

    public static boolean isReal(Complex a) {
        boolean test = false;
        if (a.imag == 0.0) {
            test = true;
        }
        return test;
    }

    public boolean isReal() {
        boolean test = false;
        if (Math.abs(this.imag) == 0.0) {
            test = true;
        }
        return test;
    }

    public static boolean isZero(Complex a) {
        boolean test = false;
        if (Math.abs(a.real) == 0.0 && Math.abs(a.imag) == 0.0) {
            test = true;
        }
        return test;
    }

    public boolean isZero() {
        boolean test = false;
        if (Math.abs(this.real) == 0.0 && Math.abs(this.imag) == 0.0) {
            test = true;
        }
        return test;
    }

    public boolean isPlusInfinity() {
        boolean test = false;
        if (this.real == Double.POSITIVE_INFINITY || this.imag == Double.POSITIVE_INFINITY) {
            test = true;
        }
        return test;
    }

    public static boolean isPlusInfinity(Complex a) {
        boolean test = false;
        if (a.real == Double.POSITIVE_INFINITY || a.imag == Double.POSITIVE_INFINITY) {
            test = true;
        }
        return test;
    }

    public boolean isMinusInfinity() {
        boolean test = false;
        if (this.real == Double.NEGATIVE_INFINITY || this.imag == Double.NEGATIVE_INFINITY) {
            test = true;
        }
        return test;
    }

    public static boolean isMinusInfinity(Complex a) {
        boolean test = false;
        if (a.real == Double.NEGATIVE_INFINITY || a.imag == Double.NEGATIVE_INFINITY) {
            test = true;
        }
        return test;
    }

    public static boolean isInfinite(Complex a) {
        boolean test = false;
        if (a.real == Double.POSITIVE_INFINITY || a.imag == Double.POSITIVE_INFINITY) {
            test = true;
        }
        if (a.real == Double.NEGATIVE_INFINITY || a.imag == Double.NEGATIVE_INFINITY) {
            test = true;
        }
        return test;
    }

    public boolean isInfinite() {
        boolean test = false;
        if (this.real == Double.POSITIVE_INFINITY || this.imag == Double.POSITIVE_INFINITY) {
            test = true;
        }
        if (this.real == Double.NEGATIVE_INFINITY || this.imag == Double.NEGATIVE_INFINITY) {
            test = true;
        }
        return test;
    }

    public static boolean isNaN(Complex a) {
        boolean test = false;
        if (a.real != a.real || a.imag != a.imag) {
            test = true;
        }
        return test;
    }

    public boolean isNaN() {
        boolean test = false;
        if (this.real != this.real || this.imag != this.imag) {
            test = true;
        }
        return test;
    }

    public boolean equals(Complex a) {
        boolean test = false;
        if (this.isNaN() && a.isNaN()) {
            test = true;
        } else if (this.real == a.real && this.imag == a.imag) {
            test = true;
        }
        return test;
    }

    public boolean isEqual(Complex a) {
        boolean test = false;
        if (this.isNaN() && a.isNaN()) {
            test = true;
        } else if (this.real == a.real && this.imag == a.imag) {
            test = true;
        }
        return test;
    }

    public static boolean isEqual(Complex a, Complex b) {
        boolean test = false;
        if (Complex.isNaN(a) && Complex.isNaN(b)) {
            test = true;
        } else if (a.real == b.real && a.imag == b.imag) {
            test = true;
        }
        return test;
    }

    public boolean equalsWithinLimits(Complex a, double fract) {
        return this.isEqualWithinLimits(a, fract);
    }

    public boolean isEqualWithinLimits(Complex a, double fract) {
        boolean test = false;
        double rt = this.getReal();
        double ra = a.getReal();
        double it = this.getImag();
        double ia = a.getImag();
        double rdn = 0.0;
        double idn = 0.0;
        double rtest = 0.0;
        double itest = 0.0;
        if (rt == 0.0 && it == 0.0 && ra == 0.0 && ia == 0.0) {
            test = true;
        }
        if (!test) {
            rdn = Math.abs(rt);
            if (Math.abs(ra) > rdn) {
                rdn = Math.abs(ra);
            }
            rtest = rdn == 0.0 ? 0.0 : Math.abs(ra - rt) / rdn;
            idn = Math.abs(it);
            if (Math.abs(ia) > idn) {
                idn = Math.abs(ia);
            }
            itest = idn == 0.0 ? 0.0 : Math.abs(ia - it) / idn;
            if (rtest < fract && itest < fract) {
                test = true;
            }
        }
        return test;
    }

    public static boolean isEqualWithinLimits(Complex a, Complex b, double fract) {
        boolean test = false;
        double rb = b.getReal();
        double ra = a.getReal();
        double ib = b.getImag();
        double ia = a.getImag();
        double rdn = 0.0;
        double idn = 0.0;
        if (ra == 0.0 && ia == 0.0 && rb == 0.0 && ib == 0.0) {
            test = true;
        }
        if (!test) {
            rdn = Math.abs(rb);
            if (Math.abs(ra) > rdn) {
                rdn = Math.abs(ra);
            }
            idn = Math.abs(ib);
            if (Math.abs(ia) > idn) {
                idn = Math.abs(ia);
            }
            if (Math.abs(ra - rb) / rdn < fract && Math.abs(ia - ia) / idn < fract) {
                test = true;
            }
        }
        return test;
    }

    public static Complex zero() {
        Complex c = new Complex();
        c.real = 0.0;
        c.imag = 0.0;
        return c;
    }

    public static Complex plusOne() {
        Complex c = new Complex();
        c.real = 1.0;
        c.imag = 0.0;
        return c;
    }

    public static Complex minusOne() {
        Complex c = new Complex();
        c.real = -1.0;
        c.imag = 0.0;
        return c;
    }

    public static Complex plusJay() {
        Complex c = new Complex();
        c.real = 0.0;
        c.imag = 1.0;
        return c;
    }

    public static Complex minusJay() {
        Complex c = new Complex();
        c.real = 0.0;
        c.imag = -1.0;
        return c;
    }

    public static Complex pi() {
        Complex c = new Complex();
        c.real = Math.PI;
        c.imag = 0.0;
        return c;
    }

    public static Complex twoPiJay() {
        Complex c = new Complex();
        c.real = 0.0;
        c.imag = Math.PI * 2;
        return c;
    }

    public static Complex plusInfinity() {
        Complex c = new Complex();
        c.real = Double.POSITIVE_INFINITY;
        c.imag = Double.POSITIVE_INFINITY;
        return c;
    }

    public static Complex minusInfinity() {
        Complex c = new Complex();
        c.real = Double.NEGATIVE_INFINITY;
        c.imag = Double.NEGATIVE_INFINITY;
        return c;
    }

    private static Complex powDouble(Complex a, double b) {
        Complex z = new Complex();
        double re = a.real;
        double im = a.imag;
        if (im == 0.0) {
            z.real = Math.pow(re, b);
            z.imag = 0.0;
        } else if (re == 0.0) {
            z = Complex.exp(Complex.times(b, Complex.log(a)));
        } else {
            double c = Math.pow(re * re + im * im, b / 2.0);
            double th = Math.atan2(im, re);
            z.real = c * Math.cos(b * th);
            z.imag = c * Math.sin(b * th);
        }
        return z;
    }
}

