/*
 * Decompiled with CFR 0.152.
 */
package pty.smc;

import fig.exec.Execution;
import goblin.Taxon;
import java.util.ArrayList;
import java.util.Map;
import nuts.util.Arbre;
import pty.io.Dataset;
import pty.io.HGDPDataset;
import pty.smc.models.BrownianModel;
import pty.smc.models.BrownianModelCalculator;
import pty.smc.models.LikelihoodModelCalculator;

public class TestLikelihood
implements Runnable {
    Arbre<String> inputArbre;

    private void init(Dataset data) {
        BrownianModel bm = new BrownianModel(1, 1.0);
        ArrayList<Taxon> leafNames = new ArrayList<Taxon>();
        ArrayList<BrownianModelCalculator> leaves = new ArrayList<BrownianModelCalculator>();
        Map<Taxon, double[][]> observations = data.observations();
        int n = observations.keySet().size();
        for (Taxon lang : observations.keySet()) {
            leafNames.add(lang);
            double[][] cObs = observations.get(lang);
            double[] converted = new double[cObs.length];
            for (int i = 0; i < converted.length; ++i) {
                converted[i] = cObs[i][0];
            }
            leaves.add(BrownianModelCalculator.observation(converted, bm, false));
        }
        while (n > 1) {
            ArrayList<LikelihoodModelCalculator> tmp = new ArrayList<LikelihoodModelCalculator>();
            for (int i = 0; i < n; i += 2) {
                tmp.add(((LikelihoodModelCalculator)leaves.get(i)).combine((LikelihoodModelCalculator)leaves.get(i), (LikelihoodModelCalculator)leaves.get(i + 1), 1.0, 1.0, false));
            }
            leaves = tmp;
            n = leaves.size();
        }
        System.out.println("Log l =" + ((LikelihoodModelCalculator)leaves.get(0)).logLikelihood());
        double llnew = -(Math.log(6.0) + 0.5 * Math.log(7.0) + 1.5 * Math.log(Math.PI));
        double llold = -(Math.log(96.0) + 0.5 * Math.log(5.0) + 3.5 * Math.log(Math.PI));
        double lz1 = -0.5 * Math.log(Math.PI * 4);
        double lz2 = -0.5 * Math.log(Math.PI * 6);
        double lz3 = -0.5 * Math.log(Math.PI * 7);
        double ll1 = lz1;
        double ll2 = lz2 + 2.0 * lz1;
        double ll3 = lz3 + 2.0 * lz2;
        System.out.println(ll1 + "\t" + ll2 + "\t" + ll3);
        System.out.println("Log l  =" + llnew + "\t" + llold);
    }

    public void computeLogLikelihood() {
    }

    public static void main(String[] args) {
        Execution.run(args, new TestLikelihood(), "hgdp", HGDPDataset.class);
    }

    @Override
    public void run() {
        Dataset data = Dataset.DatasetType.HGDP.loadDataset();
        this.init(data);
    }
}

