/*
 * Decompiled with CFR 0.152.
 */
package slice;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import slice.Sampler;
import slice.likelihood.NormalLocation;
import slice.likelihood.NormalMeanFixedVarLocationDist;
import slice.ndp.NDPLocation;
import slice.ndp.NDPLocationDistribution;
import slice.processor.ExpectedTopLocation;
import slice.processor.PrintSampleProcessor;
import slice.stickrep.DPMSample;
import slice.stickrep.DataGenerator;

public class Main {
    public static void main(String[] args) {
        Main.nDPSliceSampler();
    }

    public static void nDPSliceSampler() {
        Random rand = new Random();
        double alpha0 = 4.0;
        int truncation = 50;
        double subAlpha0 = 4.0;
        double fixedDeltaOnVar = 1.0;
        NDPLocation.eraseIndicatorInfo = false;
        NDPLocation.numberOfPointPerCluster = 50;
        ExpectedTopLocation.numberOfClusters = 10;
        ExpectedTopLocation.numberOfSubclusters = 10;
        ArrayList<Double> priorMeanOnMean = new ArrayList<Double>();
        priorMeanOnMean.add(0.0);
        priorMeanOnMean.add(0.0);
        ArrayList<Double> priorVarOnMean = new ArrayList<Double>();
        priorVarOnMean.add(100.0);
        priorVarOnMean.add(100.0);
        ArrayList<Double> deltaOnVar = new ArrayList<Double>();
        deltaOnVar.add(fixedDeltaOnVar);
        deltaOnVar.add(fixedDeltaOnVar);
        NormalMeanFixedVarLocationDist subPrior = new NormalMeanFixedVarLocationDist(priorMeanOnMean, priorVarOnMean, deltaOnVar);
        NDPLocationDistribution<NormalLocation, List<Double>> prior = new NDPLocationDistribution<NormalLocation, List<Double>>(truncation, subPrior, subAlpha0);
        DataGenerator<NormalLocation, List<Double>> gen = new DataGenerator<NormalLocation, List<Double>>(prior, alpha0);
        DPMSample<NormalLocation, List<Double>> trueSample = gen.generateSample(150, rand);
        System.out.println(ExpectedTopLocation.f(trueSample));
        Sampler<NormalLocation, List<Double>> sampler = Sampler.createTruncSampler(trueSample.getData(), prior, alpha0);
        sampler.basicInit(3, rand);
        ExpectedTopLocation processor = new ExpectedTopLocation();
        sampler.setProcessor(processor);
        System.out.println("---");
        for (int i = 0; i < 10000; ++i) {
            sampler.sample(rand);
            if (i % 100 != 0) continue;
            System.out.println(processor.average());
        }
        System.out.println("\n" + processor.average());
    }

    public static void stdSliceSampler() {
        Random rand = new Random(1L);
        double alpha0 = 10.0;
        ArrayList<Double> priorMeanOnMean = new ArrayList<Double>();
        priorMeanOnMean.add(0.0);
        priorMeanOnMean.add(0.0);
        ArrayList<Double> priorVarOnMean = new ArrayList<Double>();
        priorVarOnMean.add(100.0);
        priorVarOnMean.add(100.0);
        ArrayList<Double> deltaOnVar = new ArrayList<Double>();
        deltaOnVar.add(5.0);
        deltaOnVar.add(5.0);
        NormalMeanFixedVarLocationDist prior = new NormalMeanFixedVarLocationDist(priorMeanOnMean, priorVarOnMean, deltaOnVar);
        DataGenerator<NormalLocation, List<Double>> gen = new DataGenerator<NormalLocation, List<Double>>(prior, alpha0);
        DPMSample<NormalLocation, List<Double>> trueSample = gen.generateSample(100, rand);
        Sampler<NormalLocation, List<Double>> sampler = Sampler.createSliceSampler(trueSample.getData(), prior, alpha0);
        sampler.basicInit(3, rand);
        PrintSampleProcessor processor = new PrintSampleProcessor(10000000);
        sampler.setProcessor(processor);
        for (int i = 0; i < 100000000; ++i) {
            sampler.sample(rand);
        }
    }
}

