/*
 * Decompiled with CFR 0.152.
 */
package slice.ndp;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import nuts.util.CollUtils;
import nuts.util.EasyFormat;
import slice.ndp.DistributionToken;
import slice.stickrep.ImmutableSticks;
import slice.stickrep.LinkedSticks;
import slice.stickrep.Location;
import slice.stickrep.Sticks;

public class NDPLocation<L extends Location<D>, D>
implements Location<DistributionToken<D>> {
    private final List<L> subLocations;
    private final Sticks w;
    public static int numberOfPointPerCluster = 20;
    public static boolean eraseIndicatorInfo = true;
    public static int numberPerClusterInit = 2;

    public List<L> getSubLocations() {
        return this.subLocations;
    }

    public Sticks getW() {
        return this.w;
    }

    public NDPLocation(List<L> subLocations, Sticks w) {
        assert (subLocations.size() == w.nSticks());
        this.subLocations = CollUtils.archive(subLocations);
        this.w = new ImmutableSticks(w);
    }

    public static <L extends Location<D>, D> NDPLocation<L, D> createNDPLocationFromVs(List<L> subLocations, List<Double> vs) {
        LinkedSticks sticks = new LinkedSticks();
        for (double v : vs) {
            sticks.add(v);
        }
        return new NDPLocation<L, D>(subLocations, sticks);
    }

    public int truncation() {
        return this.w.nSticks();
    }

    @Override
    public double unnormLoglikelihood(DistributionToken<D> x) {
        double prod = 1.0;
        for (int i = 0; i < x.size(); ++i) {
            double sum = 0.0;
            for (int l = 0; l < this.truncation(); ++l) {
                double likelihood = Math.exp(((Location)this.subLocations.get(l)).unnormLoglikelihood(x.getPoint(i)));
                sum += this.w.retreiveW(l) * likelihood;
            }
            prod *= sum;
        }
        return Math.log(prod);
    }

    @Override
    public DistributionToken<D> sample(Random rand) {
        ArrayList points = new ArrayList();
        ArrayList<Integer> indicators = new ArrayList<Integer>();
        for (int i = 0; i < numberOfPointPerCluster; ++i) {
            double curRand = rand.nextDouble() * (1.0 - this.w.remainingStickLength());
            int subClusterIndex = this.w.retreiveIndex(curRand);
            if (eraseIndicatorInfo) {
                indicators.add(i / numberPerClusterInit);
            } else {
                indicators.add(subClusterIndex);
            }
            points.add(((Location)this.subLocations.get(subClusterIndex)).sample(rand));
        }
        return new DistributionToken(points, indicators, this.truncation());
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (int l = 0; l < this.w.nSticks(); ++l) {
            builder.append(EasyFormat.fmt(this.w.retreiveW(l)) + " " + ((Location)this.getSubLocations().get(l)).toString() + " ");
            if (l == this.w.nSticks() - 1) continue;
            builder.append("+ ");
        }
        return builder.toString();
    }
}

