/*
 * Decompiled with CFR 0.152.
 */
package smc;

import fig.basic.LogInfo;
import java.io.IOException;
import java.util.Random;
import nuts.math.Sampling;
import nuts.util.Counter;
import smc.WeightCommunication;

public class EntangledRandom {
    private int[] masterSeeds = new int[2];
    private Random machineSampler;
    private Random resampler;
    private Random r1;
    private Random r2;
    private int s0;
    private int[] s;
    private int[] t;

    public EntangledRandom(int id, int N, int T, Random rand1, Random rand2) {
        if (id == 0) {
            WeightCommunication.createCommFolder();
            this.masterSeeds[0] = rand1.nextInt();
            this.masterSeeds[1] = rand2.nextInt();
            try {
                WeightCommunication.writeSeeds(this.masterSeeds);
            }
            catch (IOException ex) {
                LogInfo.logs("Unrecoverable error: Failed to share the seeds");
                LogInfo.logs(ex.getMessage());
                System.exit(-1);
            }
        } else {
            LogInfo.logs("machine=" + id + " trying to read seeds");
            WeightCommunication.readSeeds(this.masterSeeds);
            LogInfo.logs("machine=" + id + " done reading seeds");
        }
        LogInfo.logs("seed1=" + this.masterSeeds[0] + " seed2=" + this.masterSeeds[1]);
        this.r1 = new Random(this.masterSeeds[0]);
        this.r2 = new Random(this.masterSeeds[1]);
        int numSeedsNeeded = (int)Math.ceil(Math.log10(T * N + 1) / Math.log10(2.0)) + 1;
        this.s = new int[numSeedsNeeded];
        this.t = new int[numSeedsNeeded];
        this.s0 = this.r1.nextInt();
        for (int n = 0; n < numSeedsNeeded; ++n) {
            this.s[n] = this.r1.nextInt();
            this.t[n] = this.r2.nextInt();
        }
        int machineSamplingMasterSeed = this.r1.nextInt();
        int resampleMasterSeed = this.r2.nextInt();
        this.machineSampler = new Random(machineSamplingMasterSeed);
        this.resampler = new Random(resampleMasterSeed);
    }

    public int[] resample(double[] weights, double norm) {
        int[] resampled = new int[weights.length];
        double dart = 0.0;
        double sum = 0.0;
        block0: for (int n = 0; n < weights.length; ++n) {
            dart = this.resampler.nextDouble() * norm;
            sum = 0.0;
            for (int i = 0; i < weights.length; ++i) {
                if (!(dart < (sum += weights[i]))) continue;
                int n2 = i;
                resampled[n2] = resampled[n2] + 1;
                continue block0;
            }
        }
        return resampled;
    }

    public Counter<Integer> efficientResample(double[] weights) {
        return Sampling.efficientMultinomialSampling(this.resampler, weights, weights.length);
    }

    public int sampleMachine(int numMachines) {
        int machine = this.machineSampler.nextInt(numMachines);
        return machine;
    }

    public int getSamplingSeed(long particleId) {
        if (particleId == 1L) {
            return this.s0;
        }
        int currSeed = this.s0;
        long value = particleId;
        int length = 0;
        while (value > 0L) {
            value >>= 1;
            ++length;
        }
        long temp = 0L;
        for (int n = 0; n < length; ++n) {
            temp = particleId & (long)(1 << n);
            if ((temp >>= n) == 0L) {
                currSeed ^= this.s[n];
                continue;
            }
            if (temp == 1L) {
                currSeed ^= this.t[n];
                continue;
            }
            LogInfo.logs("Unrecoverable error: bug in the bit operation part");
            System.exit(-1);
        }
        return currSeed;
    }
}

