/*
 * Decompiled with CFR 0.152.
 */
package times;

import file.FileUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import nuts.util.Arbre;

public class RateState {
    private Arbre<String> ar;
    private HashMap<Set<String>, String> cladesMap;
    private HashMap<String, Arbre<String>> arbreMap;
    private HashMap<String, PriorType> ratesFlagMap;
    private HashMap<String, Double> ratesSDMap;
    private HashMap<String, Double> ratesMeanMap;
    private HashMap<String, Double> ratesMap;
    private double mean;
    private double variance;

    public RateState(Arbre<String> ar, HashMap<Set<String>, String> cladesMap, HashMap<String, Arbre<String>> arbreMap, String ratesFile) {
        this.ar = ar;
        this.cladesMap = cladesMap;
        this.arbreMap = arbreMap;
        this.mean = 0.0;
        this.variance = 1.0;
        this.readRates(ratesFile);
    }

    public void setMean(double mean) {
        this.mean = mean;
    }

    public void setVariance(double variance) {
        this.variance = variance;
    }

    public void setRates(HashMap<String, Double> ratesMap) {
        this.ratesMap = ratesMap;
    }

    public double getRate(String s) {
        return this.ratesMap.get(s);
    }

    public double logInformativePrior(double t, String s) {
        if (this.ratesFlagMap.get(s) == PriorType.DELTA) {
            double u = this.ratesMeanMap.get(s);
            return Math.abs(t - u) <= Double.MIN_VALUE ? 0.0 : Double.NEGATIVE_INFINITY;
        }
        if (this.ratesFlagMap.get(s) == PriorType.FLAT) {
            return -0.5 * Math.pow(Math.log(t) - this.mean, 2.0) / this.variance - Math.log(Math.PI * 2 * this.variance);
        }
        double u = this.ratesMeanMap.get(s);
        double v = this.ratesSDMap.get(s);
        v *= v;
        return -0.5 * Math.pow(Math.log(t) - u, 2.0) / v - Math.log(Math.PI * 2 * v);
    }

    public double getLogDensity() {
        List<Arbre<String>> nodes = this.ar.nodes();
        double logd = 0.0;
        for (Arbre<String> s : nodes) {
            String t = s.getContents();
            double r = this.ratesMap.get(t);
            if (s.isRoot()) continue;
            double x = this.logInformativePrior(r, t);
            if (Double.isInfinite(x)) {
                return Double.NEGATIVE_INFINITY;
            }
            logd += x;
        }
        return logd;
    }

    public void readRates(String ratesFile) {
        this.ratesFlagMap = new HashMap();
        this.ratesMeanMap = new HashMap();
        this.ratesSDMap = new HashMap();
        this.ratesMap = new HashMap();
        try {
            HashMap<String, String> tmpMap = FileUtils.readMap(ratesFile);
            for (String s : tmpMap.keySet()) {
                StringTokenizer tok = new StringTokenizer(s, ",");
                HashSet<String> keys = new HashSet<String>();
                while (tok.hasMoreTokens()) {
                    keys.add(tok.nextToken());
                }
                String internalLabel = this.cladesMap.get(keys);
                tok = new StringTokenizer(tmpMap.get(s), ",");
                if (tok.countTokens() == 1) {
                    this.ratesFlagMap.put(internalLabel, PriorType.DELTA);
                    double val = Double.parseDouble(tok.nextToken());
                    this.ratesMeanMap.put(internalLabel, val);
                    this.ratesSDMap.put(internalLabel, 0.0);
                    continue;
                }
                if (tok.countTokens() != 2) continue;
                this.ratesFlagMap.put(internalLabel, PriorType.MOMENT);
                double val1 = Double.parseDouble(tok.nextToken());
                double val2 = Double.parseDouble(tok.nextToken());
                this.ratesMeanMap.put(internalLabel, val2);
                this.ratesSDMap.put(internalLabel, val1);
            }
        }
        catch (Exception e) {
            System.err.println("Could not read from file " + ratesFile);
        }
    }

    public static enum PriorType {
        FLAT,
        DELTA,
        MOMENT;

    }
}

