/*
 * Decompiled with CFR 0.152.
 */
package web;

import fig.basic.IOUtils;
import fig.basic.Option;
import fig.basic.StrUtils;
import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import nuts.io.IO;
import nuts.util.CollUtils;

public class ConvertPubs
implements Runnable {
    @Option
    public String csvPath = "/Users/bouchard/Documents/web/ref.csv";
    @Option
    public String htmlFilePath = "/Users/bouchard/Documents/web/public_html/index.html";
    private File bibFiles = new File("/Users/bouchard/Documents/web/public_html/bib/");
    private String relBibFolder = "bib/";
    @Option
    public String tagIdentifier = "GENERATED:ref";
    private Map<String, String> conversions = this.loadConversions();

    public static void main(String[] args) {
        IO.runLight(args, new ConvertPubs());
    }

    @Override
    public void run() {
        String tag = "<!-- " + this.tagIdentifier + " -->";
        String str = IO.f2s(this.htmlFilePath);
        IO.writeToDisk(this.htmlFilePath + ".backup", str);
        ArrayList entries = CollUtils.list();
        for (Map<String, String> entry : IO.iCSVMap(this.csvPath)) {
            for (String x : entry.values()) {
                if (!x.contains("\n")) continue;
                throw new RuntimeException("MAKE SURE THERE ARE NOT NEW LINES IN THE INDIVIDUAL CSV ENTRIES");
            }
            StringBuilder current = new StringBuilder();
            String vol = entry.get("bib-volume");
            String page = entry.get("bib-pages");
            String cols = vol != null && page != null ? ":" : "";
            String bibInfo = (vol == null ? "" : vol) + cols + (page == null ? "" : page);
            String bibEd = entry.get("bib-editor");
            bibEd = bibEd == null ? "" : bibEd + " ";
            current.append("<li>" + entry.get("authors") + ". (" + entry.get("year") + ")\n");
            current.append(entry.get("title") + ". \n");
            current.append("<em>" + entry.get("booktitle") + ".</em> " + bibEd + bibInfo + "<br />\n");
            this.link(current, entry, "paper");
            this.link(current, entry, "slide");
            this.link(current, entry, "poster");
            this.link(current, entry, "supp");
            this.link(current, entry, "errata");
            this.link(current, entry, "code");
            this.link(current, entry, "data");
            this.createBibEntry(current, entry);
            this.comments(current, entry);
            current.append("</li>\n\n");
            entries.add(current.toString());
        }
        boolean first = true;
        StringBuilder transformed = new StringBuilder();
        for (String line : str.split("\n")) {
            if (line.contains(tag)) {
                if (first) {
                    for (int i = entries.size() - 1; i >= 0; --i) {
                        for (String subline : ((String)entries.get(i)).split("\n")) {
                            transformed.append("" + tag + " " + subline + "\n");
                        }
                    }
                }
                first = false;
                continue;
            }
            transformed.append(line + "\n");
        }
        IO.writeToDisk(this.htmlFilePath, transformed.toString());
    }

    private void createBibEntry(StringBuilder current, Map<String, String> entry) {
        String[] authors = entry.get("authors").split("(\\s*[, ]\\s*and\\s+|\\s*[,]\\s*)");
        String firstLastName = authors[0].split("\\s+")[1].replaceAll("[-].*", "").replaceAll("\\s+", "");
        String key = firstLastName + entry.get("year");
        for (String word : entry.get("title").split("\\s+")) {
            if (word.length() <= 4) continue;
            key = key + word;
            break;
        }
        String pubType = entry.get("pub-type");
        PrintWriter out = IOUtils.openOutHard(new File(this.bibFiles, key + ".bib"));
        out.println("@" + pubType + "{" + key + ",");
        out.println("   author = {" + this.bibAuthors(authors) + "},");
        out.println("   title = {" + this.bibTitle(entry.get("title")) + "},");
        out.println("   " + (pubType.equals("InProceedings") ? "booktitle" : "journal") + " = {" + this.bibProc(entry.get("booktitle")) + "},");
        for (String otherBibKey : entry.keySet()) {
            if (!otherBibKey.matches("^bib[-].*")) continue;
            String bibKey = otherBibKey.replace("bib-", "");
            out.println("   " + bibKey + " = {" + entry.get(otherBibKey) + "},");
        }
        out.println("   year = {" + entry.get("year") + "}");
        out.println("}\n");
        out.close();
        current.append("<a href=\"" + this.relBibFolder + "/" + key + ".bib\">[bib]</a>");
    }

    private String bibProc(String string) {
        return string;
    }

    private String bibTitle(String string) {
        string = this.fixAccents(string);
        StringBuilder result = new StringBuilder();
        for (char c : string.toCharArray()) {
            if (Character.isUpperCase(c)) {
                result.append("{" + c + "}");
                continue;
            }
            result.append(c);
        }
        return result.toString();
    }

    private String bibAuthors(String[] authors) {
        return this.fixAccents(StrUtils.join(authors, " and "));
    }

    private String fixAccents(String join) {
        for (String key : this.conversions.keySet()) {
            join = join.replace(key, this.conversions.get(key));
        }
        return join;
    }

    private Map<String, String> loadConversions() {
        HashMap<String, String> conversions = CollUtils.map();
        for (String line : IO.i("/Users/bouchard/code/legacy-code/src-scratch/web/substitutions.txt")) {
            if (line.matches("^\\s*$")) continue;
            String[] fields = line.split("\\s+");
            conversions.put(fields[0], fields[1]);
        }
        return conversions;
    }

    private void comments(StringBuilder current, Map<String, String> entry) {
        String value = entry.get("comments");
        if (value == null || value.matches("^\\s*$")) {
            return;
        }
        current.append(" <em>" + value + "</em>");
    }

    private void link(StringBuilder current, Map<String, String> entry, String string) {
        String value = entry.get(string + "-link");
        if (string.equals("supp")) {
            string = "supplementary material";
        }
        if (string.equals("paper") && entry.containsKey("bib-editor")) {
            string = "link";
        }
        if (string.equals("slide")) {
            string = string + "s";
        }
        if (value == null || value.matches("^\\s*$")) {
            return;
        }
        current.append("<a href=\"" + value + "\">[" + string + "]</a>");
    }
}

