/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.matrices;

import JSci.GlobalSettings;
import JSci.maths.DimensionException;
import JSci.maths.Mapping;
import JSci.maths.matrices.AbstractComplexMatrix;
import JSci.maths.matrices.AbstractDoubleMatrix;
import JSci.maths.matrices.AbstractIntegerMatrix;
import JSci.maths.matrices.ComplexMatrix;
import JSci.maths.matrices.DoubleMatrix;
import JSci.maths.matrices.DoubleSparseSquareMatrix;
import JSci.maths.matrices.DoubleSquareMatrix;
import JSci.maths.matrices.IntegerMatrix;
import JSci.maths.matrices.Matrix;
import JSci.maths.matrices.MatrixDimensionException;
import JSci.maths.vectors.AbstractDoubleVector;
import JSci.maths.vectors.DoubleSparseVector;
import JSci.maths.vectors.DoubleVector;

public final class DoubleSparseMatrix
extends AbstractDoubleMatrix {
    private double[] elements;
    private int[] colPos;
    private int[] rows;
    private int capacityIncrement = 1;

    public DoubleSparseMatrix(int n, int n2) {
        super(n, n2);
        this.elements = new double[0];
        this.colPos = new int[0];
        this.rows = new int[this.numRows + 1];
    }

    public DoubleSparseMatrix(int n, int n2, int n3) {
        this(n, n2);
        this.capacityIncrement = n3;
    }

    public DoubleSparseMatrix(double[][] dArray) {
        super(dArray.length, dArray[0].length);
        int n;
        int n2;
        this.rows = new int[this.numRows + 1];
        int n3 = 0;
        for (n2 = 0; n2 < this.numRows; ++n2) {
            if (dArray[n2].length != dArray.length) {
                throw new MatrixDimensionException("Array is not square.");
            }
            for (n = 0; n < this.numCols; ++n) {
                if (!(Math.abs(dArray[n2][n]) > GlobalSettings.ZERO_TOL)) continue;
                ++n3;
            }
        }
        this.elements = new double[n3];
        this.colPos = new int[n3];
        n3 = 0;
        for (n2 = 0; n2 < this.numRows; ++n2) {
            this.rows[n2] = n3;
            for (n = 0; n < this.numCols; ++n) {
                if (!(Math.abs(dArray[n2][n]) > GlobalSettings.ZERO_TOL)) continue;
                this.elements[n3] = dArray[n2][n];
                this.colPos[n3] = n;
                ++n3;
            }
        }
        this.rows[this.numRows] = n3;
    }

    public boolean equals(AbstractDoubleMatrix abstractDoubleMatrix, double d) {
        if (this.numRows == abstractDoubleMatrix.numRows && this.numCols == abstractDoubleMatrix.numCols) {
            if (abstractDoubleMatrix instanceof DoubleSparseMatrix) {
                return this.equals((DoubleSparseMatrix)abstractDoubleMatrix);
            }
            double d2 = 0.0;
            for (int i = 0; i < this.numRows; ++i) {
                for (int j = 0; j < this.numCols; ++j) {
                    double d3 = this.getElement(i, j) - abstractDoubleMatrix.getElement(i, j);
                    d2 += d3 * d3;
                }
            }
            return d2 <= d * d;
        }
        return false;
    }

    public final boolean equals(DoubleSparseMatrix doubleSparseMatrix) {
        return this.equals(doubleSparseMatrix, GlobalSettings.ZERO_TOL);
    }

    public boolean equals(DoubleSparseMatrix doubleSparseMatrix, double d) {
        if (this.numRows == doubleSparseMatrix.numRows && this.numCols == doubleSparseMatrix.numCols) {
            for (int i = 1; i < this.rows.length; ++i) {
                if (this.rows[i] == doubleSparseMatrix.rows[i]) continue;
                return false;
            }
            double d2 = 0.0;
            for (int i = 0; i < this.rows[this.numRows]; ++i) {
                if (this.colPos[i] != doubleSparseMatrix.colPos[i]) {
                    return false;
                }
                double d3 = this.elements[i] - doubleSparseMatrix.elements[i];
                d2 += d3 * d3;
            }
            return d2 <= d * d;
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.numRows * this.numCols);
        for (int i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < this.numCols; ++j) {
                stringBuffer.append(this.getElement(i, j));
                stringBuffer.append(' ');
            }
            stringBuffer.append('\n');
        }
        return stringBuffer.toString();
    }

    public AbstractIntegerMatrix toIntegerMatrix() {
        int[][] nArray = new int[this.numRows][this.numCols];
        for (int i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < this.numCols; ++j) {
                nArray[i][j] = Math.round((float)this.getElement(i, j));
            }
        }
        return new IntegerMatrix(nArray);
    }

    public AbstractComplexMatrix toComplexMatrix() {
        double[][] dArray = new double[this.numRows][this.numCols];
        for (int i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < this.numCols; ++j) {
                dArray[i][j] = this.getElement(i, j);
            }
        }
        return new ComplexMatrix(dArray, new double[this.numRows][this.numCols]);
    }

    public double getElement(int n, int n2) {
        if (n >= 0 && n < this.numRows && n2 >= 0 && n2 < this.numCols) {
            int n3;
            for (n3 = this.rows[n]; n3 < this.rows[n + 1] && this.colPos[n3] < n2; ++n3) {
            }
            if (n3 < this.rows[n + 1] && this.colPos[n3] == n2) {
                return this.elements[n3];
            }
            return 0.0;
        }
        throw new MatrixDimensionException(Matrix.getInvalidElementMsg(n, n2));
    }

    public void setElement(int n, int n2, double d) {
        if (n >= 0 && n < this.numRows && n2 >= 0 && n2 < this.numCols) {
            int n3;
            for (n3 = this.rows[n]; n3 < this.rows[n + 1] && this.colPos[n3] < n2; ++n3) {
            }
            if (n3 < this.rows[n + 1] && this.colPos[n3] == n2) {
                if (Math.abs(d) <= GlobalSettings.ZERO_TOL) {
                    System.arraycopy(this.elements, n3 + 1, this.elements, n3, this.rows[this.numRows] - n3 - 1);
                    System.arraycopy(this.colPos, n3 + 1, this.colPos, n3, this.rows[this.numRows] - n3 - 1);
                    int n4 = n + 1;
                    while (n4 < this.rows.length) {
                        int n5 = n4++;
                        this.rows[n5] = this.rows[n5] - 1;
                    }
                } else {
                    this.elements[n3] = d;
                }
            } else if (Math.abs(d) > GlobalSettings.ZERO_TOL) {
                if (this.rows[this.numRows] == this.elements.length) {
                    double[] dArray = this.elements;
                    int[] nArray = this.colPos;
                    this.elements = new double[dArray.length + this.capacityIncrement];
                    this.colPos = new int[nArray.length + this.capacityIncrement];
                    System.arraycopy(dArray, 0, this.elements, 0, n3);
                    System.arraycopy(nArray, 0, this.colPos, 0, n3);
                    System.arraycopy(dArray, n3, this.elements, n3 + 1, dArray.length - n3);
                    System.arraycopy(nArray, n3, this.colPos, n3 + 1, nArray.length - n3);
                } else {
                    System.arraycopy(this.elements, n3, this.elements, n3 + 1, this.rows[this.numRows] - n3);
                    System.arraycopy(this.colPos, n3, this.colPos, n3 + 1, this.rows[this.numRows] - n3);
                }
                this.elements[n3] = d;
                this.colPos[n3] = n2;
                int n6 = n + 1;
                while (n6 < this.rows.length) {
                    int n7 = n6++;
                    this.rows[n7] = this.rows[n7] + 1;
                }
            }
        } else {
            throw new MatrixDimensionException(Matrix.getInvalidElementMsg(n, n2));
        }
    }

    public int elementCount() {
        return this.rows[this.numRows];
    }

    public double infNorm() {
        double d = 0.0;
        for (int i = 0; i < this.numRows; ++i) {
            double d2 = 0.0;
            for (int j = this.rows[i]; j < this.rows[i + 1]; ++j) {
                d2 += Math.abs(this.elements[j]);
            }
            if (!(d2 > d)) continue;
            d = d2;
        }
        return d;
    }

    public double frobeniusNorm() {
        double d = 0.0;
        for (int i = 0; i < this.rows[this.numRows]; ++i) {
            d += this.elements[i] * this.elements[i];
        }
        return Math.sqrt(d);
    }

    public AbstractDoubleMatrix add(AbstractDoubleMatrix abstractDoubleMatrix) {
        if (abstractDoubleMatrix instanceof DoubleSparseMatrix) {
            return this.add((DoubleSparseMatrix)abstractDoubleMatrix);
        }
        if (abstractDoubleMatrix instanceof DoubleMatrix) {
            return this.add((DoubleMatrix)abstractDoubleMatrix);
        }
        if (this.numRows == abstractDoubleMatrix.rows() && this.numCols == abstractDoubleMatrix.columns()) {
            double[][] dArray = new double[this.numRows][this.numCols];
            for (int i = 0; i < this.numRows; ++i) {
                int n;
                for (n = this.rows[i]; n < this.rows[i + 1]; ++n) {
                    dArray[i][this.colPos[n]] = this.elements[n];
                }
                double[] dArray2 = dArray[i];
                dArray2[0] = dArray2[0] + abstractDoubleMatrix.getElement(i, 0);
                for (n = 1; n < this.numCols; ++n) {
                    double[] dArray3 = dArray[i];
                    int n2 = n;
                    dArray3[n2] = dArray3[n2] + abstractDoubleMatrix.getElement(i, n);
                }
            }
            return new DoubleMatrix(dArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public DoubleMatrix add(DoubleMatrix doubleMatrix) {
        if (this.numRows == doubleMatrix.numRows && this.numCols == doubleMatrix.numCols) {
            double[][] dArray = new double[this.numRows][this.numCols];
            for (int i = 0; i < this.numRows; ++i) {
                int n;
                for (n = this.rows[i]; n < this.rows[i + 1]; ++n) {
                    dArray[i][this.colPos[n]] = this.elements[n];
                }
                double[] dArray2 = dArray[i];
                dArray2[0] = dArray2[0] + doubleMatrix.matrix[i][0];
                for (n = 1; n < this.numCols; ++n) {
                    double[] dArray3 = dArray[i];
                    int n2 = n;
                    dArray3[n2] = dArray3[n2] + doubleMatrix.matrix[i][n];
                }
            }
            return new DoubleMatrix(dArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public DoubleSparseMatrix add(DoubleSparseMatrix doubleSparseMatrix) {
        if (this.numRows == doubleSparseMatrix.numRows && this.numCols == doubleSparseMatrix.numCols) {
            DoubleSparseMatrix doubleSparseMatrix2 = new DoubleSparseMatrix(this.numRows, this.numCols);
            for (int i = 0; i < this.numRows; ++i) {
                for (int j = 0; j < this.numCols; ++j) {
                    doubleSparseMatrix2.setElement(i, j, this.getElement(i, j) + doubleSparseMatrix.getElement(i, j));
                }
            }
            return doubleSparseMatrix2;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public AbstractDoubleMatrix subtract(AbstractDoubleMatrix abstractDoubleMatrix) {
        if (abstractDoubleMatrix instanceof DoubleSparseMatrix) {
            return this.subtract((DoubleSparseMatrix)abstractDoubleMatrix);
        }
        if (abstractDoubleMatrix instanceof DoubleMatrix) {
            return this.subtract((DoubleMatrix)abstractDoubleMatrix);
        }
        if (this.numRows == abstractDoubleMatrix.rows() && this.numCols == abstractDoubleMatrix.columns()) {
            double[][] dArray = new double[this.numRows][this.numCols];
            for (int i = 0; i < this.numRows; ++i) {
                int n;
                for (n = this.rows[i]; n < this.rows[i + 1]; ++n) {
                    dArray[i][this.colPos[n]] = this.elements[n];
                }
                double[] dArray2 = dArray[i];
                dArray2[0] = dArray2[0] - abstractDoubleMatrix.getElement(i, 0);
                for (n = 1; n < this.numCols; ++n) {
                    double[] dArray3 = dArray[i];
                    int n2 = n;
                    dArray3[n2] = dArray3[n2] - abstractDoubleMatrix.getElement(i, n);
                }
            }
            return new DoubleMatrix(dArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public DoubleMatrix subtract(DoubleMatrix doubleMatrix) {
        if (this.numRows == doubleMatrix.numRows && this.numCols == doubleMatrix.numCols) {
            double[][] dArray = new double[this.numRows][this.numCols];
            for (int i = 0; i < this.numRows; ++i) {
                int n;
                for (n = this.rows[i]; n < this.rows[i + 1]; ++n) {
                    dArray[i][this.colPos[n]] = this.elements[n];
                }
                double[] dArray2 = dArray[i];
                dArray2[0] = dArray2[0] - doubleMatrix.matrix[i][0];
                for (n = 1; n < this.numCols; ++n) {
                    double[] dArray3 = dArray[i];
                    int n2 = n;
                    dArray3[n2] = dArray3[n2] - doubleMatrix.matrix[i][n];
                }
            }
            return new DoubleMatrix(dArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public DoubleSparseMatrix subtract(DoubleSparseMatrix doubleSparseMatrix) {
        if (this.numRows == doubleSparseMatrix.numRows && this.numCols == doubleSparseMatrix.numCols) {
            DoubleSparseMatrix doubleSparseMatrix2 = new DoubleSparseMatrix(this.numRows, this.numCols);
            for (int i = 0; i < this.numRows; ++i) {
                for (int j = 0; j < this.numCols; ++j) {
                    doubleSparseMatrix2.setElement(i, j, this.getElement(i, j) - doubleSparseMatrix.getElement(i, j));
                }
            }
            return doubleSparseMatrix2;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public AbstractDoubleMatrix scalarMultiply(double d) {
        DoubleSparseMatrix doubleSparseMatrix = new DoubleSparseMatrix(this.numRows, this.numCols);
        doubleSparseMatrix.elements = new double[this.elements.length];
        doubleSparseMatrix.colPos = new int[this.colPos.length];
        System.arraycopy(this.colPos, 0, doubleSparseMatrix.colPos, 0, this.colPos.length);
        System.arraycopy(this.rows, 0, doubleSparseMatrix.rows, 0, this.rows.length);
        for (int i = 0; i < this.rows[this.numRows]; ++i) {
            doubleSparseMatrix.elements[i] = d * this.elements[i];
        }
        return doubleSparseMatrix;
    }

    public AbstractDoubleMatrix scalarDivide(double d) {
        DoubleSparseMatrix doubleSparseMatrix = new DoubleSparseMatrix(this.numRows, this.numCols);
        doubleSparseMatrix.elements = new double[this.elements.length];
        doubleSparseMatrix.colPos = new int[this.colPos.length];
        System.arraycopy(this.colPos, 0, doubleSparseMatrix.colPos, 0, this.colPos.length);
        System.arraycopy(this.rows, 0, doubleSparseMatrix.rows, 0, this.rows.length);
        for (int i = 0; i < this.rows[this.numRows]; ++i) {
            doubleSparseMatrix.elements[i] = this.elements[i] / d;
        }
        return doubleSparseMatrix;
    }

    public double scalarProduct(AbstractDoubleMatrix abstractDoubleMatrix) {
        if (abstractDoubleMatrix instanceof DoubleMatrix) {
            return this.scalarProduct((DoubleMatrix)abstractDoubleMatrix);
        }
        if (this.numRows == abstractDoubleMatrix.numRows && this.numCols == abstractDoubleMatrix.numCols) {
            double d = 0.0;
            for (int i = 0; i < this.numRows; ++i) {
                for (int j = this.rows[i]; j < this.rows[i + 1]; ++j) {
                    d += this.elements[j] * abstractDoubleMatrix.getElement(i, this.colPos[j]);
                }
            }
            return d;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public double scalarProduct(DoubleMatrix doubleMatrix) {
        if (this.numRows == doubleMatrix.numRows && this.numCols == doubleMatrix.numCols) {
            double d = 0.0;
            for (int i = 0; i < this.numRows; ++i) {
                for (int j = this.rows[i]; j < this.rows[i + 1]; ++j) {
                    d += this.elements[j] * doubleMatrix.matrix[i][this.colPos[j]];
                }
            }
            return d;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public AbstractDoubleVector multiply(AbstractDoubleVector abstractDoubleVector) {
        if (abstractDoubleVector instanceof DoubleSparseVector) {
            return this.multiply((DoubleSparseVector)abstractDoubleVector);
        }
        if (this.numCols == abstractDoubleVector.dimension()) {
            double[] dArray = new double[this.numRows];
            for (int i = 0; i < this.numRows; ++i) {
                for (int j = this.rows[i]; j < this.rows[i + 1]; ++j) {
                    int n = i;
                    dArray[n] = dArray[n] + this.elements[j] * abstractDoubleVector.getComponent(this.colPos[j]);
                }
            }
            return new DoubleVector(dArray);
        }
        throw new DimensionException("Matrix and vector are incompatible.");
    }

    public AbstractDoubleVector multiply(DoubleSparseVector doubleSparseVector) {
        if (this.numCols == doubleSparseVector.dimension()) {
            DoubleSparseVector doubleSparseVector2 = new DoubleSparseVector(this.numRows);
            for (int i = 0; i < this.numRows; ++i) {
                double d = 0.0;
                for (int j = this.rows[i]; j < this.rows[i + 1]; ++j) {
                    d += this.elements[j] * doubleSparseVector.getComponent(this.colPos[j]);
                }
                doubleSparseVector2.setComponent(i, d);
            }
            return doubleSparseVector2;
        }
        throw new DimensionException("Matrix and vector are incompatible.");
    }

    public AbstractDoubleMatrix multiply(AbstractDoubleMatrix abstractDoubleMatrix) {
        if (abstractDoubleMatrix instanceof DoubleSparseMatrix) {
            return this.multiply((DoubleSparseMatrix)abstractDoubleMatrix);
        }
        if (abstractDoubleMatrix instanceof DoubleMatrix) {
            return this.multiply((DoubleMatrix)abstractDoubleMatrix);
        }
        if (this.numCols == abstractDoubleMatrix.numRows) {
            double[][] dArray = new double[this.numRows][abstractDoubleMatrix.numCols];
            for (int i = 0; i < this.numRows; ++i) {
                for (int j = 0; j < abstractDoubleMatrix.numCols; ++j) {
                    for (int k = this.rows[i]; k < this.rows[i + 1]; ++k) {
                        double[] dArray2 = dArray[i];
                        int n = j;
                        dArray2[n] = dArray2[n] + this.elements[k] * abstractDoubleMatrix.getElement(this.colPos[k], j);
                    }
                }
            }
            if (this.numRows == abstractDoubleMatrix.numCols) {
                return new DoubleSquareMatrix(dArray);
            }
            return new DoubleMatrix(dArray);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    public AbstractDoubleMatrix multiply(DoubleMatrix doubleMatrix) {
        if (this.numCols == doubleMatrix.numRows) {
            double[][] dArray = new double[this.numRows][doubleMatrix.numCols];
            for (int i = 0; i < this.numRows; ++i) {
                for (int j = 0; j < doubleMatrix.numCols; ++j) {
                    for (int k = this.rows[i]; k < this.rows[i + 1]; ++k) {
                        double[] dArray2 = dArray[i];
                        int n = j;
                        dArray2[n] = dArray2[n] + this.elements[k] * doubleMatrix.matrix[this.colPos[k]][j];
                    }
                }
            }
            if (this.numRows == doubleMatrix.numCols) {
                return new DoubleSquareMatrix(dArray);
            }
            return new DoubleMatrix(dArray);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    public AbstractDoubleMatrix multiply(DoubleSparseMatrix doubleSparseMatrix) {
        if (this.numCols == doubleSparseMatrix.numRows) {
            AbstractDoubleMatrix abstractDoubleMatrix = this.numRows == doubleSparseMatrix.numCols ? new DoubleSparseSquareMatrix(this.numRows) : new DoubleSparseMatrix(this.numRows, doubleSparseMatrix.numCols);
            for (int i = 0; i < abstractDoubleMatrix.numRows; ++i) {
                for (int j = 0; j < abstractDoubleMatrix.numCols; ++j) {
                    double d = 0.0;
                    for (int k = this.rows[i]; k < this.rows[i + 1]; ++k) {
                        d += this.elements[k] * doubleSparseMatrix.getElement(this.colPos[k], j);
                    }
                    abstractDoubleMatrix.setElement(i, j, d);
                }
            }
            return abstractDoubleMatrix;
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    public Matrix transpose() {
        DoubleSparseMatrix doubleSparseMatrix = new DoubleSparseMatrix(this.numCols, this.numRows);
        for (int i = 0; i < this.numRows; ++i) {
            doubleSparseMatrix.setElement(0, i, this.getElement(i, 0));
            for (int j = 1; j < this.numCols; ++j) {
                doubleSparseMatrix.setElement(j, i, this.getElement(i, j));
            }
        }
        return doubleSparseMatrix;
    }

    public AbstractDoubleMatrix mapElements(Mapping mapping) {
        DoubleSparseMatrix doubleSparseMatrix = new DoubleSparseMatrix(this.numRows, this.numCols);
        doubleSparseMatrix.elements = new double[this.elements.length];
        doubleSparseMatrix.colPos = new int[this.colPos.length];
        System.arraycopy(this.colPos, 0, doubleSparseMatrix.colPos, 0, this.colPos.length);
        System.arraycopy(this.rows, 0, doubleSparseMatrix.rows, 0, this.rows.length);
        for (int i = 0; i < this.rows[this.numRows]; ++i) {
            doubleSparseMatrix.elements[i] = mapping.map(this.elements[i]);
        }
        return doubleSparseMatrix;
    }
}

