/*
 * Decompiled with CFR 0.152.
 */
package briefj;

import briefj.BriefIO;
import briefj.CSV;
import com.beust.jcommander.internal.Maps;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Map;
import org.apache.commons.math3.stat.descriptive.SummaryStatistics;

public class OutputManager {
    private Map<String, PrintWriter> _writers = Maps.newHashMap();
    private File _resultsFolder = null;
    private final int flushInterval = 5;
    private int current = 0;

    public void printWrite(String masterKey, Object ... keyValues) {
        this.write(masterKey, keyValues);
        StringBuilder toPrint = new StringBuilder();
        toPrint.append(masterKey + ": ");
        int len = keyValues.length / 2;
        for (int i = 0; i < len; ++i) {
            toPrint.append("" + keyValues[i * 2] + "=" + keyValues[i * 2 + 1] + (i == len - 1 ? "" : ", "));
        }
        System.out.println(toPrint);
    }

    public void printWrite(String masterKey, SummaryStatistics statistics) {
        this.printWrite(masterKey, "mean", statistics.getMean(), "var", statistics.getVariance(), "sd", statistics.getStandardDeviation(), "min", statistics.getMin(), "max", statistics.getMax(), "N", statistics.getN());
    }

    public void write(String masterKey, Object ... keyValues) {
        if (keyValues.length % 2 != 0) {
            System.err.println("Malformed OutputManager.print():" + Arrays.toString(keyValues));
            return;
        }
        boolean needPrintHeader = !this.hasWriter(masterKey);
        int len = keyValues.length / 2;
        Object[] heads = needPrintHeader ? new Object[len] : null;
        Object[] values = new Object[len];
        for (int i = 0; i < len; ++i) {
            Object key = keyValues[i * 2];
            Object value = keyValues[i * 2 + 1];
            if (needPrintHeader) {
                heads[i] = key;
            }
            values[i] = value;
        }
        if (needPrintHeader) {
            this.print(masterKey, heads);
        }
        this.print(masterKey, values);
    }

    public void close() {
        for (PrintWriter out : this._writers.values()) {
            out.close();
        }
    }

    public void flush() {
        for (PrintWriter out : this._writers.values()) {
            out.flush();
        }
    }

    private PrintWriter getWriter(String key) {
        PrintWriter result;
        if (++this.current % 5 == 0) {
            this.flush();
        }
        if ((result = this._writers.get(key)) != null) {
            return result;
        }
        result = BriefIO.output(this.getOutputFile(key));
        this._writers.put(key, result);
        return result;
    }

    public File getOutputFile(String key) {
        return new File(this.getResultsFolder(), key + ".csv");
    }

    private boolean hasWriter(String key) {
        return this._writers.containsKey(key);
    }

    private File getResultsFolder() {
        if (this._resultsFolder != null) {
            return this._resultsFolder;
        }
        this._resultsFolder = new File(".");
        this._resultsFolder.mkdir();
        return this._resultsFolder;
    }

    private void print(String key, Object ... objects) {
        this.getWriter(key).println(CSV.toCSV(objects));
    }

    public void setOutputFolder(File f) {
        try {
            Files.createParentDirs((File)f);
            f.mkdir();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this._resultsFolder = f;
    }

    public File getOutputFolder() {
        return this.getResultsFolder();
    }
}

