/*
 * Decompiled with CFR 0.152.
 */
package org.forester.application;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.SortedSet;
import java.util.TreeSet;
import org.forester.archaeopteryx.tools.SequenceDataRetriver;
import org.forester.io.parsers.util.ParserUtils;
import org.forester.io.writers.PhylogenyWriter;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.factories.ParserBasedPhylogenyFactory;
import org.forester.phylogeny.factories.PhylogenyFactory;
import org.forester.phylogeny.iterators.PhylogenyNodeIterator;
import org.forester.util.CommandLineArguments;
import org.forester.util.ForesterUtil;

public class gene_tree_preprocess {
    private static final String HELP_OPTION_1 = "help";
    private static final String HELP_OPTION_2 = "h";
    private static final String PRG_NAME = "gene_tree_preprocess";
    private static final String PRG_DESC = "gene tree preprocessing for SDI analysis";
    private static final String PRG_VERSION = "1.01";
    private static final String PRG_DATE = "2012.06.07";
    private static final String E_MAIL = "phylosoft@gmail.com";
    private static final String WWW = "www.phylosoft.org/forester";

    public static void main(String[] stringArray) {
        try {
            TreeSet<String> treeSet;
            CommandLineArguments commandLineArguments = new CommandLineArguments(stringArray);
            if (commandLineArguments.isOptionSet(HELP_OPTION_1) || commandLineArguments.isOptionSet(HELP_OPTION_2) || stringArray.length != 1) {
                gene_tree_preprocess.printHelp();
                System.exit(0);
            }
            File file = commandLineArguments.getFile(0);
            Phylogeny phylogeny = null;
            PhylogenyFactory phylogenyFactory = ParserBasedPhylogenyFactory.getInstance();
            try {
                phylogeny = phylogenyFactory.create(file, ParserUtils.createParserDependingOnFileType(file, true))[0];
            }
            catch (IOException iOException) {
                ForesterUtil.fatalError(PRG_NAME, "failed to read phylogeny from [" + file + "]: " + iOException.getLocalizedMessage());
            }
            File file2 = new File(ForesterUtil.removeSuffix(file.toString()) + "_preprocessed_gene_tree.phylo.xml");
            File file3 = new File(ForesterUtil.removeSuffix(file.toString()) + "_removed_nodes.txt");
            File file4 = new File(ForesterUtil.removeSuffix(file.toString()) + "_species_present.txt");
            gene_tree_preprocess.checkForOutputFileWriteability(file2);
            gene_tree_preprocess.checkForOutputFileWriteability(file3);
            gene_tree_preprocess.checkForOutputFileWriteability(file4);
            if (phylogeny.getNumberOfExternalNodes() < 2) {
                ForesterUtil.fatalError(PRG_NAME, "phylogeny has " + phylogeny.getNumberOfExternalNodes() + " external node(s), aborting");
            }
            SortedSet<String> sortedSet = SequenceDataRetriver.obtainSeqInformation(phylogeny, true, false);
            for (String object2 : sortedSet) {
                phylogeny.deleteSubtree(phylogeny.getNode(object2), true);
            }
            phylogeny.clearHashIdToNodeMap();
            phylogeny.externalNodesHaveChanged();
            if (phylogeny.getNumberOfExternalNodes() < 2) {
                ForesterUtil.fatalError(PRG_NAME, "after removal of unresolvable external nodes, phylogeny has " + phylogeny.getNumberOfExternalNodes() + " external node(s), aborting");
            }
            try {
                treeSet = new PhylogenyWriter();
                ((PhylogenyWriter)((Object)treeSet)).toPhyloXML(phylogeny, 0, file2);
            }
            catch (IOException iOException) {
                ForesterUtil.fatalError(PRG_NAME, "failed to write to [" + file2 + "]: " + iOException.getLocalizedMessage());
            }
            ForesterUtil.programMessage(PRG_NAME, "wrote output phylogeny to: " + file2);
            treeSet = new TreeSet<String>();
            PhylogenyNodeIterator iOException = phylogeny.iteratorExternalForward();
            while (iOException.hasNext()) {
                String string;
                PhylogenyNode phylogenyNode = iOException.next();
                if (!phylogenyNode.getNodeData().isHasTaxonomy() || ForesterUtil.isEmpty(string = phylogenyNode.getNodeData().getTaxonomy().getScientificName())) continue;
                treeSet.add(string);
            }
            try {
                BufferedWriter iOException2 = new BufferedWriter(new FileWriter(file4));
                for (String string : treeSet) {
                    iOException2.write(string);
                    iOException2.newLine();
                }
                iOException2.close();
            }
            catch (IOException iOException3) {
                ForesterUtil.fatalError(PRG_NAME, "failed to write to [" + file4 + "]: " + iOException3.getLocalizedMessage());
            }
            ForesterUtil.programMessage(PRG_NAME, "wrote present species to: " + file4);
            try {
                BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file3));
                for (String string : sortedSet) {
                    bufferedWriter.write(string);
                    bufferedWriter.newLine();
                }
                bufferedWriter.close();
            }
            catch (IOException iOException4) {
                ForesterUtil.fatalError(PRG_NAME, "failed to write to [" + file3 + "]: " + iOException4.getLocalizedMessage());
            }
            ForesterUtil.programMessage(PRG_NAME, "wrote removed external nodes labels to: " + file3);
            ForesterUtil.programMessage(PRG_NAME, "OK");
        }
        catch (Exception exception) {
            ForesterUtil.fatalError(PRG_NAME, exception.getMessage());
        }
    }

    public static void checkForOutputFileWriteability(File file) {
        String string = ForesterUtil.isWritableFile(file);
        if (!ForesterUtil.isEmpty(string)) {
            ForesterUtil.fatalError(PRG_NAME, string);
        }
    }

    private static void printHelp() {
        ForesterUtil.printProgramInformation(PRG_NAME, PRG_DESC, PRG_VERSION, PRG_DATE, E_MAIL, WWW, ForesterUtil.getForesterLibraryInformation());
        System.out.print("Usage: ");
        System.out.println("gene_tree_preprocess <input phylogeny file>");
        System.out.println();
    }
}

