/*
 * Decompiled with CFR 0.152.
 */
package briefj;

import au.com.bytecode.opencsv.CSVParser;
import briefj.BriefFiles;
import briefj.DefaultCharset;
import com.google.common.base.Function;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.io.CharSource;
import com.google.common.io.Files;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;

public class BriefIO {
    public static final Function<String, List<String>> splitCSV = BriefIO.splitCSV(new CSVParser());
    private static boolean localeSet = false;

    public static ReadLineIterable readLines(File file) {
        return BriefIO.readLines(file, DefaultCharset.defaultCharset);
    }

    public static ReadLineIterable readLines(String file) {
        return BriefIO.readLines(new File(file));
    }

    public static ReadLineIterable readLines(File file, Charset charset) {
        return new ReadLineIterable(Files.asCharSource((File)file, (Charset)charset));
    }

    public static ReadLineIterable readLinesFromURL(String url) {
        return BriefIO.readLinesFromURL(url, DefaultCharset.defaultCharset);
    }

    public static ReadLineIterable readLinesFromURL(String url, Charset charset) {
        return new ReadLineIterable(new URLCharSource(url, charset));
    }

    public static String resourceToString(String resource, Charset charset) {
        return BriefIO.read(new ResourceCharSource(resource, charset));
    }

    public static String resourceToString(String resource) {
        return BriefIO.resourceToString(resource, DefaultCharset.defaultCharset);
    }

    public static String fileToString(File file, Charset charset) {
        return BriefIO.read(Files.asCharSource((File)file, (Charset)charset));
    }

    public static String fileToString(File file) {
        return BriefIO.fileToString(file, DefaultCharset.defaultCharset);
    }

    public static String urlToString(String url, Charset charset) {
        return BriefIO.read(new URLCharSource(url, charset));
    }

    public static String urlToString(String url) {
        return BriefIO.urlToString(url, DefaultCharset.defaultCharset);
    }

    public static ReadLineIterable readLinesFromResource(String resource) {
        return BriefIO.readLinesFromResource(resource, DefaultCharset.defaultCharset);
    }

    public static ReadLineIterable readLinesFromResource(String resource, Charset charset) {
        return new ReadLineIterable(new ResourceCharSource(resource, charset));
    }

    public static String read(CharSource charSource) {
        try {
            return charSource.read();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Function<String, List<String>> splitCSV(final CSVParser parser) {
        return new Function<String, List<String>>(){

            public List<String> apply(String input) {
                try {
                    return Arrays.asList(parser.parseLine(input));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    public static Function<List<String>, Map<String, String>> listToMap(final List<String> keys) {
        return new Function<List<String>, Map<String, String>>(){

            public Map<String, String> apply(List<String> values) {
                int size = keys.size();
                if (size != values.size()) {
                    throw new RuntimeException("The number of keys should have the same length as the number of values.");
                }
                LinkedHashMap result = Maps.newLinkedHashMap();
                for (int i = 0; i < size; ++i) {
                    result.put(keys.get(i), values.get(i));
                }
                return result;
            }
        };
    }

    public static void write(File f, CharSequence thingsToBeWritten) {
        PrintWriter out = BriefIO.output(f);
        out.append(thingsToBeWritten);
        out.close();
    }

    public static Gson createGson() {
        return new GsonBuilder().setPrettyPrinting().create();
    }

    public static PrintWriter output(File f) {
        return BriefIO.output(f, DefaultCharset.defaultCharset);
    }

    public static PrintWriter output(File f, Charset charset) {
        try {
            BriefFiles.createParentDirs(f);
            return new PrintWriter(f, charset.name());
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static void ensureUSLocale() {
        if (localeSet) {
            return;
        }
        Locale.setDefault(Locale.US);
        localeSet = true;
    }

    public static String prompt(String prompt) {
        BufferedReader in = DefaultCharset.getReader(System.in);
        String str = "";
        if (prompt != null) {
            System.out.print(prompt + "> ");
        }
        try {
            str = in.readLine();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (str == null) {
            return "";
        }
        return str;
    }

    public static String prompt() {
        return BriefIO.prompt(null);
    }

    private static class BufferedReaderIterator
    implements Iterator<String> {
        private BufferedReader reader = null;
        private String currentLine = null;
        boolean closed = false;

        public BufferedReaderIterator(BufferedReader r) {
            this.reader = r;
        }

        @Override
        public boolean hasNext() {
            if (this.currentLine != null) {
                return true;
            }
            if (this.closed) {
                return false;
            }
            try {
                this.currentLine = this.reader.readLine();
                if (this.currentLine == null) {
                    this.reader.close();
                    this.closed = true;
                }
                return this.currentLine != null;
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        }

        @Override
        public String next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            String result = this.currentLine;
            this.currentLine = null;
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static class ReadLineIterable
    extends FluentIterable<String> {
        private final CharSource input;

        private ReadLineIterable(CharSource input) {
            this.input = input;
        }

        public ReadLineIterable check() throws IOException {
            this.input.readFirstLine();
            return this;
        }

        public FluentIterable<List<String>> splitCSV() {
            return this.splitCSV(new CSVParser());
        }

        public FluentIterable<List<String>> splitCSV(CSVParser parser) {
            return this.transform(BriefIO.splitCSV(parser));
        }

        public FluentIterable<Map<String, String>> indexCSV() {
            return this.indexCSV(new CSVParser());
        }

        public FluentIterable<Map<String, String>> indexCSV(CSVParser parser) {
            List header = (List)Iterables.getFirst(this.splitCSV(parser), (Object)Collections.EMPTY_LIST);
            FluentIterable bodyIterable = this.splitCSV(parser).skip(1);
            return bodyIterable.transform(BriefIO.listToMap(header));
        }

        public Iterator<String> iterator() {
            try {
                return new BufferedReaderIterator(this.input.openBufferedStream());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class URLCharSource
    extends CharSource {
        private final Charset charset;
        private final String url;

        public URLCharSource(String url, Charset charset) {
            this.charset = charset;
            this.url = url;
        }

        public Reader openStream() throws IOException {
            return new BufferedReader(new InputStreamReader(new URL(this.url).openStream(), this.charset));
        }
    }

    private static class ResourceCharSource
    extends CharSource {
        private final Charset charset;
        private final String url;

        public ResourceCharSource(String url, Charset charset) {
            this.charset = charset;
            this.url = url;
        }

        public Reader openStream() throws IOException {
            return new BufferedReader(new InputStreamReader(new Object().getClass().getResourceAsStream(this.url), this.charset));
        }
    }
}

