/*
 * Decompiled with CFR 0.152.
 */
package briefj;

import com.beust.jcommander.internal.Lists;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.RandomStringUtils;

public class BriefStrings {
    private static final int ID_LENGTH = 8;

    public static List<String> allGroupsFromFirstMatch(String p, String string) {
        return BriefStrings.allGroupsFromFirstMatch(Pattern.compile(p), string);
    }

    public static List<String> allGroupsFromFirstMatch(Pattern p, String string) {
        Matcher m = p.matcher(string);
        ArrayList<String> result = new ArrayList<String>();
        if (!m.find()) {
            return result;
        }
        for (int i = 1; i <= m.groupCount(); ++i) {
            result.add(m.group(i));
        }
        return result;
    }

    public static String firstGroupFromFirstMatch(Pattern p, String string) {
        Matcher m = p.matcher(string);
        if (!m.find()) {
            return null;
        }
        return m.group(1);
    }

    public static List<String> firstGroupFromAllMatches(Pattern p, String string) {
        List result = Lists.newArrayList();
        Matcher m = p.matcher(string);
        while (m.find()) {
            result.add(m.group(1));
        }
        return result;
    }

    public static List<String> firstGroupFromAllMatches(String regex, String string) {
        return BriefStrings.firstGroupFromAllMatches(Pattern.compile(regex), string);
    }

    public static String firstGroupFromFirstMatch(String regex, String string) {
        return BriefStrings.firstGroupFromFirstMatch(Pattern.compile(regex), string);
    }

    public static String generateUniqueId() {
        return RandomStringUtils.randomAlphanumeric((int)8);
    }

    public static String indent(String str) {
        return BriefStrings.indent(str, "  ");
    }

    public static String indent(String str, String indentationStr) {
        List lines = Splitter.on((String)"\n").splitToList((CharSequence)str);
        return indentationStr + Joiner.on((String)("\n" + indentationStr)).join((Iterable)lines);
    }

    public static String currentDataString() {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss");
        Date today = Calendar.getInstance().getTime();
        return df.format(today);
    }
}

