/*
 * Decompiled with CFR 0.152.
 */
package automata;

import Jama.Matrix;
import automata.Automaton;
import fig.basic.Option;
import gep.util.OutputManager;
import goblin.Taxon;
import java.io.File;
import java.util.Random;
import nuts.io.IO;
import nuts.math.MtxUtils;
import nuts.util.Arbre;
import org.jblas.DoubleMatrix;
import org.jblas.Solve;
import pty.RootedTree;

public class TestSpeed
implements Runnable {
    @Option
    public int leafLen = 10;
    private Matrix[][] transitions;
    @Option
    public Random rand = new Random(1L);
    @Option
    public String treeFile = "medTree.newick";
    public int alephSize = 3;
    OutputManager out = new OutputManager();

    public static void main(String[] args) {
        IO.run(args, new TestSpeed());
    }

    public Automaton compose(Automaton leaf1, Automaton leaf2) {
        Automaton marg1 = Automaton.marginalize(leaf1, this.transitions);
        Automaton marg2 = Automaton.marginalize(leaf2, this.transitions);
        return Automaton.pointwiseMultiply(marg1, marg2);
    }

    public Automaton compose(Arbre<Taxon> node) {
        if (node.isLeaf()) {
            return this.randomLeaf();
        }
        if (node.getChildren().size() != 2) {
            throw new RuntimeException();
        }
        Automaton leaf1 = this.compose(node.getChildren().get(0));
        Automaton leaf2 = this.compose(node.getChildren().get(1));
        return this.compose(leaf1, leaf2);
    }

    public Automaton randomLeaf() {
        int[] obs = new int[this.leafLen];
        for (int i = 0; i < this.leafLen; ++i) {
            obs[i] = 1 + this.rand.nextInt(this.alephSize - 1);
        }
        return Automaton.sequenceIndicator(this.alephSize, obs);
    }

    @Override
    public void run() {
        this.transitions = Automaton.uniformLevPot(this.alephSize).transitions();
        RootedTree t = RootedTree.Util.load(new File(this.treeFile));
        Automaton full = this.compose(t.topology());
        Matrix sum = MtxUtils.zeroes(full.size);
        for (Matrix m : full.transitions) {
            sum.plusEquals(m);
        }
        sum = MtxUtils.id(sum.getColumnDimension()).minusEquals(sum);
        for (boolean useJBLAS : new boolean[]{false, true}) {
            DoubleMatrix jblas = useJBLAS ? new DoubleMatrix(sum.getArray()) : null;
            DoubleMatrix one = useJBLAS ? new DoubleMatrix(MtxUtils.id(full.size).getArray()) : null;
            long start = System.currentTimeMillis();
            if (useJBLAS) {
                Solve.solve((DoubleMatrix)jblas, (DoubleMatrix)one);
            } else {
                sum.inverse();
            }
            long time = System.currentTimeMillis() - start;
            this.out.printWrite("time", "method", useJBLAS ? "blas" : "naive", "treeSize", t.topology().nodes().size(), "automatonSize", full.size, "fullSize", full.size * full.size * this.alephSize * this.alephSize, "value", time);
        }
        this.out.flush();
        this.out.close();
    }

    public static Matrix star(Matrix m) {
        return MtxUtils.id(m.getColumnDimension()).minusEquals(m).inverse();
    }
}

