/*
 * Decompiled with CFR 0.152.
 */
package cognates;

import cognates.LanguageTreeNode;
import java.util.HashSet;
import java.util.Set;
import nuts.math.Graph;
import nuts.util.CollUtils;

public class LanguageTreeGraph
implements Graph<LanguageTreeNode> {
    private static final long serialVersionUID = 1L;
    private LanguageTreeNode root;

    public LanguageTreeGraph(LanguageTreeNode root) {
        this.root = root;
    }

    @Override
    public Set<LanguageTreeNode> nbrs(LanguageTreeNode node) {
        HashSet<LanguageTreeNode> set = CollUtils.set();
        set.add(node.getParent());
        set.add(node.getLeftChild());
        set.add(node.getRightChild());
        return set;
    }

    @Override
    public boolean hasEdge(LanguageTreeNode node1, LanguageTreeNode node2) {
        return node1.isNbr(node2);
    }

    @Override
    public Set<LanguageTreeNode> vertexSet() {
        HashSet<LanguageTreeNode> set = CollUtils.set();
        this.preorder(this.root, set);
        return set;
    }

    private void preorder(LanguageTreeNode node, Set<LanguageTreeNode> set) {
        if (node == null) {
            return;
        }
        set.add(node);
        this.preorder(node.getLeftChild(), set);
        this.preorder(node.getRightChild(), set);
    }
}

