/*
 * Decompiled with CFR 0.152.
 */
package conifer.proposals;

import conifer.msa.InformedLocalMSAProposal;
import conifer.msa.LocalMSAProposal;
import conifer.msa.TreeMSAParamProposal;
import conifer.msa.TreeMSAState;
import conifer.particle.PhyloParticle;
import conifer.proposals.Adaptor;
import conifer.proposals.IncrementalSMCProposal;
import conifer.proposals.K2PProposal;
import conifer.proposals.ProposalOptions;
import monaco.prop.ProposalProvider;
import monaco.prop.SingletonProvider;
import pty.mcmc.ProposalDistribution;
import pty.mcmc.UnrootedTreeState;
import pty.smc.PartialCoalescentState;

public enum ProposalModel {
    TREE_MSA_PARAM{

        @Override
        public Boolean isClock() {
            return null;
        }

        @Override
        public PhyloParticle getInitialParticle(ProposalOptions options) {
            return new TreeMSAState();
        }

        @Override
        public ProposalProvider<PhyloParticle> getProposalProvider(ProposalOptions options) {
            TreeMSAParamProposal proposal = new TreeMSAParamProposal();
            return new SingletonProvider<PhyloParticle>(proposal);
        }
    }
    ,
    LOCAL_MSA{

        @Override
        public Boolean isClock() {
            return null;
        }

        @Override
        public PhyloParticle getInitialParticle(ProposalOptions options) {
            return new TreeMSAState();
        }

        @Override
        public ProposalProvider<PhyloParticle> getProposalProvider(ProposalOptions options) {
            LocalMSAProposal proposal = new LocalMSAProposal();
            return new SingletonProvider<PhyloParticle>(proposal);
        }
    }
    ,
    INFORMED_LOCAL_MSA{

        @Override
        public Boolean isClock() {
            return null;
        }

        @Override
        public PhyloParticle getInitialParticle(ProposalOptions options) {
            return new TreeMSAState();
        }

        @Override
        public ProposalProvider<PhyloParticle> getProposalProvider(ProposalOptions options) {
            InformedLocalMSAProposal proposal = new InformedLocalMSAProposal();
            return new SingletonProvider<PhyloParticle>(proposal);
        }
    }
    ,
    BRANCH_SCALE{

        @Override
        public PhyloParticle getInitialParticle(ProposalOptions options) {
            if (options.forceTreeMSAParticles) {
                return new TreeMSAState();
            }
            return new UnrootedTreeState();
        }

        @Override
        public ProposalProvider<PhyloParticle> getProposalProvider(ProposalOptions options) {
            ProposalDistribution.MultiplicativeBranchProposal toAdapt = new ProposalDistribution.MultiplicativeBranchProposal(options.multiplicativeBranchProposalScaling, false);
            Adaptor adapted = new Adaptor(toAdapt);
            return new SingletonProvider<PhyloParticle>(adapted);
        }

        @Override
        public Boolean isClock() {
            return false;
        }
    }
    ,
    GLOBAL_BRANCH_SCALE{

        @Override
        public PhyloParticle getInitialParticle(ProposalOptions options) {
            if (options.forceTreeMSAParticles) {
                return new TreeMSAState();
            }
            return new UnrootedTreeState();
        }

        @Override
        public ProposalProvider<PhyloParticle> getProposalProvider(ProposalOptions options) {
            ProposalDistribution.MultiplicativeBranchProposal toAdapt = new ProposalDistribution.MultiplicativeBranchProposal(options.globalMultiplicativeBranchProposalScaling, true);
            Adaptor adapted = new Adaptor(toAdapt);
            return new SingletonProvider<PhyloParticle>(adapted);
        }

        @Override
        public Boolean isClock() {
            return false;
        }
    }
    ,
    NNI{

        @Override
        public PhyloParticle getInitialParticle(ProposalOptions options) {
            if (options.forceTreeMSAParticles) {
                return new TreeMSAState();
            }
            return new UnrootedTreeState();
        }

        @Override
        public ProposalProvider<PhyloParticle> getProposalProvider(ProposalOptions options) {
            ProposalDistribution.StochasticNearestNeighborInterchangeProposal toAdapt = new ProposalDistribution.StochasticNearestNeighborInterchangeProposal();
            Adaptor adapted = new Adaptor(toAdapt);
            return new SingletonProvider<PhyloParticle>(adapted);
        }

        @Override
        public Boolean isClock() {
            return false;
        }
    }
    ,
    K2P_TT{

        @Override
        public Boolean isClock() {
            return false;
        }

        @Override
        public PhyloParticle getInitialParticle(ProposalOptions options) {
            return new TreeMSAState();
        }

        @Override
        public ProposalProvider<PhyloParticle> getProposalProvider(ProposalOptions options) {
            K2PProposal p = new K2PProposal();
            return new SingletonProvider<PhyloParticle>(p);
        }
    }
    ,
    SIMPLE_PRIOR_PRIOR{

        @Override
        public Boolean isClock() {
            return true;
        }

        @Override
        public PhyloParticle getInitialParticle(ProposalOptions options) {
            return new PartialCoalescentState();
        }

        @Override
        public ProposalProvider<PhyloParticle> getProposalProvider(ProposalOptions options) {
            return new SingletonProvider<PhyloParticle>(new IncrementalSMCProposal());
        }
    };


    public abstract Boolean isClock();

    public abstract PhyloParticle getInitialParticle(ProposalOptions var1);

    public abstract ProposalProvider<PhyloParticle> getProposalProvider(ProposalOptions var1);
}

