/*
 * Decompiled with CFR 0.152.
 */
package ev.ex;

import ev.ex.SimpleParticleFilter;
import hmm.Param;
import hmm.ParamUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import nuts.math.TreeSumProd;
import pty.smc.test.TestParticleNormalization;

public class SimpleParticleFilterTest {
    public static void main(String[] args) {
        Random rand = new Random(1L);
        Param p = ParamUtils.randomUniParam(rand, 10, 10);
        System.out.println("Param:\n" + p);
        int[] obs = new int[20];
        for (int i = 0; i < obs.length; ++i) {
            obs[i] = rand.nextInt(p.emiMtx.nDestStates());
        }
        System.out.println("Observation:" + Arrays.toString(obs));
        ArrayList<Integer> obsList = new ArrayList<Integer>();
        for (int o : obs) {
            obsList.add(o);
        }
        TreeSumProd.HmmAdaptor adapt = new TreeSumProd.HmmAdaptor(p, obsList);
        TreeSumProd<Integer> tsp = new TreeSumProd<Integer>(adapt);
        System.out.println("Exact data likelihood: " + tsp.logZ());
        for (int nPart = 1; nPart < 100000; nPart *= 10) {
            TestParticleNormalization.HMMParticleKernel pk = new TestParticleNormalization.HMMParticleKernel(p, obs);
            SimpleParticleFilter<TestParticleNormalization.HMMPState> pf = new SimpleParticleFilter<TestParticleNormalization.HMMPState>();
            pf.nParticles = nPart;
            pf.compute(rand, pk);
            System.out.println("Approximation with " + nPart + " particles: " + pf.estimateNormalizer());
        }
    }
}

