/*
 * Decompiled with CFR 0.152.
 */
package ev.par;

import ev.par.Model;

public final class Output
implements Comparable<Output> {
    public final int state2;
    public final int topSymbol;
    public final int botSymbol;
    private final Model model;

    public Output(int state2, int topSymbol, int botSymbol, Model model) {
        this.state2 = state2;
        this.topSymbol = topSymbol;
        this.botSymbol = botSymbol;
        this.model = model;
        if (topSymbol == model.epsilon() && botSymbol == model.epsilon()) {
            throw new RuntimeException();
        }
    }

    @Override
    public int compareTo(Output other) {
        if (this.state2 < other.state2) {
            return -1;
        }
        if (this.state2 == other.state2) {
            if (this.topSymbol < other.topSymbol) {
                return -1;
            }
            if (this.topSymbol == other.topSymbol) {
                if (this.botSymbol < other.botSymbol) {
                    return -1;
                }
                if (this.botSymbol == other.botSymbol) {
                    return 0;
                }
                return 1;
            }
            return 1;
        }
        return 1;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.botSymbol;
        result = 31 * result + (this.model == null ? 0 : this.model.hashCode());
        result = 31 * result + this.state2;
        result = 31 * result + this.topSymbol;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Output other = (Output)obj;
        if (this.botSymbol != other.botSymbol) {
            return false;
        }
        if (this.model == null ? other.model != null : !this.model.equals(other.model)) {
            return false;
        }
        if (this.state2 != other.state2) {
            return false;
        }
        return this.topSymbol == other.topSymbol;
    }

    public String toString() {
        return "[state2=" + this.model.stateIndexer.i2o(this.state2) + "," + "topSym=" + this.topToChar() + "," + "botSym=" + this.botToChar() + "]";
    }

    public char toChar(int symbolId) {
        if (symbolId != this.model.epsilon()) {
            return this.model.enc.phoneId2Char(symbolId);
        }
        return '-';
    }

    public char topToChar() {
        return this.toChar(this.topSymbol);
    }

    public char botToChar() {
        return this.toChar(this.botSymbol);
    }
}

