/*
 * Decompiled with CFR 0.152.
 */
package ev.poi.exp;

import ev.multi.Segmenter;
import ev.poi.MSAMarginalLikelihoodCalculator;
import ev.poi.PoissonAlignerMain;
import ev.poi.PoissonModel;
import ev.poi.PoissonModelSampler;
import ev.poi.PoissonParameters;
import ev.poi.exp.MSAOutput;
import ev.poi.exp.PhylogeneticOutput;
import ev.poi.exp.TreeOutput;
import ev.to.Clust;
import ev.to.ExternalMSASystem;
import ev.to.ExternalTreeSystem;
import fig.basic.Option;
import goblin.CognateId;
import goblin.Taxon;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import ma.MSAParser;
import ma.MSAPoset;
import ma.RateMatrixLoader;
import ma.SequenceType;
import nuts.io.IO;
import nuts.util.CollUtils;
import nuts.util.IncrementalExperiment;
import nuts.util.Indexer;
import pepper.Encodings;
import pty.RandomRootedTrees;
import pty.RootedTree;
import pty.UnrootedTree;

public class PoissonSystem
implements IncrementalExperiment.ReestimatedSystem,
IncrementalExperiment.Parallelizable {
    @Option
    public SequenceType sequenceType = SequenceType.RNA;
    @Option
    public int segmentSize = Integer.MAX_VALUE;
    @Option
    public double initialChangeIntensityRate = 1.0;
    @Option
    public boolean initFromGivenAlignments = false;
    @Option
    public boolean initFromRandomCoalescent = false;
    @Option(gloss="Rate param for the exp prior on the phylogenetic tree. Zero to use empirical Bayes prior estimate.")
    public double expTreePriorRate = 0.0;
    public static ExternalTreeSystem externalTreeSystem;
    public static ExternalMSASystem externalMSASystem;
    private double[][] subRates;
    private Indexer<Character> indexer;
    private Map<File, PoissonModelSampler> samplers = CollUtils.map();
    public static final ReturnGivenMSASystem RETURN_GIVEN_MSA;
    public static final RandomCoalescentTreeSystem RANDOM_COALESCENT;

    public PoissonSystem() {
        if (this.sequenceType == SequenceType.RNA) {
            this.indexer = Encodings.rnaEncodings().nonGapCharactersIndexer();
            this.subRates = RateMatrixLoader.k2p();
        } else if (this.sequenceType == SequenceType.PROTEIN) {
            this.indexer = Encodings.proteinEncodings().nonGapCharactersIndexer();
            this.subRates = RateMatrixLoader.dayhoff();
        } else {
            throw new RuntimeException();
        }
    }

    public static void main(String[] args) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        externalTreeSystem = new ExternalTreeSystem();
        externalMSASystem = new ExternalMSASystem();
        PoissonSystem system = new PoissonSystem();
        IncrementalExperiment experiments = new IncrementalExperiment(system);
        experiments.outputTypeClassPackage = PhylogeneticOutput.class.getPackage().getName();
        IO.run(args, experiments, "coalInit", RANDOM_COALESCENT, "system", system, "clust", Clust.class, "treeinit", externalTreeSystem, "msainit", externalMSASystem, "tprop", PoissonAlignerMain.proposalOptions, "prop", PoissonAlignerMain.poissonProposalOptions, "nj", ExternalTreeSystem.nj, "phyml", ExternalTreeSystem.phyML);
    }

    @Override
    public void inference(IncrementalExperiment.InferenceContext context) {
        PoissonModelSampler current = this.getSampler(context);
        current.resetStats();
        current.move();
        File treeFile = context.getMainOutputFile(TreeOutput.TREE);
        File topoFile = context.getOutputFile(TreeOutput.TREE, "clade-consensus");
        File treeSampleFile = context.getOutputFile(TreeOutput.TREE, "sample");
        IO.writeToDisk(treeFile, current.getConsensusTree().toNewick());
        IO.writeToDisk(topoFile, current.getConsensusTopology().toNewick());
        IO.writeToDisk(treeSampleFile, current.model.currentUnrooted().toNewick());
        if (PoissonAlignerMain.poissonProposalOptions.nMSAResampling > 0) {
            File msaFile = context.getMainOutputFile(MSAOutput.MSA_OUTPUT);
            File msaMaxRecallFile = context.getOutputFile(MSAOutput.MSA_OUTPUT, "max-recall");
            current.getConsensusMSA().toMultiAlignmentObject().saveToMSF(msaFile);
            current.getMaxRecallMSA().toMultiAlignmentObject().saveToMSF(msaMaxRecallFile);
        }
        File acceptRates = context.getOutputFile(IncrementalExperiment.TXT_OUTPUT, "accept-rates");
        IO.writeToDisk(acceptRates, current.acceptString());
        File paramFile = context.getOutputFile(IncrementalExperiment.TXT_OUTPUT, "poi-params");
        IO.writeToDisk(paramFile, current.parametersString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PoissonModelSampler getSampler(IncrementalExperiment.InferenceContext context) {
        File input = context.getInput();
        if (this.samplers.containsKey(input)) {
            return this.samplers.get(input);
        }
        MSAPoset init = MSAParser.parseMSA(context.getInit(MSAOutput.MSA_OUTPUT));
        UnrootedTree t = UnrootedTree.fromNewickRemovingBinaryRoot(context.getInit(TreeOutput.TREE));
        RootedTree initTree = RootedTree.Util.centroidRooting(t);
        List<Segmenter.SegmentBoundary> bounds = Segmenter.chunk(init, this.segmentSize);
        Segmenter segmenter = new Segmenter(CognateId.dummy, init.sequences(), bounds);
        double meanLen = init.getMeanSequenceLength();
        double delRate = PoissonParameters.getDeleteRate(meanLen, this.initialChangeIntensityRate);
        double insertRate = PoissonParameters.getInsertionRate(meanLen, this.initialChangeIntensityRate);
        PoissonParameters initParams = new PoissonParameters(this.indexer, this.subRates, insertRate, delRate);
        MSAMarginalLikelihoodCalculator calc = new MSAMarginalLikelihoodCalculator(initParams, initTree);
        double meanBL = PoissonAlignerMain.meanBL(calc.rootedTree);
        PoissonModel model = new PoissonModel(segmenter.segmentMSA(init), calc, meanBL, calc.params.insertRate, calc.params.deleteRate);
        PoissonModelSampler result = new PoissonModelSampler(model, segmenter);
        PoissonSystem poissonSystem = this;
        synchronized (poissonSystem) {
            this.samplers.put(input, result);
        }
        return result;
    }

    @Override
    public boolean estimation(IncrementalExperiment.EstimationContext context) {
        return true;
    }

    @Override
    public String name() {
        return "Poisson";
    }

    @Override
    public Map<IncrementalExperiment.OutputType, IncrementalExperiment.System> requiredInferenceInitializers() {
        HashMap<IncrementalExperiment.OutputType, IncrementalExperiment.System> result = CollUtils.map();
        if (this.initFromRandomCoalescent) {
            result.put(TreeOutput.TREE, RANDOM_COALESCENT);
        } else {
            result.put(TreeOutput.TREE, externalTreeSystem);
        }
        if (this.initFromGivenAlignments) {
            result.put(MSAOutput.MSA_OUTPUT, RETURN_GIVEN_MSA);
        } else {
            result.put(MSAOutput.MSA_OUTPUT, externalMSASystem);
        }
        return result;
    }

    static {
        RETURN_GIVEN_MSA = new ReturnGivenMSASystem();
        RANDOM_COALESCENT = new RandomCoalescentTreeSystem();
    }

    public static class RandomCoalescentTreeSystem
    extends IncrementalExperiment.AbstractSystem {
        @Option
        public double rate = 1.0;
        @Option
        public Random rand = new Random(1L);

        @Override
        public void inference(IncrementalExperiment.InferenceContext context) {
            File f = context.getMainOutputFile(TreeOutput.TREE);
            Set<Taxon> leaves = MSAParser.parseMSA(context.getInput()).sequences().keySet();
            RootedTree t = RandomRootedTrees.sampleCoalescent(this.rand, leaves, this.rate);
            IO.writeToDisk(f, RootedTree.Util.toNewick(t));
        }

        @Override
        public String name() {
            return "RandomCoalescent";
        }
    }

    private static class ReturnGivenMSASystem
    extends IncrementalExperiment.AbstractSystem {
        private ReturnGivenMSASystem() {
        }

        @Override
        public void inference(IncrementalExperiment.InferenceContext context) {
            File f = context.getMainOutputFile(MSAOutput.MSA_OUTPUT);
            MSAPoset.parseAlnOrMsfFormats(context.getInput()).toMultiAlignmentObject().saveToMSF(f);
        }

        @Override
        public String name() {
            return "GivenAlignments";
        }
    }
}

