/*
 * Decompiled with CFR 0.152.
 */
package ev.to;

import goblin.BayesRiskMinimizer;
import goblin.CognateId;
import goblin.ReadEval;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import nuts.util.CollUtils;
import org.apache.commons.math.stat.descriptive.SummaryStatistics;
import pepper.Corpus;

public class CreatePawleyEval {
    public static void main(String[] args) throws IOException {
        Map<CognateId, ReadEval.Evaluation> evals1 = ReadEval.read(args[0]);
        Corpus c = Corpus.parse(args[1]);
        HashMap pawGuess = CollUtils.map();
        for (int row = 0; row < c.getNWords(); ++row) {
            pawGuess.put(c.getCognateId(row), c.getWord(row, "ProtoOceanicPawley"));
        }
        SummaryStatistics stat = new SummaryStatistics();
        for (CognateId id : evals1.keySet()) {
            ReadEval.Evaluation current = evals1.get(id);
            String gold = current.truth;
            String curPawGuess = (String)pawGuess.get(id);
            if (curPawGuess == null) continue;
            double curLoss = BayesRiskMinimizer.levenshteinLoss.loss(gold, curPawGuess);
            stat.addValue(curLoss);
        }
        System.out.println(stat.getMean());
    }
}

