/*
 * Decompiled with CFR 0.152.
 */
package fenchel.factor.multisites;

import fenchel.factor.BinaryFactor;
import fenchel.factor.FactorGraph;
import fenchel.factor.FactorUtils;
import fenchel.factor.IdentityFactor;
import fenchel.factor.SimpleFactorGraph;
import fenchel.factor.UnaryFactor;
import fenchel.factor.multisites.MSBinaryFactor;
import fenchel.factor.multisites.MSFactorBuilder;
import fenchel.factor.multisites.MSUnaryFactor;
import java.util.Iterator;
import nuts.math.Graph;
import nuts.math.MtxUtils;

public class MSFactorGraph<N>
implements FactorGraph<N> {
    private static final int UNASSIGNED = -1;
    private final SimpleFactorGraph<N> simpleFG = new SimpleFactorGraph();
    private final MSFactorBuilder builder;
    private int nSites = -1;

    public MSFactorGraph(MSFactorBuilder builder) {
        this.builder = builder;
    }

    public void addUnary(N node, double[][] site2state) {
        if (this.nSites == -1) {
            this.nSites = site2state.length;
        }
        if (this.nSites != site2state.length) {
            throw new RuntimeException();
        }
        this.simpleFG.addUnary(node, this.builder.buildUnaryFactor(site2state));
        this.checkConsistent(node);
    }

    public void addBinary(N first, N second, double[][] first2second) {
        this.addBinary(first, second, first2second, MtxUtils.transpose(first2second));
    }

    public void addBinary(N first, N second, double[][] first2second, double[][] transpose) {
        this.simpleFG.addBinary(second, first, this.builder.buildHomogeneousBinaryFactor(first2second));
        this.simpleFG.addBinary(first, second, this.builder.buildHomogeneousBinaryFactor(transpose));
        this.checkConsistent(first);
        this.checkConsistent(second);
    }

    public void ensureLeafNotIdentity(N node) {
        UnaryFactor current = this.simpleFG.getUnary(node);
        if (current == IdentityFactor.identity) {
            int nSites = this.nSites();
            int nStates = this.nStates(node);
            double[][] array = new double[nSites][nStates];
            for (int site = 0; site < nSites; ++site) {
                for (int state = 0; state < nStates; ++state) {
                    array[site][state] = 1.0;
                }
            }
            this.addUnary(node, array);
        }
    }

    @Override
    public UnaryFactor getUnary(N node) {
        if (this.getTopology().nbrs(node).size() < 2) {
            this.ensureLeafNotIdentity(node);
        }
        return this.simpleFG.getUnary(node);
    }

    @Override
    public BinaryFactor getBinary(N source, N destination) {
        return this.simpleFG.getBinary(source, destination);
    }

    @Override
    public Graph<N> getTopology() {
        return this.simpleFG.getTopology();
    }

    public int nSites() {
        if (this.nSites == -1) {
            throw new RuntimeException();
        }
        return this.nSites;
    }

    public int nStates(N first) {
        MSUnaryFactor factor;
        MSUnaryFactor mSUnaryFactor = factor = this.simpleFG.getUnary(first) == IdentityFactor.identity ? null : (MSUnaryFactor)this.simpleFG.getUnary(first);
        if (factor != null) {
            return factor.nStates();
        }
        Iterator<N> iterator = this.getTopology().nbrs(first).iterator();
        if (iterator.hasNext()) {
            N second = iterator.next();
            MSBinaryFactor first2second = (MSBinaryFactor)this.getBinary(first, second);
            return first2second.nFirstStates();
        }
        throw new RuntimeException();
    }

    private void checkConsistent(N first) {
        MSUnaryFactor factor;
        MSUnaryFactor mSUnaryFactor = factor = this.simpleFG.getUnary(first) == IdentityFactor.identity ? null : (MSUnaryFactor)this.simpleFG.getUnary(first);
        if (factor == null) {
            return;
        }
        int nStates = factor.nStates();
        for (N second : this.getTopology().nbrs(first)) {
            MSBinaryFactor first2second = (MSBinaryFactor)this.getBinary(first, second);
            if (first2second != null && first2second.nFirstStates() != nStates) {
                throw new RuntimeException();
            }
            MSBinaryFactor second2first = (MSBinaryFactor)this.getBinary(second, first);
            if (second2first == null || second2first.nSecondStates() == nStates) continue;
            throw new RuntimeException();
        }
    }

    public String toString() {
        return FactorUtils.factorGraphUnariesToString(this);
    }
}

