/*
 * Decompiled with CFR 0.152.
 */
package fenchel.measurefacto;

import fenchel.measurefacto.PointwiseOperation;
import fenchel.measurefacto.PointwiseOperationApplicator;
import java.util.Collections;
import java.util.List;

public class ComputeFullProduct
implements PointwiseOperation {
    private final double[] alphas;
    private final double correction;
    private final boolean useSum;

    public static <M> void computeFullProduct(PointwiseOperationApplicator<M> applicator, List<M> queryStats, M output, List<Double> alphas, double correction, boolean useSum) {
        applicator.apply(new ComputeFullProduct(alphas, correction, useSum), queryStats, Collections.singletonList(output));
    }

    private ComputeFullProduct(List<Double> alpha, double correction, boolean useSum) {
        this.useSum = useSum;
        if (correction != 1.0 && alpha == null) {
            throw new RuntimeException();
        }
        this.correction = correction;
        if (alpha == null) {
            this.alphas = null;
        } else {
            this.alphas = new double[alpha.size()];
            for (int i = 0; i < alpha.size(); ++i) {
                this.alphas[i] = alpha.get(i);
            }
        }
    }

    private double pow(double n, int idx) {
        return this.alphas == null ? n : Math.pow(n, this.correction * this.alphas[idx]);
    }

    @Override
    public void apply(double[][] values, int index) {
        double product = this.useSum ? 0.0 : 1.0;
        int nFactors = values.length - 1;
        int outputIdx = values.length - 1;
        for (int i = 0; i < nFactors; ++i) {
            if (values[i] == null) continue;
            double current = this.pow(values[i][index], i);
            if (this.useSum) {
                product += current;
                continue;
            }
            product *= current;
        }
        if (values[outputIdx] == null) {
            throw new RuntimeException();
        }
        values[outputIdx][index] = product;
    }
}

