/*
 * Decompiled with CFR 0.152.
 */
package fig.exec.remote;

import fig.basic.LogInfo;
import fig.basic.SysInfoUtils;
import fig.basic.Utils;
import fig.exec.remote.RemoteExecutorServiceProxy;
import fig.exec.remote.RemoteOpts;
import java.util.ArrayList;

public class RemoteExecutors {
    private static RemoteExecutorServiceProxy pool = null;

    public static RemoteExecutorServiceProxy getRemoteExecutorPool() {
        if (pool == null) {
            pool = RemoteExecutors.newRemoteExecutorPool();
        }
        return pool;
    }

    private static RemoteExecutorServiceProxy newRemoteExecutorPool() {
        int maxNumMachines = RemoteOpts.maxWorkers;
        ArrayList<Integer> ports = RemoteOpts.ports;
        if (ports == null || ports.size() == 0 || maxNumMachines == 0) {
            return new RemoteExecutorServiceProxy(new ArrayList<String>(), 0, new ArrayList<Integer>());
        }
        String hostsString = null;
        try {
            hostsString = Utils.systemGetStringOutput("/usr/mill/bin/ganglia  cpu_idle | cut -f1");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (hostsString != null) {
            ArrayList<String> hosts = new ArrayList<String>();
            for (String host : hostsString.split("\n")) {
                String thisMachine;
                if ((host = host.trim()).equalsIgnoreCase(thisMachine = SysInfoUtils.getHostName())) continue;
                hosts.add(host);
            }
            return new RemoteExecutorServiceProxy(hosts, maxNumMachines, ports);
        }
        LogInfo.error("Couldn't call /usr/mill/bin/ganglia");
        return null;
    }
}

