/*
 * Decompiled with CFR 0.152.
 */
package fig.exec.servlet;

import fig.exec.servlet.ArgumentException;
import fig.exec.servlet.DirSource;
import fig.exec.servlet.FieldListMap;
import fig.exec.servlet.FileFactory;
import fig.exec.servlet.FileItem;
import fig.exec.servlet.FileSource;
import fig.exec.servlet.FileView;
import fig.exec.servlet.MyException;
import fig.exec.servlet.Trail;
import fig.exec.servlet.UpdateQueue;
import fig.exec.servlet.UpdateSpec;

public class DirFileView
extends FileView {
    protected boolean recursive;
    protected boolean listAll;

    public DirFileView(Trail trail, DirSource source, FileFactory factory, boolean recursive, boolean listAll) {
        this.trail = trail;
        this.source = source;
        this.factory = factory;
        this.recursive = recursive;
        this.listAll = listAll;
    }

    @Override
    public FileItem getItem(String name) throws MyException {
        FileItem item = (FileItem)this.items.get(name);
        if (!this.recursive && name.indexOf("/") != -1) {
            throw new ArgumentException("Not allowed to go down more than one directory");
        }
        if (item == null) {
            item = this == this.source.getFileView() ? this.factory.newFileItem(this.childTrail(name), new FileSource((DirSource)this.source, name)) : ((DirSource)this.source).getFileItem(name);
            this.addItem(item);
        }
        return item;
    }

    @Override
    public FieldListMap getMetadataFields() {
        return new FieldListMap();
    }

    @Override
    public void update(UpdateSpec spec, UpdateQueue.Priority priority) throws MyException {
        if (this.listAll) {
            this.updateItemsFromDir((DirSource)this.source, this.recursive ? -1 : 1, DirSource.TraverseSpec.allowAll(), this.factory, false);
        }
        this.updateChildren(spec, priority);
    }
}

