/*
 * Decompiled with CFR 0.152.
 */
package goblin;

import fig.prob.SampleUtils;
import goblin.DerivationTree;
import goblin.EditsTracker;
import goblin.ObservationsTracker;
import goblin.ParamsTracker;
import goblin.Taxon;
import goblin.TreeSamplers;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import nuts.math.MeasureZeroException;
import nuts.math.RejectionSampler;
import nuts.util.Arbre;
import pepper.Edit;
import pepper.editmodel.EditParam;
import pepper.editmodel.ObservedWordSampler;
import pepper.editmodel.PhonemeModel;
import pepper.editmodel.TimeConvectorWordSampler;
import pepper.editmodel.Utils;

public class ConvectorTreeSampler {
    private ObservationsTracker obs;
    private ParamsTracker params;
    private RejectionSampler<Arbre<DerivationTree.DerivationNode>> rejectionSampler;
    private Map<Taxon, String> words = new HashMap<Taxon, String>();
    private Map<Taxon, List<Edit>> cEdits = new HashMap<Taxon, List<Edit>>();
    private List<Arbre<DerivationTree.DerivationNode>> allNodes;
    private Arbre<DerivationTree.DerivationNode> root;
    private Random rand;
    private Map<Taxon, Double> sumProbabilities = new HashMap<Taxon, Double>();

    private void update(Taxon lang, Taxon parentLang, List<Edit> edits) {
        this.words.put(lang, Utils.bottomWord(edits));
        this.words.put(parentLang, Utils.topWord(edits));
        this.cEdits.put(lang, edits);
    }

    public void init(ParamsTracker params, Arbre<DerivationTree.DerivationNode> derivationTree, ObservationsTracker obs, RejectionSampler<Arbre<DerivationTree.DerivationNode>> rejectionSampler) {
        TreeSamplers.checkConsistent(derivationTree, obs);
        this.obs = obs;
        this.params = params;
        this.rejectionSampler = rejectionSampler;
        this.root = derivationTree.copy();
        this.allNodes = derivationTree.nodes();
        for (Arbre<DerivationTree.DerivationNode> node : this.allNodes) {
            this.words.put(node.getContents().getLanguage(), node.getContents().getWord());
        }
    }

    public Arbre<DerivationTree.DerivationNode> sample(EditsTracker resultEditsTracker, Random rand) throws MeasureZeroException {
        this.rand = rand;
        this.rejectionSampler.initInnerSampler(new InnerSampler());
        Arbre<DerivationTree.DerivationNode> result = this.rejectionSampler.sample(null);
        this.updateEditsTracker(resultEditsTracker);
        return result;
    }

    public Arbre<DerivationTree.DerivationNode> reconstructCurrentDerivationTree(Arbre<DerivationTree.DerivationNode> init) {
        Taxon currentLang = init.getContents().getLanguage();
        String currentWord = this.words.get(currentLang);
        List<Edit> currentEdits = this.cEdits.get(currentLang);
        DerivationTree.Derivation derivation = init.isRoot() ? null : DerivationTree.Derivation.editList2Derivation(currentEdits);
        Arbre<DerivationTree.DerivationNode> result = Arbre.arbre(new DerivationTree.DerivationNode(currentLang, currentWord, derivation));
        for (Arbre<DerivationTree.DerivationNode> child : init.getChildren()) {
            result.addLeaves(this.reconstructCurrentDerivationTree(child));
        }
        return result;
    }

    public void updateEditsTracker(EditsTracker tracker) {
        for (Taxon lang : this.cEdits.keySet()) {
            tracker.update(lang, this.cEdits.get(lang));
        }
    }

    private void sampleNode(int nodeIndex) throws MeasureZeroException {
        Arbre<DerivationTree.DerivationNode> currentNode = this.allNodes.get(nodeIndex);
        Taxon currentLang = currentNode.getContents().getLanguage();
        if (this.obs.isObserved(currentLang) && !currentNode.isRoot()) {
            this.sampleObserved(nodeIndex);
        } else if (!this.obs.isObserved(currentLang)) {
            this.sampleHidden(nodeIndex);
        }
    }

    private void sampleHidden(int nodeIndex) throws MeasureZeroException {
        Arbre<DerivationTree.DerivationNode> currentNode = this.allNodes.get(nodeIndex);
        Taxon currentLang = currentNode.getContents().getLanguage();
        String topStr = null;
        EditParam topEditParams = null;
        PhonemeModel phonemeModel = null;
        Taxon parentLang = null;
        if (!currentNode.isRoot()) {
            Arbre<DerivationTree.DerivationNode> parentNode = currentNode.getParent();
            parentLang = parentNode.getContents().getLanguage();
            topStr = this.words.get(parentLang);
            topEditParams = this.params.getEditParam(currentLang);
        } else {
            phonemeModel = this.params.getRootPhonemeModel();
        }
        int nChildren = currentNode.getChildren().size();
        if (nChildren > 2) {
            throw new RuntimeException();
        }
        String bottom1Str = null;
        String bottom2Str = null;
        EditParam editParams1 = null;
        EditParam editParams2 = null;
        Taxon child1Lang = null;
        Taxon child2Lang = null;
        if (nChildren >= 1) {
            Arbre<DerivationTree.DerivationNode> child1Node = currentNode.getChildren().get(0);
            child1Lang = child1Node.getContents().getLanguage();
            bottom1Str = this.words.get(child1Lang);
            editParams1 = this.params.getEditParam(child1Lang);
        }
        if (nChildren >= 2) {
            Arbre<DerivationTree.DerivationNode> child2Node = currentNode.getChildren().get(1);
            child2Lang = child2Node.getContents().getLanguage();
            bottom2Str = this.words.get(child2Lang);
            editParams2 = this.params.getEditParam(child2Lang);
        }
        TimeConvectorWordSampler timeConvector = new TimeConvectorWordSampler(this.params.getEncodings());
        timeConvector.setFindViterbi(false);
        if (!timeConvector.sample()) {
            throw new MeasureZeroException("TimeConvector.sample() returned false");
        }
        if (timeConvector.getMiddleStr().length() == 0) {
            return;
        }
        this.sumProbabilities.put(currentLang, timeConvector.getSumProb());
        if (!currentNode.isRoot()) {
            this.update(currentLang, parentLang, timeConvector.getTop2MiddleEdits());
        }
        if (nChildren >= 1) {
            this.update(child1Lang, currentLang, timeConvector.getMiddle2Bottom1Edits());
        }
        if (nChildren >= 2) {
            this.update(child2Lang, currentLang, timeConvector.getMiddle2Bottom2Edits());
        }
    }

    private void sampleObserved(int nodeIndex) throws MeasureZeroException {
        Arbre<DerivationTree.DerivationNode> currentNode = this.allNodes.get(nodeIndex);
        Taxon currentLang = currentNode.getContents().getLanguage();
        EditParam currentParam = this.params.getEditParam(currentLang);
        Taxon parentLang = currentNode.getParent().getContents().getLanguage();
        String parentWord = this.words.get(parentLang);
        String currentWord = this.words.get(currentLang);
        ObservedWordSampler sampler = new ObservedWordSampler(this.rand, currentParam, parentWord, currentWord);
        List<Edit> sample = sampler.sample(false);
        if (sampler.isFailure()) {
            throw new MeasureZeroException("ObservedWordSampler.isFailure() == true");
        }
        this.sumProbabilities.put(currentLang, sampler.sumPr());
        this.update(currentLang, parentLang, sample);
    }

    public double getSumPr() {
        if (this.allNodes.size() != 3 || this.root.getChildren().size() != 2) {
            throw new UnsupportedOperationException();
        }
        Taxon topL = this.root.getContents().getLanguage();
        Taxon leftL = this.root.getChildren().get(0).getContents().getLanguage();
        Taxon rightL = this.root.getChildren().get(1).getContents().getLanguage();
        if (this.obs.isObserved(leftL) && this.obs.isObserved(rightL) && !this.obs.isObserved(topL)) {
            return this.sumProbabilities.get(topL);
        }
        if (this.obs.isObserved(leftL) && this.obs.isObserved(rightL) && this.obs.isObserved(topL)) {
            return this.sumProbabilities.get(leftL) * this.sumProbabilities.get(rightL);
        }
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return "Convector sampler";
    }

    private class InnerSampler
    implements RejectionSampler.InnerSampler<Arbre<DerivationTree.DerivationNode>> {
        private InnerSampler() {
        }

        @Override
        public Arbre<DerivationTree.DerivationNode> sample() throws MeasureZeroException {
            for (int nodeIndex : SampleUtils.samplePermutation(ConvectorTreeSampler.this.rand, ConvectorTreeSampler.this.allNodes.size())) {
                ConvectorTreeSampler.this.sampleNode(nodeIndex);
            }
            return ConvectorTreeSampler.this.reconstructCurrentDerivationTree(ConvectorTreeSampler.this.root);
        }

        @Override
        public double MHratio() {
            throw new RuntimeException();
        }
    }
}

