/*
 * Decompiled with CFR 0.152.
 */
package goblin;

import goblin.Taxon;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import nuts.util.Counter;
import nuts.util.CounterMap;
import pepper.Edit;

public class EditsTracker
implements Serializable {
    private static final long serialVersionUID = 2L;
    private CounterMap<Taxon, Edit> editsByLanguage = new CounterMap();
    private Counter<Taxon> numberOfUpdatesByLanguage = new Counter();

    public void update(Taxon language, List<Edit> edits) {
        this.numberOfUpdatesByLanguage.incrementCount(language, 1.0);
        for (Edit current : edits) {
            this.editsByLanguage.incrementCount(language, current, 1.0);
        }
    }

    public StringBuilder totalCountsStatistics() {
        StringBuilder builder = new StringBuilder();
        for (Taxon lang : this.numberOfUpdatesByLanguage.keySet()) {
            double currentTotalCount = this.editsByLanguage.getCounter(lang).totalCount();
            double nForThisLang = this.numberOfUpdatesByLanguage.getCount(lang);
            builder.append(lang.toString() + ":" + currentTotalCount + "/" + nForThisLang + "=" + currentTotalCount / nForThisLang + "\n");
        }
        return builder;
    }

    public void updateAll(EditsTracker other) {
        this.editsByLanguage.incrementAll(other.editsByLanguage);
        this.numberOfUpdatesByLanguage.incrementAll(other.numberOfUpdatesByLanguage);
    }

    public Counter<Edit> expectedCounts(Taxon lang) {
        Counter<Edit> result = new Counter<Edit>();
        Counter<Edit> rawCounts = this.editsByLanguage.getCounter(lang);
        double norm = this.numberOfUpdatesByLanguage.getCount(lang);
        if (norm == 0.0) {
            throw new RuntimeException();
        }
        for (Edit edit : rawCounts.keySet()) {
            double rawCount = rawCounts.getCount(edit);
            result.setCount(edit, rawCount / norm);
        }
        return result;
    }

    public boolean hasCount(Taxon lang) {
        return this.numberOfUpdatesByLanguage.getCount(lang) > 0.0;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (Taxon lang : this.languages()) {
            builder.append("Edits going to " + lang + ":\n");
            Counter<Edit> current = this.expectedCounts(lang);
            for (Edit edit : current) {
                builder.append("\t" + edit.toString() + "\t" + current.getCount(edit) + "\n");
            }
        }
        return builder.toString();
    }

    public Set<Taxon> languages() {
        return Collections.unmodifiableSet(this.numberOfUpdatesByLanguage.keySet());
    }
}

