/*
 * Decompiled with CFR 0.152.
 */
package goblin;

import fig.basic.IOUtils;
import goblin.EditsTracker;
import goblin.Taxon;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashSet;
import java.util.Set;
import nuts.util.Counter;
import pepper.Edit;

public class EditsTrackers {
    public static StringBuilder toString(Counter<Edit> edits) {
        StringBuilder result = new StringBuilder();
        for (Edit edit : edits) {
            if (edit.isSelfSubstitution()) continue;
            result.append(edit.toString() + "\t" + edits.getCount(edit) + "\n");
        }
        return result;
    }

    public static boolean haveSameLangs(EditsTracker t1, EditsTracker t2) {
        return t1.languages().equals(t2.languages());
    }

    public static double l1(EditsTracker t1, EditsTracker t2, Taxon lang) {
        Counter<Edit> c1 = t1.expectedCounts(lang);
        Counter<Edit> c2 = t2.expectedCounts(lang);
        double result = 0.0;
        for (Edit key : EditsTrackers.unionOfKeys(t1, t2, lang)) {
            result += Math.abs(c1.getCount(key) - c2.getCount(key));
        }
        return result;
    }

    public static double l1(EditsTracker t1, EditsTracker t2) {
        if (!EditsTrackers.haveSameLangs(t1, t2)) {
            throw new RuntimeException("T1 has langs: " + t1.languages() + " whereas T2 has: " + t2.languages());
        }
        double result = 0.0;
        for (Taxon lang : t1.languages()) {
            result += EditsTrackers.l1(t1, t2, lang);
        }
        return result;
    }

    public static String l1summary(EditsTracker t1, EditsTracker t2) {
        StringBuilder result = new StringBuilder();
        result.append(EditsTrackers.l1(t1, t2) + " (");
        for (Taxon lang : t1.languages()) {
            result.append(lang + ":" + EditsTrackers.l1(t1, t2, lang) + " ");
        }
        result.append(")");
        return result.toString();
    }

    public static Set<Edit> unionOfKeys(EditsTracker t1, EditsTracker t2, Taxon lang) {
        Counter<Edit> c1 = t1.expectedCounts(lang);
        Counter<Edit> c2 = t2.expectedCounts(lang);
        HashSet<Edit> keys = new HashSet<Edit>();
        keys.addAll(c1.keySet());
        keys.addAll(c2.keySet());
        return keys;
    }

    public static void saveEditsTracker(EditsTracker editsTracker, String filePath) throws IOException {
        ObjectOutputStream oos = IOUtils.openBinOut(filePath);
        oos.writeObject(editsTracker);
        oos.close();
    }

    public static EditsTracker restoreEditsTracker(String filePath) throws IOException, ClassNotFoundException {
        ObjectInputStream ois = IOUtils.openBinIn(filePath);
        return (EditsTracker)ois.readObject();
    }
}

