/*
 * Decompiled with CFR 0.152.
 */
package goblin;

import fig.basic.IOUtils;
import fig.basic.LogInfo;
import fig.basic.Option;
import fig.basic.Parallelizer;
import fig.exec.Execution;
import goblin.BayesRiskMinimizer;
import goblin.CognateId;
import goblin.CognateSet;
import goblin.DataLoader;
import goblin.DataPrepUtils;
import goblin.DerivationTree;
import goblin.HLParams;
import goblin.HLParamsUpdater;
import goblin.ObservationsTracker;
import goblin.Taxon;
import goblin.TreeSamplers;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import ma.ArbreInitializer;
import ma.GreedyDecoder;
import ma.MultiAlignment;
import nuts.io.Extensions;
import nuts.math.Fct;
import nuts.math.MeasureZeroException;
import nuts.math.Sampling;
import nuts.maxent.LabeledInstance;
import nuts.util.Arbre;
import nuts.util.Counter;
import nuts.util.CounterMap;
import org.apache.commons.math.stat.descriptive.SummaryStatistics;
import org.apache.commons.math.stat.descriptive.SynchronizedSummaryStatistics;
import pepper.Encodings;
import pepper.editmodel.Utils;
import sage.FatContext;
import sage.LikelihoodModel;

public class HLIntegrator {
    private final CognateSet data;
    private boolean collectNGrams = false;
    private HLParams params = null;
    private LikelihoodModel model = null;
    private final Set<FatContext.Granularity> granularities;
    private HLIOptions hliOptions;
    private int t = 0;
    private Map<CognateId, MultiAlignment> referenceAlignments = null;
    private Map<CognateId, MultiAlignment> clustalwAlignments = null;
    private CognateSet _initCognateDB = null;
    private long[] seeds;
    private Counter<LabeledInstance<HLParams.HLContext, HLParams.HLOutcome>> suffStats;
    private Counter<LabeledInstance<FatContext, HLParams.HLOutcome>> fatSuffStats;
    private CounterMap<Taxon, String> ngrams;
    private Counter<ContextualizedEdit> contextEdit;
    private Map<CognateId, String> reconstructions;
    private Map<CognateId, String> maxReconstructions;
    private Map<CognateId, MultiAlignment> msaReconstructions;
    private Map<CognateId, MultiAlignment> msaBayesReconstructions;
    private Map<CognateId, MultiAlignment> msaSPBound;
    private List<DataLoader.HeldoutEntry> currentHeldout;
    private CounterMap<CognateId, String> reconstructionSamples = null;
    private SummaryStatistics globalAcceptStats;

    private int eval(String spec) {
        return HLIntegrator.readIterSpec(spec).evalAt(this.t);
    }

    public static Fct<Integer, Integer> readIterSpec(String spec) {
        try {
            String[] fields = spec.split("[a-z][+]");
            final int base = Integer.parseInt(fields[1]);
            final int coef = Integer.parseInt(fields[0]);
            return new Fct<Integer, Integer>(){

                @Override
                public Integer evalAt(Integer t) {
                    return base + t * coef;
                }
            };
        }
        catch (Exception e) {
            throw new RuntimeException("Bad iter spec:" + spec + ". Should be of the form ax+b");
        }
    }

    public void collectNGrams() {
        this.collectNGrams = true;
    }

    public boolean usePairedModel() {
        return this.model != null;
    }

    public LikelihoodModel safeGetModel() {
        if (this.usePairedModel()) {
            return this.model;
        }
        return this.params;
    }

    public void setReferenceAlignments(Map<CognateId, MultiAlignment> ref) {
        this.referenceAlignments = ref;
    }

    public void setClustalwAlignments(Map<CognateId, MultiAlignment> clust) {
        this.clustalwAlignments = clust;
    }

    public void setT(int t) {
        this.t = t;
    }

    public HLIntegrator(CognateSet data, HLIOptions hliOptions, Set<FatContext.Granularity> granularities) {
        this.data = data.copy();
        this.hliOptions = hliOptions;
        this.granularities = granularities;
    }

    private void annealCognateEntry(Random rand, CognateId id, TreeSamplers.SampleProcessor msp) {
        ObservationsTracker obs = this.data.getObs(id);
        Arbre<DerivationTree.DerivationNode> annealState = this.getInitState(id);
        for (int iteration = 0; iteration < this.eval(this.hliOptions.annealPasses); ++iteration) {
            annealState = this.sample(rand, annealState, obs, msp, false, id, iteration, this.eval(this.hliOptions.annealPasses), true, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sampleCognateEntry(Random rand, CognateId id, TreeSamplers.SampleProcessor msp) {
        PrintWriter out = this.hliOptions.printLLPlots ? IOUtils.openOutHard(Execution.getFile("plot-" + id + "-" + this.t)) : null;
        ObservationsTracker obs = this.data.getObs(id);
        if (this.eval(this.hliOptions.burnIn) >= this.eval(this.hliOptions.mcmcIter)) {
            throw new RuntimeException("Burnin should be strictly smaller than minNRounds");
        }
        Arbre<DerivationTree.DerivationNode> state = this.getInitState(id);
        for (int iteration = 0; iteration < this.eval(this.hliOptions.mcmcIter); ++iteration) {
            boolean isBurntOut = iteration >= this.eval(this.hliOptions.burnIn);
            TreeSamplers.SampleProcessor processor = isBurntOut ? msp : TreeSamplers.devNullSampleProcessor;
            state = this.sample(rand, state, obs, processor, isBurntOut, id, iteration, this.eval(this.hliOptions.mcmcIter), false, out);
        }
        if (this.hliOptions.printLLPlots) {
            out.close();
        }
        HLIntegrator hLIntegrator = this;
        synchronized (hLIntegrator) {
            this.data.updateTree(id, state);
        }
    }

    private Arbre<DerivationTree.DerivationNode> sample(Random rand, Arbre<DerivationTree.DerivationNode> arbre, ObservationsTracker obs, TreeSamplers.SampleProcessor processor, boolean isBurntOut, CognateId id, int i, int N, boolean rejAnneal, PrintWriter out) {
        TreeSamplers.PhyloTreeMCMCKernel kernel = TreeSamplers.createDefaultMixture();
        int nRej = rejAnneal ? this.eval(this.hliOptions.annealPasses) : this.eval(this.hliOptions.rejection);
        kernel.init(processor, arbre, obs, this.params, this.model, rejAnneal, nRej, id);
        SummaryStatistics acceptStats = new SummaryStatistics();
        try {
            long start = System.currentTimeMillis();
            Arbre<DerivationTree.DerivationNode> result = arbre;
            int nMoves = 0;
            int j = 0;
            while ((double)j < this.hliOptions.samplingBlockSizeFactor * (double)HLIntegrator.leavesLength(arbre) + 1.0) {
                long delta;
                Arbre<DerivationTree.DerivationNode> next = kernel.next(rand, result, acceptStats);
                ++nMoves;
                if (this.hliOptions.conditionOnMSA) {
                    try {
                        MultiAlignment nextMSA = MultiAlignment.inducedMultiAlignment(next);
                        MultiAlignment resultMSA = MultiAlignment.inducedMultiAlignment(result);
                        if (this.referenceAlignments.get(id).sumOfPairsScore(nextMSA) >= this.referenceAlignments.get(id).sumOfPairsScore(resultMSA)) {
                            result = next;
                        }
                    }
                    catch (Exception e) {
                        result = next;
                    }
                } else {
                    result = next;
                }
                if (out != null) {
                    out.append(this.safeGetModel().fullLogLikelihood(result, id) + "\t" + this.params.fullLogLikelihood(result, id));
                    if (this.referenceAlignments != null) {
                        MultiAlignment cMSA = MultiAlignment.inducedMultiAlignment(result);
                        out.append("\t" + this.referenceAlignments.get(id).sumOfPairsScore(cMSA) + "\t" + this.referenceAlignments.get(id).columnScore(cMSA));
                    }
                    out.append("\t" + kernel.toString());
                    out.append("\n");
                }
                if ((delta = System.currentTimeMillis() - start) > (long)this.hliOptions.maxMilliSecondPerBlock) {
                    LogInfo.warning("Time exceeded for " + id + " (" + delta + ")... moving on");
                    break;
                }
                ++j;
            }
            long delta = System.currentTimeMillis() - start;
            LogInfo.logs("Round " + i + "/" + N + " for " + id + " [" + (rejAnneal ? "rejAnnealing" : "rejRate=" + (1.0 - acceptStats.getMean()) + ", ") + "totalLength=" + HLIntegrator.totalLength(arbre) + ", " + "treeSize=" + arbre.nodes().size() + ", " + "time=" + delta + "," + "nMoves=" + nMoves + "]");
            this.globalAcceptStats.addValue(acceptStats.getMean());
            return result;
        }
        catch (MeasureZeroException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Arbre<DerivationTree.DerivationNode> getInitState(CognateId id) {
        Arbre<DerivationTree.DerivationNode> fromInitDB;
        Arbre<DerivationTree.DerivationNode> result = null;
        if (this.hliOptions.initWithClustalw && !this.hliOptions.initStatePath.equals("")) {
            throw new RuntimeException();
        }
        result = this.t > 0 ? this.data.getTree(id) : (this.hliOptions.initWithClustalw ? new ArbreInitializer(this.clustalwAlignments.get(id), this.hliOptions.combinatorialInitRandom).init(this.randomInitState(id)) : ((fromInitDB = this.getInitStatFromDB(id)) == null ? this.randomInitState(id) : fromInitDB));
        HLIntegrator hLIntegrator = this;
        synchronized (hLIntegrator) {
            this.data.updateTree(id, result);
        }
        return result;
    }

    private Arbre<DerivationTree.DerivationNode> getInitStatFromDB(CognateId id) {
        if (this.hliOptions.initStatePath.equals("")) {
            return null;
        }
        CognateSet initCognateDB = this.getInitCognateDB();
        if (!initCognateDB.getCognateIds().contains(id)) {
            LogInfo.warning("CognateId:" + id + " was not found in the init db:" + this.hliOptions.initStatePath + "... backing off to random init");
            return null;
        }
        return initCognateDB.getTree(id);
    }

    private CognateSet getInitCognateDB() {
        if (this._initCognateDB != null) {
            return this._initCognateDB;
        }
        try {
            this._initCognateDB = CognateSet.restoreCognateSet(this.hliOptions.initStatePath);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return this._initCognateDB;
    }

    private Arbre<DerivationTree.DerivationNode> randomInitState(CognateId id) {
        Arbre<DerivationTree.DerivationNode> copy = this.data.getTree(id).copy();
        DataPrepUtils.forgetUnobserved(copy, this.data.getObs(id));
        DataPrepUtils.fillInWords(copy, this.hliOptions.combinatorialInitRandom, this.hliOptions.putLongerWordInit);
        return copy;
    }

    public void compute(boolean flushPreviousStrReconSamples, HLParams params, LikelihoodModel model) {
        this.compute(flushPreviousStrReconSamples, params, model, Collections.EMPTY_LIST);
    }

    public void compute(boolean flushPreviousStrReconSamples, HLParams params, LikelihoodModel model, List<DataLoader.HeldoutEntry> heldout) {
        this.currentHeldout = heldout;
        this.params = params;
        this.model = model;
        this.globalAcceptStats = new SynchronizedSummaryStatistics();
        this.suffStats = new Counter();
        this.fatSuffStats = this.usePairedModel() ? new Counter() : null;
        this.ngrams = this.collectNGrams ? new CounterMap() : null;
        this.contextEdit = new Counter();
        this.reconstructions = new HashMap<CognateId, String>();
        this.maxReconstructions = new HashMap<CognateId, String>();
        this.msaReconstructions = new HashMap<CognateId, MultiAlignment>();
        this.msaBayesReconstructions = new HashMap<CognateId, MultiAlignment>();
        this.msaSPBound = new HashMap<CognateId, MultiAlignment>();
        if (flushPreviousStrReconSamples || this.reconstructionSamples == null) {
            this.reconstructionSamples = new CounterMap();
        }
        List<CognateId> ids = this.orderJobs(this.data.getCognateIds());
        this.seeds = this.setSeeds(ids.size());
        Parallelizer<CognateId> par = new Parallelizer<CognateId>(this.hliOptions.numThreads);
        par.setPrimaryThread();
        par.process(ids, new IntegratorProcessor(false));
        if (this.eval(this.hliOptions.annealPasses) > 0) {
            par.process(ids, new IntegratorProcessor(true));
        }
        LogInfo.logs("Global accept rate:" + this.globalAcceptStats.getMean());
    }

    private long[] setSeeds(int n) {
        return Sampling.createSeeds(n, this.hliOptions.treeSamplerRandom);
    }

    public void setMSAReferences(Map<CognateId, MultiAlignment> msar) {
        this.referenceAlignments = new HashMap<CognateId, MultiAlignment>(msar);
    }

    private List<CognateId> orderJobs(Set<CognateId> cognateIds) {
        final Map<CognateId, Integer> totalLength = this.totalLengths(cognateIds);
        ArrayList<CognateId> result = new ArrayList<CognateId>(cognateIds);
        Collections.sort(result, new Comparator<CognateId>(){

            @Override
            public int compare(CognateId o1, CognateId o2) {
                return -1 * ((Integer)totalLength.get(o1)).compareTo((Integer)totalLength.get(o2));
            }
        });
        return result;
    }

    private Map<CognateId, Integer> totalLengths(Set<CognateId> cognateIds) {
        HashMap<CognateId, Integer> result = new HashMap<CognateId, Integer>();
        for (CognateId id : cognateIds) {
            result.put(id, HLIntegrator.totalLength(this.data.getTree(id)));
        }
        return result;
    }

    public static int totalLength(Arbre<DerivationTree.DerivationNode> a) {
        int cur = 0;
        for (Arbre<DerivationTree.DerivationNode> node : a.root().nodes()) {
            String cWord = node.getContents().getWord();
            cur += cWord == null ? 0 : cWord.length();
        }
        return cur;
    }

    public static int leavesLength(Arbre<DerivationTree.DerivationNode> a) {
        int cur = 0;
        for (Arbre<DerivationTree.DerivationNode> node : a.root().nodes()) {
            if (!node.isLeaf()) continue;
            String cWord = node.getContents().getWord();
            cur += cWord == null ? 0 : cWord.length();
        }
        return cur;
    }

    private HLIntegrator getInstance() {
        return this;
    }

    public void saveReconstructionSamples(String prefix, Integer iteration) {
        String fileName = prefix + (iteration == null ? "" : Extensions.extension2String(iteration)) + ".samples";
        PrintWriter out = IOUtils.openOutHard(Utils.safeGetExecFilePath(fileName));
        out.append("----\n");
        for (CognateId id : this.reconstructionSamples.keySet()) {
            if (!(this.reconstructionSamples.getCounter(id).totalCount() > 0.0)) continue;
            out.append("ID " + id + "\n");
            out.append("SAMPLES\n");
            for (String word : this.reconstructionSamples.getCounter(id)) {
                out.append(word + "\t" + this.reconstructionSamples.getCount(id, word) + "\n");
            }
            out.append("\n----\n");
        }
        out.close();
    }

    private String reconstruct(Counter<String> multiplicities) {
        BayesRiskMinimizer<String> riskMinimizer = new BayesRiskMinimizer<String>(this.getLoss(), this.hliOptions.useFrankDecode);
        return riskMinimizer.findMin(multiplicities);
    }

    private MultiAlignment reconstructMSA(CognateId id, Counter<GreedyDecoder.Edge> multiplicities) {
        return GreedyDecoder.decode(multiplicities, this.referenceAlignments.get(id).getSequences());
    }

    public BayesRiskMinimizer.LossFct<String> getLoss() {
        return BayesRiskMinimizer.levenshteinLoss;
    }

    public BayesRiskMinimizer.LossFct<MultiAlignment> getMSALoss() {
        return new MultiAlignment.MALossFunction(true);
    }

    private static Taxon heldoutLang(List<DataLoader.HeldoutEntry> he, CognateId id) {
        Taxon foundLang = null;
        for (DataLoader.HeldoutEntry entry : he) {
            if (!entry.id.equals(id)) continue;
            if (foundLang != null) {
                throw new RuntimeException("Internal error: more than on match in heldoutLang():" + foundLang + "," + entry.node);
            }
            foundLang = entry.node;
        }
        return foundLang;
    }

    public Map<CognateId, String> getReconstructions() {
        return this.reconstructions;
    }

    public Map<CognateId, String> getMaxReconstructions() {
        return this.maxReconstructions;
    }

    public Map<CognateId, MultiAlignment> getMSAReconstructions() {
        return this.msaReconstructions;
    }

    public Map<CognateId, MultiAlignment> getBayesMSAReconstructions() {
        return this.msaBayesReconstructions;
    }

    public Map<CognateId, MultiAlignment> getSPBoundMSA() {
        return this.msaSPBound;
    }

    public Counter<LabeledInstance<HLParams.HLContext, HLParams.HLOutcome>> getSufficientStatistics() {
        return this.suffStats;
    }

    public void saveSuffStatsInExec(Integer iteration) {
        HLIntegrator.saveSuffStatsInExec("suffStats", iteration, this.getSufficientStatistics());
        if (this.usePairedModel()) {
            HLIntegrator.saveSuffStatsInExec("fatSuffStats", iteration, this.getFatSufficientStatistics());
        }
    }

    public CounterMap<Taxon, String> getNGramSuffStats() {
        if (!this.collectNGrams) {
            throw new RuntimeException();
        }
        return this.ngrams;
    }

    public Counter<LabeledInstance<FatContext, HLParams.HLOutcome>> getFatSufficientStatistics() {
        if (!this.usePairedModel()) {
            throw new RuntimeException();
        }
        return this.fatSuffStats;
    }

    public static void saveSuffStatsInExec(String prefix, Integer iteration, Counter c) {
        String fileName = prefix + (iteration == null ? "" : Extensions.extension2String(iteration));
        try {
            ObjectOutputStream oos = IOUtils.openBinOut(Utils.safeGetExecFilePath(fileName));
            oos.writeObject(c);
            oos.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Counter<LabeledInstance<FatContext, HLParams.HLOutcome>> restoreSuffStats(String file) {
        try {
            ObjectInputStream ois = IOUtils.openBinIn(file);
            return (Counter)ois.readObject();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Counter<ContextualizedEdit> getContextEdits() {
        if (!this.hliOptions.collectContextEdit) {
            throw new RuntimeException();
        }
        return this.contextEdit;
    }

    public CognateSet getCognateSet() {
        return this.data.copy();
    }

    public static void addContextEdits(Arbre<DerivationTree.DerivationNode> t, Counter<ContextualizedEdit> counter, int ctxtSize) {
        for (Arbre<DerivationTree.DerivationNode> st : t.root().nodes()) {
            if (st.isRoot()) continue;
            ContextEditExtractor cee = new ContextEditExtractor(st.getContents().getDerivation(), st.getContents().getLanguage(), ctxtSize);
            cee.extract();
            for (ContextualizedEdit cEdit : cee.contexts) {
                counter.incrementCount(cEdit, 1.0);
            }
        }
    }

    public static void filterContextEdits(Counter<ContextualizedEdit> counter, double threshold) {
        HashSet<ContextualizedEdit> keys = new HashSet<ContextualizedEdit>(counter.keySet());
        for (ContextualizedEdit key : keys) {
            if (!key.isTrivialSub() && !(counter.getCount(key) < threshold)) continue;
            counter.removeKey(key);
        }
    }

    public void saveContextEditInExec(String prefix) {
        this.saveContextEditInExec(prefix, null);
    }

    public void saveContextEditInExec(String prefix, Integer iteration) {
        String fileName = prefix + (iteration == null ? "" : Extensions.extension2String(iteration)) + ".contextEdits";
        try {
            HLParamsUpdater.saveCounter(this.getContextEdits(), Utils.safeGetExecFilePath(fileName));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void main(String[] args) {
        Encodings enc = Encodings.toyCtxFreeEncodings(2);
        DerivationTree.Derivation d = HLParams.randomHLBranchParams(new Random(1L), enc, false).generateEvolution("ababa", new Random(2L));
        System.out.println(d);
        ContextEditExtractor ce = new ContextEditExtractor(d, Taxon.dummy, 2);
        ce.extract();
        for (ContextualizedEdit ctxt : ce.contexts) {
            System.out.println(ctxt);
        }
    }

    public static String paddedSubstr(String s, int leftIncl, int rightExcl) {
        int i;
        char bound = '#';
        StringBuilder result = new StringBuilder();
        if (rightExcl < 0) {
            for (int i2 = 0; i2 < rightExcl - leftIncl; ++i2) {
                result.append(bound);
            }
            return result.toString();
        }
        for (i = 0; i < -leftIncl; ++i) {
            result.append(bound);
        }
        result.append(s.substring(Math.max(0, leftIncl), Math.min(rightExcl, s.length())));
        for (i = 0; i < rightExcl - s.length(); ++i) {
            result.append(bound);
        }
        return result.toString();
    }

    public static enum ContextType {
        INS,
        DEL,
        SUB;

    }

    private static class ContextEditExtractor
    extends HLParams.StatExtractor {
        private final Taxon lang;
        private final int contextSize;
        private List<ContextualizedEdit> contexts = new ArrayList<ContextualizedEdit>();

        protected ContextEditExtractor(DerivationTree.Derivation d, Taxon lang, int contextSize) {
            super(d);
            this.lang = lang;
            this.contextSize = contextSize;
        }

        private ContextualizedEdit partialContext(int tp) {
            ContextualizedEdit result = new ContextualizedEdit();
            String topStr = this.d.getAncestorWord();
            result.top = Character.valueOf(tp == -1 ? (char)'#' : topStr.charAt(tp));
            result.lang = this.lang;
            result.topLeft = HLIntegrator.paddedSubstr(topStr, tp - this.contextSize, tp);
            result.topRight = HLIntegrator.paddedSubstr(topStr, tp + 1, tp + this.contextSize + 1);
            return result;
        }

        @Override
        protected void addDel(int tp, int pbp) {
            ContextualizedEdit cur = this.partialContext(tp);
            cur.bot = null;
            cur.type = ContextType.DEL;
            this.contexts.add(cur);
        }

        @Override
        protected void addEoIns(int tp, int bp) {
        }

        @Override
        protected void addIns(int tp, int bp) {
            ContextualizedEdit cur = this.partialContext(tp);
            cur.bot = Character.valueOf(this.d.getCurrentWord().charAt(bp));
            cur.type = ContextType.INS;
            this.contexts.add(cur);
        }

        @Override
        protected void addSub(int tp, int bp) {
            ContextualizedEdit cur = this.partialContext(tp);
            cur.bot = Character.valueOf(this.d.getCurrentWord().charAt(bp));
            cur.type = ContextType.SUB;
            this.contexts.add(cur);
        }
    }

    public static class ContextualizedEdit {
        private Taxon lang;
        private String topLeft;
        private String topRight;
        private Character top;
        private Character bot;
        private ContextType type;

        public boolean isTrivialSub() {
            if (this.type != ContextType.SUB) {
                return false;
            }
            return this.top.equals(this.bot);
        }

        public Taxon getLang() {
            return this.lang;
        }

        public String getTopLeft() {
            return this.topLeft;
        }

        public String getTopRight() {
            return this.topRight;
        }

        public Character getTop() {
            return this.top;
        }

        public Character getBot() {
            return this.bot;
        }

        public ContextType getType() {
            return this.type;
        }

        public String toString() {
            return "" + this.top + (this.type == ContextType.INS ? " => " : " -> ") + (this.bot == null ? "" : this.bot) + " / " + this.topLeft + "_" + this.topRight + " @" + this.lang;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.bot == null ? 0 : this.bot.hashCode());
            result = 31 * result + (this.lang == null ? 0 : this.lang.hashCode());
            result = 31 * result + (this.top == null ? 0 : this.top.hashCode());
            result = 31 * result + (this.topLeft == null ? 0 : this.topLeft.hashCode());
            result = 31 * result + (this.topRight == null ? 0 : this.topRight.hashCode());
            result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ContextualizedEdit other = (ContextualizedEdit)obj;
            if (this.bot == null ? other.bot != null : !this.bot.equals(other.bot)) {
                return false;
            }
            if (this.lang == null ? other.lang != null : !this.lang.equals(other.lang)) {
                return false;
            }
            if (this.top == null ? other.top != null : !this.top.equals(other.top)) {
                return false;
            }
            if (this.topLeft == null ? other.topLeft != null : !this.topLeft.equals(other.topLeft)) {
                return false;
            }
            if (this.topRight == null ? other.topRight != null : !this.topRight.equals(other.topRight)) {
                return false;
            }
            return !(this.type == null ? other.type != null : !this.type.equals((Object)other.type));
        }
    }

    public class IntegratorProcessor
    implements Parallelizer.Processor<CognateId> {
        private final boolean rejAnneal;

        public IntegratorProcessor(boolean rejAnneal) {
            this.rejAnneal = rejAnneal;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void process(CognateId id, int i, int n, boolean log) {
            HLIntegrator hLIntegrator = HLIntegrator.this.getInstance();
            synchronized (hLIntegrator) {
                if (log) {
                    LogInfo.track((Object)("Sampling cognate " + i + "/" + n + " [" + id + "]" + (this.rejAnneal ? " (annealed)" : "")), true);
                } else {
                    LogInfo.logs("[Non-main thread is taking charge of cognate " + i + "/" + n + " [" + id + "]" + (this.rejAnneal ? " (annealed)" : "") + "]");
                }
            }
            Random rand = new Random(HLIntegrator.this.seeds[i]);
            TreeSamplers.ForkedSampleProcessor pro = new TreeSamplers.ForkedSampleProcessor();
            CollectSuffStatMSP cssmsp = null;
            CollectContextEditMSP ccemsp = null;
            CollectNGramStats cngs = null;
            MinBayesReconstructMSP mbrmsp = null;
            Taxon langHeldout = HLIntegrator.heldoutLang(HLIntegrator.this.currentHeldout, id);
            MSAReconstructMSP msamsp = new MSAReconstructMSP(id);
            pro.processors.add(msamsp);
            if (!this.rejAnneal) {
                mbrmsp = new MinBayesReconstructMSP(langHeldout);
                pro.processors.add(mbrmsp);
                cssmsp = new CollectSuffStatMSP();
                pro.processors.add(cssmsp);
                if (((HLIntegrator)HLIntegrator.this).hliOptions.collectContextEdit) {
                    ccemsp = new CollectContextEditMSP();
                    pro.processors.add(ccemsp);
                }
                if (HLIntegrator.this.collectNGrams) {
                    cngs = new CollectNGramStats();
                    pro.processors.add(cngs);
                }
            }
            if (this.rejAnneal) {
                HLIntegrator.this.annealCognateEntry(rand, id, pro);
            } else {
                HLIntegrator.this.sampleCognateEntry(rand, id, pro);
            }
            String recon = null;
            MultiAlignment bayesRecon = null;
            if (!this.rejAnneal && mbrmsp.multiplicities.size() > 0) {
                recon = HLIntegrator.this.reconstruct(mbrmsp.multiplicities);
            }
            if (!this.rejAnneal && msamsp.edges.size() > 0 && HLIntegrator.this.referenceAlignments != null) {
                this.saveEdgePosteriors(msamsp.edges, id);
                bayesRecon = HLIntegrator.this.reconstructMSA(id, msamsp.edges);
            }
            HLIntegrator hLIntegrator2 = HLIntegrator.this.getInstance();
            synchronized (hLIntegrator2) {
                if (!this.rejAnneal) {
                    HLIntegrator.this.reconstructionSamples.getCounter(id).incrementAll(mbrmsp.multiplicities);
                    HLIntegrator.this.suffStats.incrementAll(cssmsp.getAverageSuffStat());
                    if (HLIntegrator.this.usePairedModel()) {
                        HLIntegrator.this.fatSuffStats.incrementAll(cssmsp.getAverageFatSuffStat());
                    }
                    if (HLIntegrator.this.collectNGrams) {
                        HLIntegrator.this.ngrams.incrementAll(cngs.getAverageContextEdits());
                    }
                    if (((HLIntegrator)HLIntegrator.this).hliOptions.collectContextEdit) {
                        Counter<ContextualizedEdit> cur = ccemsp.getAverageContextEdits();
                        HLIntegrator.filterContextEdits(cur, 0.1);
                        HLIntegrator.this.contextEdit.incrementAll(cur);
                    }
                    HLIntegrator.this.maxReconstructions.put(id, mbrmsp.argmax);
                    if (mbrmsp.multiplicities.size() > 0) {
                        HLIntegrator.this.reconstructions.put(id, recon);
                    }
                }
                if (msamsp.argmax != null) {
                    HLIntegrator.this.msaReconstructions.put(id, msamsp.argmax);
                }
                if (bayesRecon != null) {
                    HLIntegrator.this.msaBayesReconstructions.put(id, bayesRecon);
                }
                HLIntegrator.this.msaSPBound.put(id, msamsp.boundSPMSA);
            }
            if (log) {
                LogInfo.end_track();
            }
        }

        private void saveEdgePosteriors(Counter<GreedyDecoder.Edge> edges, CognateId id) {
            Map<Taxon, String> seqns = ((MultiAlignment)HLIntegrator.this.referenceAlignments.get(id)).getSequences();
            File dir = new File(Execution.getFile("edgePosteriors_" + HLIntegrator.this.t));
            if (!dir.exists()) {
                dir.mkdir();
            }
            PrintWriter out = IOUtils.openOutHard(new File(dir, "" + id + ".gz"));
            out.println("# Sequences:");
            for (Taxon lang : seqns.keySet()) {
                out.println("" + lang + "\t" + seqns.get(lang));
            }
            out.println("# Edge posteriors:");
            for (GreedyDecoder.Edge e : edges) {
                out.println("" + e + "\t" + edges.getCount(e));
            }
            out.close();
        }
    }

    public class CollectNGramStats
    implements TreeSamplers.SampleProcessor {
        private CounterMap<Taxon, String> counter = new CounterMap();
        private double N = 0.0;
        private final Encodings enc = Encodings.getGlobalEncodings();

        @Override
        public void process(Arbre<DerivationTree.DerivationNode> currentSample, double score, CognateId id) {
            for (Arbre<DerivationTree.DerivationNode> subt : currentSample.nodes()) {
                String word = subt.getContents().getWord();
                Taxon lang = subt.getContents().getLanguage();
                for (int i = 0; i < word.length() + 1; ++i) {
                    this.addNGrams(word, lang, i);
                }
            }
            this.N += 1.0;
        }

        private void addNGrams(String word, Taxon lang, int i) {
            String ngram = "" + this.enc.charAt(word, i);
            this.counter.incrementCount(lang, ngram, 1.0);
            ngram = this.enc.charAt(word, i - 1) + ngram;
            this.counter.incrementCount(lang, ngram, 1.0);
            ngram = this.enc.charAt(word, i - 2) + ngram;
            this.counter.incrementCount(lang, ngram, 1.0);
        }

        public CounterMap<Taxon, String> getAverageContextEdits() {
            CounterMap<Taxon, String> result = new CounterMap<Taxon, String>();
            for (Taxon key : this.counter.keySet()) {
                for (String ngram : this.counter.getCounter(key)) {
                    result.setCount(key, ngram, this.counter.getCount(key, ngram) / this.N);
                }
            }
            return result;
        }
    }

    public class CollectContextEditMSP
    implements TreeSamplers.SampleProcessor {
        private Counter<ContextualizedEdit> counter = new Counter();
        private double N = 0.0;

        @Override
        public void process(Arbre<DerivationTree.DerivationNode> currentSample, double score, CognateId id) {
            HLIntegrator.addContextEdits(currentSample, this.counter, ((HLIntegrator)HLIntegrator.this).hliOptions.contextSize);
            this.N += 1.0;
        }

        public Counter<ContextualizedEdit> getAverageContextEdits() {
            Counter<ContextualizedEdit> result = new Counter<ContextualizedEdit>();
            for (ContextualizedEdit key : this.counter.keySet()) {
                result.setCount(key, this.counter.getCount(key) / this.N);
            }
            return result;
        }

        public String toString() {
            return this.getAverageContextEdits().toString();
        }
    }

    public class CollectSuffStatMSP
    implements TreeSamplers.SampleProcessor {
        private Counter<LabeledInstance<HLParams.HLContext, HLParams.HLOutcome>> counter = new Counter();
        private Counter<LabeledInstance<FatContext, HLParams.HLOutcome>> fatCounter = new Counter();
        private double N = 0.0;

        @Override
        public void process(Arbre<DerivationTree.DerivationNode> currentSample, double score, CognateId id) {
            HLParams.addSuffStats(this.counter, currentSample, ((HLIntegrator)HLIntegrator.this).params.enc);
            if (HLIntegrator.this.usePairedModel()) {
                FatContext.addSuffStats(this.fatCounter, currentSample, HLIntegrator.this.granularities, ((HLIntegrator)HLIntegrator.this).params.enc, id);
            }
            this.N += 1.0;
        }

        public Counter<LabeledInstance<HLParams.HLContext, HLParams.HLOutcome>> getAverageSuffStat() {
            Counter<LabeledInstance<HLParams.HLContext, HLParams.HLOutcome>> result = new Counter<LabeledInstance<HLParams.HLContext, HLParams.HLOutcome>>();
            for (LabeledInstance<HLParams.HLContext, HLParams.HLOutcome> key : this.counter.keySet()) {
                result.setCount(key, this.counter.getCount(key) / this.N);
            }
            return result;
        }

        public Counter<LabeledInstance<FatContext, HLParams.HLOutcome>> getAverageFatSuffStat() {
            if (!HLIntegrator.this.usePairedModel()) {
                throw new RuntimeException();
            }
            Counter<LabeledInstance<FatContext, HLParams.HLOutcome>> result = new Counter<LabeledInstance<FatContext, HLParams.HLOutcome>>();
            for (LabeledInstance<FatContext, HLParams.HLOutcome> key : this.fatCounter.keySet()) {
                result.setCount(key, this.fatCounter.getCount(key) / this.N);
            }
            return result;
        }

        public String toString() {
            return this.getAverageSuffStat().toString();
        }
    }

    public class MinBayesReconstructMSP
    implements TreeSamplers.SampleProcessor {
        public final Taxon language;
        private Counter<String> multiplicities = new Counter();
        private String argmax = null;
        private double max = Double.NEGATIVE_INFINITY;

        public MinBayesReconstructMSP(Taxon language) {
            this.language = language;
        }

        @Override
        public void process(Arbre<DerivationTree.DerivationNode> currentSample, double score, CognateId id) {
            if (this.language == null || !DerivationTree.hasNodeWithLangName(currentSample.root(), this.language)) {
                return;
            }
            String sample = DerivationTree.findNodeByLangName(currentSample, this.language).getContents().getWord();
            if (sample == null) {
                throw new RuntimeException("No node found with " + this.language + " in MinBayesReconstructionMSP.process()");
            }
            this.multiplicities.incrementCount(sample, 1.0);
            if (score > this.max) {
                this.max = score;
                this.argmax = sample;
            }
        }
    }

    public class MSAReconstructMSP
    implements TreeSamplers.SampleProcessor {
        private MultiAlignment argmax = null;
        private double max = Double.NEGATIVE_INFINITY;
        private Counter<GreedyDecoder.Edge> edges = new Counter();
        private int N = 0;
        private double boundSP = Double.NEGATIVE_INFINITY;
        private MultiAlignment boundSPMSA = null;
        private final CognateId id;

        public MSAReconstructMSP(CognateId id) {
            this.id = id;
        }

        @Override
        public void process(Arbre<DerivationTree.DerivationNode> currentSample, double score, CognateId id) {
            if (HLIntegrator.this.referenceAlignments != null) {
                MultiAlignment curMSA = MultiAlignment.inducedMultiAlignment(currentSample);
                this.processEdges(curMSA);
                double curSP = ((MultiAlignment)HLIntegrator.this.referenceAlignments.get(id)).sumOfPairsScore(curMSA);
                if (curSP > this.boundSP) {
                    this.boundSP = curSP;
                    this.boundSPMSA = curMSA;
                }
            }
            if (score > this.max) {
                this.max = score;
                this.argmax = MultiAlignment.inducedMultiAlignment(currentSample);
            }
        }

        private void processEdges(MultiAlignment curMSA) {
            ++this.N;
            GreedyDecoder.addToEdgeCounter(curMSA, this.edges);
        }

        public Counter<GreedyDecoder.Edge> getAverageSuffStat() {
            Counter<GreedyDecoder.Edge> result = new Counter<GreedyDecoder.Edge>();
            for (GreedyDecoder.Edge key : this.edges.keySet()) {
                result.setCount(key, this.edges.getCount(key) / (double)this.N);
            }
            return result;
        }
    }

    public static class HLIOptions {
        @Option(gloss="The seed for the random initialization of the combinatorial state (see DataPrepUtils.fillInWords(.))")
        public Random combinatorialInitRandom = new Random(1L);
        @Option
        public String initStatePath = "";
        @Option
        public boolean initWithClustalw = false;
        @Option(gloss="Seed for the main sampling step (calling LineageSampler.sample(.)")
        public Random treeSamplerRandom = new Random(1L);
        @Option
        public boolean conditionOnMSA = false;
        @Option
        public int numThreads = 1;
        @Option
        public boolean useFrankDecode = true;
        @Option
        public boolean putLongerWordInit = true;
        @Option
        public boolean collectContextEdit = false;
        @Option
        public int contextSize = 2;
        @Option
        public boolean printLLPlots = false;
        @Option
        public double samplingBlockSizeFactor = 1.0;
        @Option
        public int maxMilliSecondPerBlock = 300000;
        @Option
        public String mcmcIter = "3t+3";
        @Option
        public String burnIn = "1t+1";
        @Option
        public String annealPasses = "0t+0";
        @Option
        public String rejection = "30t+100";
    }
}

