/*
 * Decompiled with CFR 0.152.
 */
package goblin;

import fig.basic.IOUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import ma.newick.NewickParser;
import ma.newick.ParseException;
import nuts.tui.FancyTreeRenderer;
import nuts.util.Tree;

public class Reroot {
    public static void main(String[] args) throws ParseException {
        if (args.length != 2) {
            System.out.println("goblin.Reroot <newick_file> <root_lang>");
            return;
        }
        Tree<String> tree = new NewickParser(IOUtils.openInHard(args[0])).parse();
        tree = Reroot.reroot(tree, args[1]);
        tree = Reroot.removeChains(tree);
        tree.setLabel(args[1]);
        System.err.println(FancyTreeRenderer.println(tree));
        System.out.println(tree.toString());
    }

    private static Tree<String> reroot(Tree<String> tree, String string) {
        AdjRelns<String> adjR = Reroot.adjSets(tree);
        return Reroot.reroot(adjR, string, null);
    }

    public static <T> Tree<T> removeChains(Tree<T> tree) {
        if (tree.getChildren().size() == 1) {
            return Reroot.removeChains(tree.getChildren().get(0));
        }
        ArrayList children = new ArrayList();
        for (Tree<T> child : tree.getChildren()) {
            children.add(Reroot.removeChains(child));
        }
        return new Tree<T>(tree.getLabel(), children);
    }

    private static <T> Tree<T> reroot(AdjRelns<T> adjR, T current, T parent) {
        Set nhbrs = adjR.relns.get(current);
        if (parent != null) {
            nhbrs.remove(parent);
        }
        ArrayList children = new ArrayList();
        for (Object elt : nhbrs) {
            children.add(Reroot.reroot(adjR, elt, current));
        }
        return new Tree<T>(current, children);
    }

    public static <T> AdjRelns<T> adjSets(Tree<T> t) {
        AdjRelns relns = new AdjRelns();
        Reroot.adjSets(t, relns);
        return relns;
    }

    public static <T> void adjSets(Tree<T> t, AdjRelns<T> result) {
        for (Tree<T> child : t.getChildren()) {
            result.add(t.getLabel(), child.getLabel());
            Reroot.adjSets(child, result);
        }
    }

    public static class AdjRelns<T> {
        Map<T, Set<T>> relns = new HashMap<T, Set<T>>();

        public void add(T x, T y) {
            this._add(x, y);
            this._add(y, x);
        }

        public void _add(T x, T y) {
            Set<T> set = this.relns.get(x);
            if (set == null) {
                set = new HashSet<T>();
                this.relns.put(x, set);
            }
            set.add(y);
        }
    }
}

