/*
 * Decompiled with CFR 0.152.
 */
package nuts.io;

import fig.basic.CharEncUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import nuts.io.CSVReaderIterator;
import nuts.io.IO;
import nuts.tui.Table;

public class CSV {
    public static String header(Collection objects) {
        return CSV.header(objects.toArray());
    }

    public static String header(Object ... objects) {
        return "#" + CSV.body(objects);
    }

    public static String body(Collection objects) {
        return CSV.body(objects.toArray());
    }

    public static String body(Object ... objects) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < objects.length; ++i) {
            String cur = objects[i] == null ? "" : objects[i].toString();
            if ((cur = cur.replace("\\", "\\\\")).contains("\"") || cur.contains(",")) {
                result.append("\"" + cur.replaceAll("\"", "\"\"") + "\"");
            } else {
                result.append(cur);
            }
            if (i == objects.length - 1) continue;
            result.append(",");
        }
        return result.toString();
    }

    public static Table readFromStdIn() {
        BufferedReader in;
        Table table = new Table();
        try {
            in = CharEncUtils.getReader(System.in);
        }
        catch (IOException e) {
            throw new RuntimeException();
        }
        int row = 0;
        for (List<String> line : CSVReaderIterator.iterate(in)) {
            for (int col = 0; col < line.size(); ++col) {
                table.set(row, col, line.get(col));
            }
            ++row;
        }
        return table;
    }

    public static void main(String[] args) {
        Table table = CSV.readFromStdIn();
        IO.so(table.toString());
    }
}

