/*
 * Decompiled with CFR 0.152.
 */
package nuts.maxent;

public class SloppyMath {
    public static double approxLog(double val) {
        double r = val - 1.0;
        if (Math.abs(r) < 0.3) {
            double rSquared = r * r;
            return r - rSquared / 2.0 + rSquared * r / 3.0;
        }
        double x = Double.doubleToLongBits(val) >> 32;
        return (x - 1.072632447E9) / 1512775.0;
    }

    public static double min(int x, int y) {
        if (x > y) {
            return y;
        }
        return x;
    }

    public static double min(double x, double y) {
        if (x > y) {
            return y;
        }
        return x;
    }

    public static double max(int x, int y) {
        if (x > y) {
            return x;
        }
        return y;
    }

    public static double max(double x, double y) {
        if (x > y) {
            return x;
        }
        return y;
    }

    public static double abs(double x) {
        if (x > 0.0) {
            return x;
        }
        return -1.0 * x;
    }

    public static void main(String[] args) {
        int x = 2;
        int y = 3;
        System.out.println(Math.exp(SloppyMath.logAdd(x, y)));
        System.out.println(Math.exp(x) + Math.exp(y));
    }

    public static double logAdd(double logX, double logY) {
        if (logY > logX) {
            double temp = logX;
            logX = logY;
            logY = temp;
        }
        if (logX == Double.NEGATIVE_INFINITY) {
            return logX;
        }
        double negDiff = logY - logX;
        if (negDiff < -20.0) {
            return logX;
        }
        return logX + Math.log(1.0 + Math.exp(negDiff));
    }

    public static double logAdd(double[] logV) {
        double max = Double.NEGATIVE_INFINITY;
        double maxIndex = 0.0;
        for (int i = 0; i < logV.length; ++i) {
            if (!(logV[i] > max)) continue;
            max = logV[i];
            maxIndex = i;
        }
        if (max == Double.NEGATIVE_INFINITY) {
            return Double.NEGATIVE_INFINITY;
        }
        double threshold = max - 20.0;
        double sumNegativeDifferences = 0.0;
        for (int i = 0; i < logV.length; ++i) {
            if ((double)i == maxIndex || !(logV[i] > threshold)) continue;
            sumNegativeDifferences += Math.exp(logV[i] - max);
        }
        if (sumNegativeDifferences > 0.0) {
            return max + Math.log(1.0 + sumNegativeDifferences);
        }
        return max;
    }
}

