/*
 * Decompiled with CFR 0.152.
 */
package nuts.remote;

import fig.basic.LogInfo;
import fig.basic.Option;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import nuts.io.IO;
import nuts.util.CollUtils;

public class JarCreator {
    private Set<String> classes = CollUtils.set();
    private final File dest;
    private boolean fresh = true;
    private Set<String> acceptedClassNameFilter = null;
    private Random rand = new Random();

    public JarCreator(File dest) {
        this(dest, null);
    }

    public JarCreator(File dest, Collection<String> rawAcceptedClassNameFilter) {
        this.dest = dest;
        if (rawAcceptedClassNameFilter != null) {
            this.acceptedClassNameFilter = CollUtils.set();
            for (String str : rawAcceptedClassNameFilter) {
                str = str.replaceAll(".*[.]", "");
                str = str.replaceAll("[$].*", "");
                this.acceptedClassNameFilter.add(str);
            }
        }
    }

    private boolean accept(String classFileName) {
        if (this.acceptedClassNameFilter == null) {
            return true;
        }
        if (classFileName.contains("$")) {
            for (String sub : classFileName.split("[$]")) {
                if (!this.accept(sub)) continue;
                return true;
            }
            return false;
        }
        return this.acceptedClassNameFilter.contains(classFileName);
    }

    public boolean isEmpty() {
        return this.fresh;
    }

    public void _addDirectory(File f) {
        for (File sub : IO.locate(f, "class")) {
            String current = sub.toString().replace(f.toString(), "");
            if (this.classes.contains(current)) {
                throw new RuntimeException("Duplicate class file:" + current);
            }
            this.classes.add(current);
            if (this.accept(sub.getName().replaceFirst("[.]class$", ""))) continue;
            sub.delete();
        }
        IO.call("jar " + (this.fresh ? "c" : "u") + "f " + this.dest.getAbsolutePath() + " .", null, f);
        this.fresh = false;
    }

    public void addDirectory(File f) {
        File temp = new File(".createJar-" + System.currentTimeMillis() + "." + this.rand.nextLong() + "." + ".tmp");
        IO.call("cp -r " + f.getAbsolutePath() + " " + temp.getAbsolutePath() + "");
        this._addDirectory(temp);
        IO.call("rm -r " + temp.getAbsolutePath());
    }

    public void addJar(File f) {
        try {
            File temp = new File(".createJar-" + System.currentTimeMillis() + "." + this.rand.nextLong() + "." + ".tmp");
            temp.mkdir();
            IO.call("cp " + f.getAbsolutePath() + " " + temp.getAbsolutePath() + "/");
            IO.call("jar xf " + f.getName(), null, temp);
            IO.call("rm -r " + f.getName(), null, temp);
            IO.call("rm -r META-INF", null, temp);
            this._addDirectory(temp);
            IO.call("rm -r " + temp.getAbsolutePath());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void add(File f) {
        if (f.isDirectory()) {
            this.addDirectory(f);
        } else if (f.getName().matches(".*[.]jar$")) {
            this.addJar(f);
        }
    }

    public void addCurrentClassPath() {
        String cp = System.getProperties().getProperty("java.class.path", null);
        for (String item : cp.split("[:]")) {
            if (".".equals(item)) continue;
            this.add(new File(item));
        }
    }

    public File getDestination() {
        return this.dest;
    }

    public static void main(String[] args) {
        IO.runLight(args, new Main());
    }

    public static class Main
    implements Runnable {
        @Option(required=true)
        public String outputJar;
        @Option
        public ArrayList<String> restrictionFiles = new ArrayList();

        @Override
        public void run() {
            LogInfo.logs("Current classpath:" + System.getProperties().getProperty("java.class.path", null));
            HashSet restrictions = null;
            if (this.restrictionFiles != null && this.restrictionFiles.size() > 0) {
                LogInfo.logs("Restriction files:" + this.restrictionFiles);
                restrictions = CollUtils.set();
                for (String file : this.restrictionFiles) {
                    for (String line : IO.i(file)) {
                        restrictions.add(line);
                    }
                }
            }
            File dest = new File(this.outputJar);
            JarCreator creator = new JarCreator(dest, restrictions);
            creator.addCurrentClassPath();
        }
    }
}

