/*
 * Decompiled with CFR 0.152.
 */
package nuts.util;

import Jama.Matrix;
import fig.basic.BipartiteMatcher;
import fig.basic.NumUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nuts.math.Fct;
import nuts.math.Id;
import nuts.math.MtxUtils;
import nuts.math.Poly;
import nuts.tui.Table;
import nuts.util.Indexer;
import org.apache.commons.math.special.Gamma;

public class MathUtils {
    public static double threshold = 1.0E-4;

    public static int nChoose2(int n) {
        return n * (n - 1) / 2;
    }

    public static long nint(double x) {
        if (x < 0.0) {
            return (long)Math.ceil(x - 0.5);
        }
        return (long)Math.floor(x + 0.5);
    }

    public static <S, T> Map<S, T> maxWeightMatching(CostFunction<S, T> cost) {
        Indexer<S> Ss = new Indexer<S>(cost.getSs());
        Indexer<T> Ts = new Indexer<T>(cost.getTs());
        int size = Math.max(Ss.size(), Ts.size());
        double[][] mtx = new double[size][size];
        double min = Double.POSITIVE_INFINITY;
        for (S s : Ss.objects()) {
            for (T t : Ts.objects()) {
                double d;
                double current = cost.cost(s, t);
                if (!(d < min)) continue;
                min = current;
            }
        }
        for (int i = 0; i < size; ++i) {
            for (int j = 0; j < size; ++j) {
                if (i < Ss.size() && j < Ts.size()) {
                    double value = cost.cost(Ss.i2o(i), Ts.i2o(j));
                    if (Double.isNaN(value) || Double.isInfinite(value)) {
                        throw new RuntimeException();
                    }
                    mtx[i][j] = value;
                    continue;
                }
                mtx[i][j] = min - 1.0;
            }
        }
        int[] result = new BipartiteMatcher().findMaxWeightAssignment(mtx);
        HashMap<Object, T> converted = new HashMap<Object, T>();
        for (Object s : Ss.objects()) {
            int sIndex = Ss.o2i(s);
            int img = result[sIndex];
            if (Ts.containsIndex(img)) {
                converted.put(s, Ts.i2o(img));
                continue;
            }
            converted.put(s, null);
        }
        return converted;
    }

    public static double f1Score(double precision, double recall) {
        if (precision + recall == 0.0) {
            return 0.0;
        }
        return 2.0 * (precision * recall) / (precision + recall);
    }

    public static <S, T> double cost(CostFunction<S, T> cost, Map<S, T> map) {
        double sum = 0.0;
        for (S key : map.keySet()) {
            if (map.get(key) == null) continue;
            sum += cost.cost(key, map.get(key));
        }
        return sum;
    }

    public static <S, T> String toString(CostFunction<S, T> cost) {
        int i;
        Table result = new Table();
        Indexer<S> Ss = new Indexer<S>(cost.getSs());
        Indexer<T> Ts = new Indexer<T>(cost.getTs());
        for (i = 0; i < Ss.size(); ++i) {
            result.set(i + 1, 0, "" + Ss.i2o(i));
        }
        for (i = 0; i < Ts.size(); ++i) {
            result.set(0, i + 1, "" + Ts.i2o(i));
        }
        for (i = 0; i < Ss.size(); ++i) {
            for (int j = 0; j < Ts.size(); ++j) {
                result.set(i + 1, j + 1, cost.cost(Ss.i2o(i), Ts.i2o(j)));
            }
        }
        return result.toString();
    }

    public static double logit(double x) {
        return Math.log(x) - Math.log(1.0 - x);
    }

    public static double entropy(double pr) {
        return -pr * Math.log(pr) - (1.0 - pr) * Math.log(1.0 - pr);
    }

    public static double logistic(double x) {
        return 1.0 / (1.0 + Math.exp(-x));
    }

    public static double[] logit(double[] x) {
        double[] result = new double[x.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = MathUtils.logit(x[i]);
        }
        return result;
    }

    public static double[] logistic(double[] x) {
        double[] result = new double[x.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = MathUtils.logistic(x[i]);
        }
        return result;
    }

    public static double logFactorial(int input) {
        return Gamma.logGamma((double)(input + 1));
    }

    public static long binomial(int n, int k) {
        return MathUtils.nint(Math.exp(MathUtils.logBinomial(n, k)));
    }

    public static double logBinomial(int n, int k) {
        return MathUtils.logFactorial(n) - MathUtils.logFactorial(k) - MathUtils.logFactorial(n - k);
    }

    public static boolean isCloseToInt(double x) {
        return MathUtils.close(x, (int)x);
    }

    public static void checkCloseToInt(double x) {
        MathUtils.checkClose(x, (int)x);
    }

    public static int safeIntValue(double x) {
        MathUtils.checkCloseToInt(x);
        return (int)x;
    }

    public static double normalizeRad(double theta) {
        double proportion = theta / 2.0 / Math.PI;
        proportion = proportion < 0.0 ? proportion + 1.0 + (double)((int)(-proportion)) : (proportion -= (double)((int)proportion));
        return proportion * 2.0 * Math.PI;
    }

    public static double normalizeDeg(double deg) {
        double proportion = deg / 360.0;
        proportion = proportion < 0.0 ? proportion + 1.0 + (double)((int)(-proportion)) : (proportion -= (double)((int)proportion));
        return proportion * 360.0;
    }

    public static float normalizeRad(float theta) {
        float proportion = theta / 2.0f / (float)Math.PI;
        proportion = (double)proportion < 0.0 ? proportion + 1.0f + (float)((int)(-proportion)) : (proportion -= (float)((int)proportion));
        return proportion * 2.0f * (float)Math.PI;
    }

    public static void main(String[] args) {
        System.out.println(Math.exp(MathUtils.logFactorial(1)));
        System.out.println(MathUtils.isCloseToInt(0.5));
        System.out.println(MathUtils.isCloseToInt(1.001));
        System.out.println(MathUtils.isCloseToInt(4.0));
        System.out.println(MathUtils.isCloseToInt(4.00000000001));
    }

    public static double[] findStatDistn(double[][] _m) {
        Matrix m = new Matrix(_m);
        double[] numbers = MtxUtils.topEigenvector(m.transpose());
        NumUtils.normalize(numbers);
        return numbers;
    }

    public static Matrix rVector(double[] x) {
        double[][] r = new double[][]{x};
        return new Matrix((double[][])r);
    }

    public static double dot(double[] p, double[] p2) {
        if (p.length != p2.length) {
            throw new RuntimeException();
        }
        double s = 0.0;
        for (int i = 0; i < p.length; ++i) {
            s += p[i] * p2[i];
        }
        return s;
    }

    public static void approxDirDeriv(FPlusDelta f, double init, int n) {
        System.out.println("Approximating derivative: started at " + init);
        double baseValue = f.logfd(0.0);
        for (int i = 0; i < n; ++i) {
            double logfpd = f.logfd(init);
            double logfz = baseValue;
            boolean swapped = false;
            if (logfz > logfpd) {
                double tmp = logfpd;
                logfpd = logfz;
                logfz = tmp;
                swapped = true;
            }
            double approx = (swapped ? -1.0 : 1.0) * Math.exp(MathUtils.logSub(logfpd, logfz) - Math.log(init));
            System.out.println("" + i + ":" + approx);
            init /= 2.0;
        }
    }

    public static final double logSub(double x, double y) {
        return x + Math.log1p(-Math.exp(y - x));
    }

    public static boolean isInteger(double value) {
        return value == (double)((int)value);
    }

    public static String bootstrap(List<Double> values, String estimator) {
        throw new RuntimeException();
    }

    public static String bootstrapMean(List<Double> values) {
        return MathUtils.bootstrap(values, "mean");
    }

    public static String bootstrapMedian(List<Double> values) {
        return MathUtils.bootstrap(values, "median");
    }

    public static double confidenceIntervalRadius(double n, double sum, double sumSquares) {
        double c = 1.96;
        double S2 = 1.0 / (n - 1.0) * (sumSquares - sum * sum / n);
        return 1.96 * Math.sqrt(S2 / n);
    }

    public static double poisson(double rate, int x) {
        return Math.exp((double)x * Math.log(rate) - rate - NumUtils.logGamma(x + 1));
    }

    public static double[] exp(double[] numbers) {
        double[] result = new double[numbers.length];
        for (int i = 0; i < numbers.length; ++i) {
            result[i] = Math.exp(numbers[i]);
        }
        return result;
    }

    public static double[][] exp(double[][] numbers) {
        double[][] result = new double[numbers.length][];
        for (int i = 0; i < numbers.length; ++i) {
            result[i] = MathUtils.exp(numbers[i]);
        }
        return result;
    }

    public static double approxExp(double val) {
        if (Math.abs(val) < 0.1) {
            return 1.0 + val;
        }
        long tmp = (long)(1512775.0 * val + 1.072632447E9);
        return Double.longBitsToDouble(tmp << 32);
    }

    public static double[] addPtwiseVectors(Collection<List<Double>> vectors, Fct<Double, Double> f) {
        assert (vectors != null && vectors.size() > 0);
        int dim = vectors.iterator().next().size();
        double[] resultArray = new double[dim];
        for (List<Double> vector : vectors) {
            assert (vector.size() == dim);
            for (int i = 0; i < dim; ++i) {
                resultArray[i] = resultArray[i] + f.evalAt(vector.get(i));
            }
        }
        return resultArray;
    }

    public static List<Integer> listOfNumbers(int n) {
        ArrayList<Integer> result = new ArrayList<Integer>(n);
        for (int i = 0; i < n; ++i) {
            result.add(i);
        }
        return result;
    }

    public static double[] addVectors(Collection<List<Double>> vectors) {
        return MathUtils.addPtwiseVectors(vectors, new Id<Double>());
    }

    public static double[] addSqrVectors(Collection<List<Double>> vectors) {
        return MathUtils.addPtwiseVectors(vectors, new Poly());
    }

    public static double min(int iMin, int iMax, I2D f) {
        assert (iMin <= iMax);
        double cMin = Double.POSITIVE_INFINITY;
        for (int i = iMin; i < iMax; ++i) {
            double current;
            if (!f.inDom(i) || !((current = f.f(i)) < cMin)) continue;
            cMin = current;
        }
        return cMin;
    }

    public static double min(int iMax, I2D f) {
        return MathUtils.min(0, iMax, f);
    }

    public static double max(int iMin, int iMax, I2D f) {
        assert (iMin <= iMax);
        double cMax = Double.NEGATIVE_INFINITY;
        for (int i = iMin; i < iMax; ++i) {
            double current;
            if (!f.inDom(i) || !((current = f.f(i)) > cMax)) continue;
            cMax = current;
        }
        return cMax;
    }

    public static double max(int iMax, I2D f) {
        return MathUtils.max(0, iMax, f);
    }

    public static double sum(int iMin, int iMax, I2D f) {
        assert (iMin <= iMax);
        double sum = 0.0;
        for (int i = iMin; i < iMax; ++i) {
            if (!f.inDom(i)) continue;
            sum += f.f(i);
        }
        return sum;
    }

    public static double sum(int iMax, I2D f) {
        return MathUtils.sum(0, iMax, f);
    }

    public static double prod(int iMin, int iMax, I2D f) {
        assert (iMin <= iMax);
        double prod = 1.0;
        for (int i = iMin; i < iMax; ++i) {
            if (!f.inDom(i)) continue;
            prod *= f.f(i);
        }
        return prod;
    }

    public static double prod(int iMax, I2D f) {
        return MathUtils.prod(0, iMax, f);
    }

    public static final boolean close(double d1, double d2, double threshold) {
        return Math.abs(d1 - d2) < threshold;
    }

    public static final boolean close(double d1, double d2) {
        return MathUtils.close(d1, d2, threshold);
    }

    public static void checkClose(double d1, double d2) {
        if (!MathUtils.close(d1, d2)) {
            throw new RuntimeException("|" + d1 + " - " + d2 + " | > " + threshold);
        }
    }

    public static boolean isProb(double n) {
        return !(n > 1.0) && !(n < 0.0);
    }

    public static boolean isCloseToProb(double n) {
        return !(n > 1.0 + threshold) && !(n < 0.0);
    }

    public static boolean isCondPr(double[][] cp) {
        for (double[] p : cp) {
            if (MathUtils.isProb(p)) continue;
            return false;
        }
        return true;
    }

    public static boolean isProb(float n) {
        return !((double)n > 1.0) && !((double)n < 0.0);
    }

    public static void checkIsProb(double[] numbers) {
        if (!MathUtils.isProb(numbers)) {
            throw new RuntimeException("Should be a prob. dist.:" + Arrays.toString(numbers));
        }
    }

    public static boolean isProb(double[] numbers) {
        double sum = 0.0;
        for (int i = 0; i < numbers.length; ++i) {
            if (numbers[i] < 0.0) {
                return false;
            }
            sum += numbers[i];
        }
        return MathUtils.close(1.0, sum);
    }

    public static boolean isProb(float[] numbers) {
        double sum = 0.0;
        for (int i = 0; i < numbers.length; ++i) {
            if ((double)numbers[i] < 0.0) {
                return false;
            }
            sum += (double)numbers[i];
        }
        return MathUtils.close(1.0, sum);
    }

    public static double[] pointwiseMultiply(double[] one, double[] two) {
        if (one.length != two.length) {
            throw new RuntimeException("Lengths mismatch");
        }
        double[] result = new double[one.length];
        for (int i = 0; i < one.length; ++i) {
            result[i] = one[i] * two[i];
        }
        return result;
    }

    public static double normalizeAndGetNorm(double[] data) {
        return MathUtils.normalizeAndGetNorm(data, false);
    }

    public static double normalizeAndGetNorm(double[] data, boolean ignore) {
        double sum = 0.0;
        for (double x : data) {
            sum += x;
        }
        if (!ignore && !(sum > 0.0)) {
            throw new RuntimeException();
        }
        int i = 0;
        while (i < data.length) {
            int n = i++;
            data[n] = data[n] / sum;
        }
        return sum;
    }

    public static void normalize(double[][] data) {
        double sum = 0.0;
        double[][] dArray = data;
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            double[] ar;
            for (double x : ar = dArray[i]) {
                sum += x;
            }
        }
        if (sum == 0.0) {
            return;
        }
        for (int i = 0; i < data.length; ++i) {
            int j = 0;
            while (j < data[i].length) {
                double[] dArray2 = data[i];
                int n2 = j++;
                dArray2[n2] = dArray2[n2] / sum;
            }
        }
    }

    public static double frobeniusInfty(double[][] mtx1, double[][] mtx2) {
        double sum = 0.0;
        assert (mtx1.length == mtx2.length);
        for (int i = 0; i < mtx1.length; ++i) {
            assert (mtx1[i].length == mtx2[i].length);
            for (int j = 0; j < mtx1[i].length; ++j) {
                sum += Math.abs(mtx1[i][j] - mtx2[i][j]);
            }
        }
        return sum;
    }

    public static double frobeniusInfty(double[] vec1, double[] vec2) {
        return MathUtils.frobeniusInfty(MathUtils.convert(vec1), MathUtils.convert(vec2));
    }

    public static double[][] convert(double[] input) {
        double[][] mtx = new double[][]{input};
        return mtx;
    }

    public static String toString(double[][] array) {
        StringBuilder builder = new StringBuilder();
        for (int s = 0; s < array.length; ++s) {
            for (int d = 0; d < array[s].length; ++d) {
                builder.append(array[s][d] + (d == array[s].length - 1 ? "" : " "));
            }
            if (s == array.length) continue;
            builder.append("\n");
        }
        return builder.toString();
    }

    public static String toString(double[] array) {
        return MathUtils.toString(MathUtils.convert(array));
    }

    public static double sum(double[] array) {
        double sum = 0.0;
        for (double elt : array) {
            sum += elt;
        }
        return sum;
    }

    public static int argmax(double[] x) {
        double max = Double.NEGATIVE_INFINITY;
        int argmax = -1;
        for (int i = 0; i < x.length; ++i) {
            if (!(x[i] > max)) continue;
            max = x[i];
            argmax = i;
        }
        return argmax;
    }

    public static double[][] clone(double[][] data) {
        double[][] result = new double[data.length][];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (double[])data[i].clone();
        }
        return result;
    }

    public static void normalize(List<Double> ruleMatchPrs) {
        double norm = 0.0;
        for (double x : ruleMatchPrs) {
            if (x < 0.0) {
                throw new RuntimeException();
            }
            norm += x;
        }
        for (int i = 0; i < ruleMatchPrs.size(); ++i) {
            ruleMatchPrs.set(i, ruleMatchPrs.get(i) / norm);
        }
    }

    public static abstract class I2D {
        public abstract double f(int var1);

        public boolean inDom(int i) {
            return true;
        }
    }

    public static interface FPlusDelta {
        public double logfd(double var1);
    }

    public static interface CostFunction<S, T> {
        public List<S> getSs();

        public List<T> getTs();

        public double cost(S var1, T var2);
    }
}

