/*
 * Decompiled with CFR 0.152.
 */
package pepper.editmodel;

import fig.basic.Option;
import goblin.Taxon;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import nuts.maxent.FeatureExtractor;
import nuts.maxent.LabeledInstance;
import nuts.util.Counter;
import nuts.util.CounterMap;
import pepper.Edit;
import pepper.Effect;
import pepper.Encodings;
import pepper.Environment;
import pepper.editmodel.EditParam;
import pepper.editmodel.MaxentParamUpdater;
import pepper.editmodel.MultiDiriParamUpdater;
import pepper.editmodel.features.EditTypeFeaturesExtractor;
import pepper.editmodel.features.MultiGranEditFeaturesExtractor;
import pepper.editmodel.features.UnionOfFeaturesExtractor;

public interface ParamUpdater
extends Serializable {
    public Map<Taxon, EditParam> update(CounterMap<Taxon, Edit> var1, boolean var2);

    public Set<Edit> getSparsityStructure();

    public void setSparsityStructure(Set<Edit> var1);

    public Encodings getEncodings();

    public static class ParamUpdaterOptions {
        @Option
        public boolean useFeatures = true;
        @Option(gloss="Regularization for the feature model")
        public double sigma = 1.0;
        @Option(gloss="Max number of iterations for the feature (maxent) model")
        public int maxentIterations = 20;
        @Option(gloss="Convergence tolerance for the feature model")
        public double maxentTolerance = 1.0E-4;
        @Option(gloss="Feature cutoff for the maxent model, keep only feat with mult. >= cutoff")
        public double cutoff = 0.0;
        @Option(gloss="Project priors? See ConstrainedEditMDParametrization's constructor")
        public boolean projectedPriors = false;
        @Option(gloss="Prior for rules x->x")
        public double alpha_id = 2.0;
        @Option(gloss="Prior for the other rules")
        public double alpha_edit = 0.1;
        @Option(gloss="Randomness for sampling updates")
        public Random rand = new Random(1L);
    }

    public static class ParamUpdaterBuilder {
        private final ParamUpdaterOptions options;
        private final Encodings enc;
        private final List<Edit> rules;

        public ParamUpdaterBuilder(ParamUpdaterOptions options, Encodings enc, List<Edit> rules) {
            this.options = options;
            this.enc = enc;
            this.rules = rules;
        }

        public static FeatureExtractor<LabeledInstance<Environment, Effect>, String> createFeatureExtractor() {
            EditTypeFeaturesExtractor extractor1 = new EditTypeFeaturesExtractor();
            MultiGranEditFeaturesExtractor extractor2 = new MultiGranEditFeaturesExtractor();
            ArrayList<FeatureExtractor<LabeledInstance<Environment, Effect>, String>> extractors = new ArrayList<FeatureExtractor<LabeledInstance<Environment, Effect>, String>>();
            extractors.add(extractor1);
            extractors.add(extractor2);
            return new UnionOfFeaturesExtractor(extractors);
        }

        public ParamUpdater createParamUpdater() {
            if (this.options.useFeatures) {
                MaxentParamUpdater<String> paramUpdater = new MaxentParamUpdater<String>(this.enc, this.rules, ParamUpdaterBuilder.createFeatureExtractor(), this.options.sigma, this.options.maxentIterations, this.options.maxentTolerance, this.options.cutoff);
                return new Adaptor(paramUpdater);
            }
            MultiDiriParamUpdater paramUpdater = new MultiDiriParamUpdater(this.enc, this.options.rand, this.rules, this.options.alpha_id, this.options.alpha_edit, this.options.projectedPriors);
            return new Adaptor(paramUpdater);
        }
    }

    public static class Adaptor
    implements ParamUpdater {
        private static final long serialVersionUID = 1L;
        private final Map<Taxon, LanguageSpecificParamUpdater> map = new HashMap<Taxon, LanguageSpecificParamUpdater>();
        private final LanguageSpecificParamUpdater lspu;

        public Adaptor(LanguageSpecificParamUpdater lspu) {
            this.lspu = lspu;
        }

        @Override
        public Encodings getEncodings() {
            return this.lspu.getEncodings();
        }

        @Override
        public Set<Edit> getSparsityStructure() {
            return this.lspu.getSparsityStructure();
        }

        @Override
        public void setSparsityStructure(Set<Edit> allowedEdits) {
            this.lspu.setSparsityStructure(allowedEdits);
            for (LanguageSpecificParamUpdater lspu : this.map.values()) {
                lspu.setSparsityStructure(allowedEdits);
            }
        }

        public LanguageSpecificParamUpdater getSpecificParamUpdater(Taxon lang) {
            LanguageSpecificParamUpdater result = this.map.get(lang);
            if (result == null) {
                result = this.lspu.newInstance();
                this.map.put(lang, result);
            }
            return result;
        }

        @Override
        public Map<Taxon, EditParam> update(CounterMap<Taxon, Edit> expectedEditCounts, boolean viterbi) {
            HashMap<Taxon, EditParam> result = new HashMap<Taxon, EditParam>();
            for (Taxon lang : expectedEditCounts.keySet()) {
                result.put(lang, this.getSpecificParamUpdater(lang).update(expectedEditCounts.getCounter(lang), viterbi));
            }
            return result;
        }
    }

    public static interface LanguageSpecificParamUpdater
    extends Serializable {
        public EditParam update(Counter<Edit> var1, boolean var2);

        public Set<Edit> getSparsityStructure();

        public void setSparsityStructure(Set<Edit> var1);

        public LanguageSpecificParamUpdater newInstance();

        public Encodings getEncodings();
    }
}

