/*
 * Decompiled with CFR 0.152.
 */
package pty.smc.test;

import fig.basic.LogInfo;
import fig.basic.Option;
import fig.exec.Execution;
import goblin.CognateId;
import goblin.Taxon;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import ma.BalibaseCorpus;
import ma.BioCorpus;
import ma.GeneratedCorpus;
import ma.MultiAlignment;
import nuts.util.Arbre;
import pepper.Encodings;
import pty.eval.SymmetricDiff;
import pty.smc.PartialCoalescentState;
import pty.smc.ParticleFilter;
import pty.smc.ParticleKernel;
import pty.smc.PriorPostKernel;
import pty.smc.PriorPriorKernel;

public class SimpleBioTest
implements Runnable {
    @Option
    public Random rand = new Random(1L);
    @Option
    public int N = 10;
    @Option
    public boolean useGenerated = true;
    @Option
    public double probabilityToMarkObservationAsMissing = 0.5;
    @Option
    public boolean usePriorPost = true;
    private BioCorpus corpus;
    private BalibaseCorpus.BalibaseCorpusOptions bco;
    private GeneratedCorpus.GeneratedCorpusOptions gco;

    public SimpleBioTest(BalibaseCorpus.BalibaseCorpusOptions bco, GeneratedCorpus.GeneratedCorpusOptions gco) {
        this.gco = gco;
        this.bco = bco;
    }

    public Set<Set<Taxon>> inferTree(CognateId id) {
        ParticleFilter.ParticleMapperProcessor<PartialCoalescentState, Set<Set<Taxon>>> mbr = SymmetricDiff.createCladeProcessor();
        ParticleKernel<PartialCoalescentState> kernel = this.usePriorPost ? new PriorPostKernel(this.getInitState(id)) : new PriorPriorKernel(this.getInitState(id));
        ParticleFilter.bootstrapFilter(kernel, mbr, this.N, this.rand);
        for (Set set : mbr.getCounter()) {
            System.out.println(SymmetricDiff.clades2arbre(set).deepToLispString() + "\t" + mbr.getCounter().getCount(set));
        }
        return mbr.centroid(SymmetricDiff.CLADE_SYMMETRIC_DIFFERENCE);
    }

    private PartialCoalescentState getInitState(CognateId id) {
        throw new RuntimeException();
    }

    private int[] toObservationArray(List<Integer> list) {
        int[] result = new int[list.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.rand.nextDouble() < this.probabilityToMarkObservationAsMissing ? -1 : list.get(i);
        }
        return result;
    }

    public static void main(String[] args) {
        BalibaseCorpus.BalibaseCorpusOptions bco = new BalibaseCorpus.BalibaseCorpusOptions();
        GeneratedCorpus.GeneratedCorpusOptions gco = new GeneratedCorpus.GeneratedCorpusOptions();
        Execution.run(args, new SimpleBioTest(bco, gco), "bali", bco, "gen", gco);
    }

    public static Map<Taxon, List<Integer>> getFullColumns(Encodings enc, MultiAlignment ma) {
        Map<Taxon, List<Integer>> result = SimpleBioTest.init(ma.getSequences().keySet());
        for (MultiAlignment.SequenceCoordinate sc : ma.eqClasses().representatives()) {
            if (ma.isReference() && !sc.isCoreBlock() || ma.eqClasses().eqClass(sc).size() != ma.getSequences().size()) continue;
            SimpleBioTest.process(ma.eqClasses().eqClass(sc), result, enc);
        }
        return result;
    }

    private static void process(Set<MultiAlignment.SequenceCoordinate> eqClass, Map<Taxon, List<Integer>> result, Encodings enc) {
        for (MultiAlignment.SequenceCoordinate sc : eqClass) {
            result.get(sc.getNodeIdentifier()).add(enc.char2PhoneId(sc.getCharValue()));
        }
    }

    private static Map<Taxon, List<Integer>> init(Set<Taxon> keySet) {
        HashMap<Taxon, List<Integer>> result = new HashMap<Taxon, List<Integer>>();
        for (Taxon lang : keySet) {
            result.put(lang, new ArrayList());
        }
        return result;
    }

    @Override
    public void run() {
        this.corpus = this.useGenerated ? new GeneratedCorpus(this.gco) : new BalibaseCorpus(this.bco);
        for (CognateId id : this.corpus.intersectedIds()) {
            this.evaluate(id);
        }
    }

    private void evaluate(CognateId id) {
        LogInfo.track((Object)("Evaluating " + id), true);
        Set recon = this.inferTree(id);
        Arbre<Taxon> gold = Arbre.tree2Arbre(this.corpus.getTopology(id)).preOrderMap(new Arbre.ArbreMap<String, Taxon>(){

            @Override
            public Taxon map(Arbre<String> currentDomainNode) {
                return new Taxon(currentDomainNode.getContents());
            }
        });
        Arbre reconTree = SymmetricDiff.clades2arbre(recon);
        Set goldClades = SymmetricDiff.clades(gold);
        LogInfo.logs("Gold=" + SymmetricDiff.clades2arbre(goldClades).deepToString());
        LogInfo.logs("Recon=" + reconTree.deepToString());
        LogInfo.logs("SymmetricCladeDiff(norm)=" + SymmetricDiff.symmetricDifferenceSize(recon, goldClades) + "(" + SymmetricDiff.normalizedSymmetricCladeDiff(reconTree, gold) + ")");
        LogInfo.end_track();
    }
}

